/*     */ package org.jboss.aop.instrument;
/*     */ 
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField.Initializer;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.classpool.AOPClassPool;
/*     */ 
/*     */ public class ClassicInstrumentor extends Instrumentor
/*     */ {
/*  47 */   public static final String HELPER_CLASS_NAME = Instrumentor.AOP_PACKAGE + ".ClassAdvisor";
/*     */ 
/*     */   public ClassicInstrumentor(AOPClassPool pool, AspectManager manager, JoinpointClassifier joinpointClassifier, DynamicTransformationObserver observer)
/*     */   {
/*  52 */     super(pool, manager, joinpointClassifier, observer);
/*     */   }
/*     */ 
/*     */   public ClassicInstrumentor(AspectManager manager, JoinpointClassifier joinpointClassifier)
/*     */   {
/*  60 */     super(manager, joinpointClassifier);
/*     */   }
/*     */ 
/*     */   protected void intitialiseTransformers()
/*     */   {
/*  66 */     if (AspectManager.optimize)
/*     */     {
/*  68 */       this.methodExecutionTransformer = new OptimizedMethodExecutionTransformer(this);
/*  69 */       this.constructorExecutionTransformer = new OptimizedConstructorExecutionTransformer(this);
/*  70 */       this.fieldAccessTransformer = new OptimizedFieldAccessTransformer(this);
/*  71 */       this.constructionTransformer = new OptimizedConstructionTransformer(this);
/*  72 */       this.callerTransformer = new OptimizedCallerTransformer(this, this.manager);
/*     */     }
/*     */     else
/*     */     {
/*  76 */       this.methodExecutionTransformer = new NonOptimizedMethodExecutionTransformer(this);
/*  77 */       this.constructorExecutionTransformer = new NonOptimizedConstructorExecutionTransformer(this);
/*  78 */       this.fieldAccessTransformer = new NonOptimizedFieldAccessTransformer(this);
/*  79 */       this.constructionTransformer = new NonOptimizedConstructionTransformer(this);
/*  80 */       this.callerTransformer = new NonOptimizedCallerTransformer(this, this.manager);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected CtMethod createMixinInvokeMethod(CtClass clazz, CtClass mixinClass, String initializer, CtMethod method, long hash)
/*     */     throws CannotCompileException, NotFoundException, Exception
/*     */   {
/*  87 */     String code = null;
/*  88 */     String aopReturnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
/*  89 */     String returnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ";
/*  90 */     String args = "null";
/*  91 */     if (method.getParameterTypes().length > 0) args = "$args";
/*     */ 
/* 114 */     code = "{ " + returnStr + " " + mixinFieldName(mixinClass) + "." + method.getName() + "($$); " + "}";
/*     */ 
/* 118 */     String wrappedName = ClassAdvisor.notAdvisedMethodName(clazz.getName(), method.getName());
/* 119 */     CtMethod nmethod = CtNewMethod.make(method.getReturnType(), wrappedName, method.getParameterTypes(), method.getExceptionTypes(), code, clazz);
/*     */ 
/* 121 */     int modifier = method.getModifiers();
/* 122 */     if ((modifier & 0x400) == 1024)
/*     */     {
/* 124 */       modifier &= -1025;
/*     */     }
/* 126 */     nmethod.setModifiers(modifier);
/* 127 */     clazz.addMethod(nmethod);
/*     */ 
/* 132 */     code = "{    if (" + mixinFieldName(mixinClass) + " == null) { " + "      this." + mixinFieldName(mixinClass) + " = " + initializer + "; " + "   } " + "   org.jboss.aop.ClassInstanceAdvisor instAdv = (org.jboss.aop.ClassInstanceAdvisor)_getInstanceAdvisor();" + "   if (" + "aop$classAdvisor$aop" + ".hasAspects() || (instAdv != null && instAdv.hasInstanceAspects)) " + "   { " + "      Object[] ags = " + args + "; " + "      " + aopReturnStr + "aop$classAdvisor$aop" + ".invokeMethod(instAdv, this, " + hash + "L, ags); " + "   } " + "   else " + "   {" + "      " + returnStr + " " + mixinFieldName(mixinClass) + "." + method.getName() + "($$); " + "   }" + "}";
/*     */ 
/* 149 */     CtMethod wmethod = CtNewMethod.make(method.getReturnType(), method.getName(), method.getParameterTypes(), method.getExceptionTypes(), code, clazz);
/*     */ 
/* 151 */     wmethod.setModifiers(modifier);
/* 152 */     clazz.addMethod(wmethod);
/*     */ 
/* 154 */     return wmethod;
/*     */   }
/*     */ 
/*     */   protected void doSetupBasics(CtClass clazz)
/*     */     throws CannotCompileException, NotFoundException
/*     */   {
/* 161 */     addHelperClass(clazz);
/*     */ 
/* 163 */     if (isBaseClass(clazz))
/*     */     {
/* 165 */       addBaseElements(clazz);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void addHelperField(CtClass clazz) throws CannotCompileException, NotFoundException
/*     */   {
/* 171 */     addStaticField(clazz, "aop$classAdvisor$aop", HELPER_CLASS_NAME, CtField.Initializer.byExpr(ASPECT_MANAGER_CLASS_NAME + ".instance().getAdvisor(java.lang.Class#forName(\"" + clazz.getName() + "\"))"));
/*     */   }
/*     */ 
/*     */   private void addHelperClass(CtClass clazz)
/*     */     throws CannotCompileException, NotFoundException
/*     */   {
/* 184 */     addHelperField(clazz);
/*     */ 
/* 186 */     CtMethod getter = CtNewMethod.make("public org.jboss.aop.Advisor _getAdvisor(){     return aop$classAdvisor$aop;}", clazz);
/*     */ 
/* 191 */     clazz.addMethod(getter);
/*     */   }
/*     */ 
/*     */   private void addBaseElements(CtClass clazz)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/* 197 */     addProtectedField(clazz, "_instanceAdvisor", "org.jboss.aop.ClassInstanceAdvisor", null);
/*     */ 
/* 203 */     CtMethod getter = CtNewMethod.make("public org.jboss.aop.InstanceAdvisor _getInstanceAdvisor(){     synchronized(this) {       if (_instanceAdvisor == null) { _instanceAdvisor = new org.jboss.aop.ClassInstanceAdvisor(this); }       return _instanceAdvisor;    } }", clazz);
/*     */ 
/* 211 */     clazz.addMethod(getter);
/*     */ 
/* 213 */     CtMethod setter = CtNewMethod.make("public void _setInstanceAdvisor(org.jboss.aop.InstanceAdvisor newAdvisor){     synchronized(this) {       _instanceAdvisor = (org.jboss.aop.ClassInstanceAdvisor)newAdvisor;    } }", clazz);
/*     */ 
/* 220 */     clazz.addMethod(setter);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.ClassicInstrumentor
 * JD-Core Version:    0.6.0
 */