/*    */ package org.jboss.aop.instrument;
/*    */ 
/*    */ import javassist.CannotCompileException;
/*    */ import javassist.CtClass;
/*    */ import javassist.CtField.Initializer;
/*    */ import javassist.NotFoundException;
/*    */ 
/*    */ public abstract class CallerInfoAdder
/*    */ {
/*    */   Instrumentor instrumentor;
/* 39 */   int infoModifier = 10;
/*    */ 
/*    */   protected CallerInfoAdder(Instrumentor instrumentor)
/*    */   {
/* 43 */     this.instrumentor = instrumentor;
/*    */   }
/*    */ 
/*    */   protected CallerInfoAdder(Instrumentor instrumentor, int mod)
/*    */   {
/* 48 */     this.instrumentor = instrumentor;
/* 49 */     this.infoModifier = mod;
/*    */   }
/*    */   protected abstract void addMethodByMethodInfoField(CtClass paramCtClass, String paramString1, long paramLong1, String paramString2, long paramLong2) throws NotFoundException, CannotCompileException;
/*    */ 
/*    */   protected abstract void addConByMethodInfoField(CtClass paramCtClass, String paramString1, long paramLong1, String paramString2, long paramLong2) throws NotFoundException, CannotCompileException;
/*    */ 
/*    */   protected abstract void addConByConInfoField(CtClass paramCtClass, String paramString1, String paramString2, int paramInt, String paramString3, long paramLong) throws NotFoundException, CannotCompileException;
/*    */ 
/*    */   protected abstract void addMethodByConInfoField(CtClass paramCtClass, String paramString1, String paramString2, int paramInt, String paramString3, long paramLong) throws NotFoundException, CannotCompileException;
/*    */ 
/* 63 */   protected void addConByConInfoField(CtClass addTo, String fieldName, String init) throws NotFoundException, CannotCompileException { addField(addTo, "org.jboss.aop.ConByConInfo", fieldName, init);
/*    */   }
/*    */ 
/*    */   protected void addConByMethodInfoField(CtClass addTo, String fieldName, String init)
/*    */     throws NotFoundException, CannotCompileException
/*    */   {
/* 69 */     addField(addTo, "org.jboss.aop.ConByMethodInfo", fieldName, init);
/*    */   }
/*    */ 
/*    */   protected void addMethodByConInfoField(CtClass addTo, String fieldName, String init)
/*    */     throws NotFoundException, CannotCompileException
/*    */   {
/* 75 */     addField(addTo, "org.jboss.aop.MethodByConInfo", fieldName, init);
/*    */   }
/*    */ 
/*    */   protected void addMethodByMethodInfoField(CtClass addTo, String fieldName, String init)
/*    */     throws NotFoundException, CannotCompileException
/*    */   {
/* 81 */     addField(addTo, "org.jboss.aop.MethodByMethodInfo", fieldName, init);
/*    */   }
/*    */ 
/*    */   private void addField(CtClass addTo, String typeName, String fieldName, String init)
/*    */     throws NotFoundException, CannotCompileException
/*    */   {
/* 87 */     CtField.Initializer initializer = init != null ? CtField.Initializer.byExpr(init) : null;
/* 88 */     TransformerCommon.addInfoField(this.instrumentor, typeName, fieldName, this.infoModifier, addTo, addInfoAsWeakReference(), initializer);
/*    */   }
/*    */ 
/*    */   protected abstract boolean addInfoAsWeakReference();
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.instrument.CallerInfoAdder
 * JD-Core Version:    0.6.0
 */