/*     */ package org.jboss.aop.hook;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.LoaderClassPath;
/*     */ import javassist.NotFoundException;
/*     */ 
/*     */ public class GeneratePluggableInstrumentedClassLoader
/*     */ {
/*     */   private static void declare5(CtClass clazz, CtMethod method)
/*     */     throws NotFoundException, CannotCompileException
/*     */   {
/*  46 */     method.setName("wrappedDefineClass");
/*  47 */     CtMethod wrapper = CtNewMethod.make(4, method.getReturnType(), "defineClass", method.getParameterTypes(), method.getExceptionTypes(), null, clazz);
/*     */ 
/*  49 */     String code = "{  byte[] newBytes = org.jboss.aop.hook.JDK14TransformerManager.transform($0, $1, $2) ;  if (newBytes != (byte[])null) {    return wrappedDefineClass($1, newBytes, 0, newBytes.length, $5);   } else {    return wrappedDefineClass($1, $2, $3, $4, $5);   }}";
/*     */ 
/*  57 */     wrapper.setBody(code);
/*  58 */     clazz.addMethod(wrapper);
/*     */   }
/*     */ 
/*     */   public static byte[] getInstrumentedClassLoader()
/*     */     throws NotFoundException, IOException, CannotCompileException
/*     */   {
/*  74 */     ClassPool classpool = ClassPool.getDefault();
/*  75 */     classpool = ClassPool.getDefault();
/*  76 */     ClassLoader cl = SecurityActions.getContextClassLoader();
/*  77 */     classpool.insertClassPath(new LoaderClassPath(cl));
/*     */ 
/*  79 */     CtClass clazz = classpool.get(ClassLoader.class.getName());
/*  80 */     CtMethod[] methods = clazz.getDeclaredMethods();
/*  81 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/*  83 */       if (!methods[i].getName().equals("defineClass"))
/*     */         continue;
/*  85 */       if ((methods[i].getParameterTypes().length != 5) || (!methods[i].getParameterTypes()[1].isArray())) {
/*     */         continue;
/*     */       }
/*  88 */       declare5(clazz, methods[i]);
/*     */     }
/*     */ 
/*  92 */     return clazz.toBytecode();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 102 */     if (args.length != 1)
/*     */     {
/* 104 */       System.err.println("Usage: java " + GeneratePluggableInstrumentedClassLoader.class.getName() + " <output directory>");
/* 105 */       System.exit(1);
/*     */     }
/* 107 */     String filename = args[0] + File.separatorChar + "java" + File.separatorChar + "lang" + File.separatorChar + "ClassLoader.class";
/*     */ 
/* 111 */     File file = new File(filename);
/* 112 */     if (file.exists())
/*     */     {
/* 114 */       if (!file.canWrite())
/*     */       {
/* 116 */         System.err.println("Cannot write to existing file: " + file.getAbsolutePath());
/* 117 */         System.exit(2);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 122 */       File dir = file.getParentFile();
/* 123 */       if (!dir.exists())
/*     */       {
/* 125 */         dir.mkdirs();
/*     */       }
/* 127 */       if (!dir.canWrite())
/*     */       {
/* 129 */         System.err.println("Cannot write to parent directory: " + dir.getAbsolutePath());
/*     */       }
/*     */     }
/*     */     byte[] bytes;
/*     */     try
/*     */     {
/* 136 */       bytes = getInstrumentedClassLoader();
/*     */     }
/*     */     catch (Throwable th)
/*     */     {
/* 140 */       System.err.println("Unexpected exception caught during instrumentation: " + th.getMessage());
/* 141 */       th.printStackTrace(System.err);
/* 142 */       System.exit(5);
/* 143 */       return;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 148 */       FileOutputStream fos = new FileOutputStream(file);
/* 149 */       fos.write(bytes);
/* 150 */       fos.close();
/*     */     }
/*     */     catch (IOException ioe)
/*     */     {
/* 154 */       System.err.println("Unexpected exception caught while writing class file: " + ioe.getMessage());
/* 155 */       ioe.printStackTrace(System.err);
/* 156 */       System.exit(6);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.hook.GeneratePluggableInstrumentedClassLoader
 * JD-Core Version:    0.6.0
 */