/*     */ package org.jboss.aop.expressions;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.StringTokenizer;
/*     */ import java.util.regex.Matcher;
/*     */ import java.util.regex.Pattern;
/*     */ import javassist.CtClass;
/*     */ 
/*     */ public class ParameterExpression
/*     */ {
/*  46 */   protected static final Pattern ALL = Pattern.compile("\\s*\\.\\.\\s*");
/*  47 */   protected static final Pattern PARAMS = Pattern.compile("\\s*(.*)\\s*");
/*     */   public String originalExpression;
/*     */   public Pattern[] parameterPatterns;
/*  53 */   public boolean isAll = false;
/*     */ 
/*     */   protected static String simpleType(Class type)
/*     */   {
/*  57 */     Class ret = type;
/*  58 */     if (ret.isArray())
/*     */     {
/*  60 */       Class arr = ret;
/*  61 */       String array = "";
/*  62 */       while (arr.isArray())
/*     */       {
/*  64 */         array = array + "[]";
/*  65 */         arr = arr.getComponentType();
/*     */       }
/*  67 */       return arr.getName() + array;
/*     */     }
/*  69 */     return ret.getName();
/*     */   }
/*     */ 
/*     */   public ParameterExpression(String expression)
/*     */   {
/*  77 */     this.originalExpression = expression;
/*  78 */     Matcher all = ALL.matcher(expression);
/*  79 */     this.isAll = all.matches();
/*  80 */     if (!this.isAll)
/*     */     {
/*  82 */       Matcher params = PARAMS.matcher(expression);
/*  83 */       if (!params.matches())
/*     */       {
/*  85 */         throw new RuntimeException("Illegal parameter list expression: " + expression);
/*     */       }
/*  87 */       StringTokenizer tokenizer = new StringTokenizer(expression, ",");
/*  88 */       ArrayList paramList = new ArrayList();
/*  89 */       while (tokenizer.hasMoreTokens())
/*     */       {
/*  91 */         String token = tokenizer.nextToken().trim();
/*  92 */         token = token.replaceAll("\\.", "\\\\.");
/*  93 */         token = token.replaceAll("\\*", ".*");
/*  94 */         token = token.replaceAll("\\[", "\\\\[");
/*  95 */         token = token.replaceAll("\\]", "\\\\]");
/*  96 */         paramList.add(Pattern.compile(token));
/*     */       }
/*  98 */       this.parameterPatterns = ((Pattern[])(Pattern[])paramList.toArray(new Pattern[paramList.size()]));
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean matches(Class[] params)
/*     */   {
/* 104 */     if (this.isAll)
/*     */     {
/* 106 */       return true;
/*     */     }
/*     */ 
/* 109 */     if (params.length != this.parameterPatterns.length) return false;
/*     */ 
/* 111 */     for (int i = 0; i < params.length; i++)
/*     */     {
/* 113 */       String asString = simpleType(params[i]);
/* 114 */       Matcher m = this.parameterPatterns[i].matcher(asString);
/* 115 */       if (!m.matches()) return false;
/*     */     }
/* 117 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean matches(CtClass[] params)
/*     */   {
/* 122 */     if (this.isAll) return true;
/*     */ 
/* 124 */     if (params.length != this.parameterPatterns.length) return false;
/*     */ 
/* 126 */     for (int i = 0; i < params.length; i++)
/*     */     {
/* 128 */       String asString = params[i].getName();
/* 129 */       Matcher m = this.parameterPatterns[i].matcher(asString);
/* 130 */       if (!m.matches()) return false;
/*     */     }
/* 132 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.expressions.ParameterExpression
 * JD-Core Version:    0.6.0
 */