/*    */ package org.jboss.aop.expressions;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import java.util.regex.Matcher;
/*    */ import java.util.regex.Pattern;
/*    */ import javassist.CtClass;
/*    */ import javassist.CtMethod;
/*    */ import javassist.NotFoundException;
/*    */ 
/*    */ public class MethodExpression
/*    */ {
/* 40 */   protected static final Pattern PATTERN = Pattern.compile("(.*)\\s+(.*)\\((.*)\\)");
/*    */   public String originalExpression;
/*    */   public ParameterExpression params;
/*    */   public Pattern methodNameExpr;
/*    */   public String methodName;
/*    */   public String returnString;
/*    */   public Pattern returnExpr;
/*    */ 
/*    */   public MethodExpression(String ex)
/*    */   {
/* 50 */     this.originalExpression = ex;
/* 51 */     Matcher m = PATTERN.matcher(ex);
/* 52 */     if (!m.matches()) throw new IllegalStateException("MethodExpression is invalid: " + ex);
/* 53 */     this.returnString = m.group(1);
/* 54 */     this.returnString = this.returnString.replaceAll("\\.", "\\\\.");
/* 55 */     this.returnString = this.returnString.replaceAll("\\*", ".*");
/* 56 */     this.returnString = this.returnString.replaceAll("\\[", "\\\\[");
/* 57 */     this.returnString = this.returnString.replaceAll("\\]", "\\\\]");
/* 58 */     this.returnExpr = Pattern.compile(this.returnString);
/* 59 */     this.methodName = m.group(2);
/* 60 */     this.methodName = this.methodName.replaceAll("\\.", "\\\\.");
/* 61 */     this.methodName = this.methodName.replaceAll("\\*", ".*");
/* 62 */     this.methodName = this.methodName.replaceAll("\\[", "\\\\[");
/* 63 */     this.methodName = this.methodName.replaceAll("\\]", "\\\\]");
/* 64 */     this.methodNameExpr = Pattern.compile(this.methodName);
/* 65 */     this.params = new ParameterExpression(m.group(3));
/*    */   }
/*    */ 
/*    */   public boolean matches(Method method)
/*    */   {
/* 71 */     String returnType = ParameterExpression.simpleType(method.getReturnType());
/* 72 */     Matcher ret = this.returnExpr.matcher(returnType);
/* 73 */     if (!ret.matches()) return false;
/*    */ 
/* 75 */     Matcher cm = this.methodNameExpr.matcher(method.getName());
/* 76 */     if (!cm.matches()) return false;
/*    */ 
/* 78 */     return this.params.matches(method.getParameterTypes());
/*    */   }
/*    */ 
/*    */   public boolean matches(CtMethod method) throws NotFoundException
/*    */   {
/* 83 */     String returnType = method.getReturnType().getName();
/* 84 */     Matcher ret = this.returnExpr.matcher(returnType);
/* 85 */     if (!ret.matches()) return false;
/*    */ 
/* 87 */     Matcher cm = this.methodNameExpr.matcher(method.getName());
/* 88 */     if (!cm.matches()) return false;
/*    */ 
/* 90 */     return this.params.matches(method.getParameterTypes());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.expressions.MethodExpression
 * JD-Core Version:    0.6.0
 */