/*     */ package org.jboss.aop.eclipsesupport;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.lang.instrument.ClassFileTransformer;
/*     */ import java.lang.instrument.IllegalClassFormatException;
/*     */ import java.net.URL;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.Vector;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.AspectXmlLoader;
/*     */ import org.jboss.aop.standalone.AOPTransformer;
/*     */ 
/*     */ public class EclipseTestTransformer
/*     */   implements ClassFileTransformer
/*     */ {
/*  50 */   AOPTransformer aopTransformer = new AOPTransformer();
/*     */   boolean foundRemoteTestRunner;
/*     */   static final String MAIN_CLASS = "org/eclipse/jdt/internal/junit/runner/RemoteTestRunner";
/*     */   public static final String CLASSLOADER_DEPLOYED_XML = "jboss.aop.eclipse.test.xml.name";
/*     */ 
/*     */   public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer)
/*     */     throws IllegalClassFormatException
/*     */   {
/*  69 */     if ((!this.foundRemoteTestRunner) && (className.equals("org/eclipse/jdt/internal/junit/runner/RemoteTestRunner")))
/*     */     {
/*  71 */       System.out.println("Found class " + className);
/*  72 */       return weaveRemoteTestRunner(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
/*     */     }
/*  74 */     return this.aopTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
/*     */   }
/*     */ 
/*     */   private byte[] weaveRemoteTestRunner(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException
/*     */   {
/*     */     try
/*     */     {
/*  81 */       AspectManager manager = AspectManager.instance();
/*  82 */       ClassPool pool = manager.registerClassLoader(loader);
/*  83 */       CtClass remoteTestRunner = pool.get("org/eclipse/jdt/internal/junit/runner/RemoteTestRunner".replace('/', '.'));
/*  84 */       remoteTestRunner.defrost();
/*     */ 
/*  86 */       CtMethod originalMain = remoteTestRunner.getMethod("main", "([Ljava/lang/String;)V");
/*  87 */       System.out.println("-----> Found CtMethod " + (originalMain != null));
/*     */ 
/*  89 */       CtMethod wrapper = CtNewMethod.copy(originalMain, remoteTestRunner, null);
/*  90 */       originalMain.setName("originalMain");
/*     */ 
/*  92 */       String body = "{  org.jboss.aop.eclipsesupport.EclipseTestTransformer.recordClassNameAndDeployXml($$);  originalMain($$);}";
/*     */ 
/*  98 */       wrapper.setBody(body);
/*  99 */       remoteTestRunner.addMethod(wrapper);
/*     */ 
/* 101 */       remoteTestRunner.debugWriteFile();
/* 102 */       return remoteTestRunner.toBytecode();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 107 */       System.out.println("====> Exception " + e);
/* 108 */       e.printStackTrace();
/* 109 */     }throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public static void recordClassNameAndDeployXml(String[] args)
/*     */     throws Exception
/*     */   {
/* 116 */     String[] fTestClassNames = null;
/* 117 */     for (int i = 0; i < args.length; i++)
/*     */     {
/* 119 */       if ((!args[i].toLowerCase().equals("-classnames")) && (!args[i].toLowerCase().equals("-classname")))
/*     */         continue;
/* 121 */       Vector list = new Vector();
/* 122 */       for (int j = i + 1; j < args.length; j++)
/*     */       {
/* 124 */         if (args[j].startsWith("-"))
/*     */         {
/*     */           break;
/*     */         }
/* 128 */         list.add(args[j]);
/*     */       }
/*     */ 
/* 131 */       fTestClassNames = (String[])(String[])list.toArray(new String[list.size()]);
/*     */     }
/*     */ 
/* 135 */     if ((fTestClassNames == null) || (fTestClassNames.length == 0))
/*     */     {
/* 137 */       throw new RuntimeException("No classnames could be found");
/*     */     }
/* 139 */     if (fTestClassNames.length > 1)
/*     */     {
/* 141 */       throw new RuntimeException("Only one class name is supported");
/*     */     }
/*     */ 
/* 144 */     deployXmlForEclipse(fTestClassNames[0]);
/*     */   }
/*     */ 
/*     */   public static void deployXmlForEclipse(String testClass)
/*     */     throws Exception
/*     */   {
/* 153 */     if (System.getProperty("jboss.aop.path") != null)
/*     */     {
/* 155 */       return;
/*     */     }
/*     */ 
/* 159 */     String testName = null;
/* 160 */     if (testClass.contains(".regression."))
/*     */     {
/* 163 */       testName = "regression";
/*     */     }
/*     */     else
/*     */     {
/* 167 */       int dot = testClass.lastIndexOf('.');
/* 168 */       String packageName = testClass.substring(0, dot);
/* 169 */       dot = packageName.lastIndexOf('.');
/* 170 */       testName = packageName.substring(dot + 1);
/*     */     }
/*     */ 
/* 173 */     testName = "test/" + testName + "/jboss-aop.xml";
/* 174 */     URL url = Thread.currentThread().getContextClassLoader().getResource(testName);
/*     */ 
/* 176 */     if (url != null)
/*     */     {
/* 178 */       System.setProperty("jboss.aop.eclipse.test.xml.name", testName);
/* 179 */       AspectXmlLoader.deployXML(url);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.eclipsesupport.EclipseTestTransformer
 * JD-Core Version:    0.6.0
 */