/*     */ package org.jboss.aop.domain;
/*     */ 
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.advice.AspectDefinition;
/*     */ import org.jboss.mx.loading.HeirarchicalLoaderRepository3;
/*     */ import org.jboss.mx.loading.LoaderRepository;
/*     */ import org.jboss.mx.loading.RepositoryClassLoader;
/*     */ 
/*     */ public class ScopedRepositoryClassLoaderDomain extends ScopedClassLoaderDomain
/*     */ {
/*     */   public ScopedRepositoryClassLoaderDomain(ClassLoader loader, String name, boolean parentDelegation, AspectManager manager, boolean parentFirst)
/*     */   {
/*  43 */     super(loader, name, parentDelegation, manager, parentFirst);
/*     */   }
/*     */ 
/*     */   public boolean isValid()
/*     */   {
/*  49 */     RepositoryClassLoader cl = (RepositoryClassLoader)getClassLoader();
/*  50 */     if (cl == null)
/*  51 */       return false;
/*  52 */     return cl.getLoaderRepository() != null;
/*     */   }
/*     */ 
/*     */   protected Object getPerVmAspectWithNoParentDelegation(String def)
/*     */   {
/*  57 */     Object aspect = this.myPerVMAspects.get(def);
/*  58 */     if (aspect != null)
/*     */     {
/*  60 */       return aspect;
/*     */     }
/*     */ 
/*  63 */     aspect = super.getSuperPerVmAspect(def);
/*  64 */     if (aspect != null)
/*     */     {
/*  66 */       LoaderRepository loadingRepository = getAspectRepository(aspect);
/*  67 */       LoaderRepository myRepository = getScopedRepository();
/*  68 */       if (loadingRepository == myRepository)
/*     */       {
/*  71 */         this.myPerVMAspects.put(def, aspect);
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/*  78 */           Class clazz = myRepository.loadClass(aspect.getClass().getName());
/*  79 */           if (clazz == aspect.getClass())
/*     */           {
/*  81 */             this.notMyPerVMAspects.put(def, Boolean.TRUE);
/*     */           }
/*     */           else
/*     */           {
/*  86 */             AspectDefinition aspectDefinition = getAspectDefinition(def);
/*     */ 
/*  88 */             aspect = createPerVmAspect(def, aspectDefinition, getClassLoader());
/*  89 */             this.myPerVMAspects.put(def, aspect);
/*     */           }
/*     */         }
/*     */         catch (ClassNotFoundException e)
/*     */         {
/*  94 */           throw new RuntimeException(e);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*  99 */     return aspect;
/*     */   }
/*     */ 
/*     */   private LoaderRepository getAspectRepository(Object aspect)
/*     */   {
/* 106 */     ClassLoader cl = aspect.getClass().getClassLoader();
/* 107 */     ClassLoader parent = cl;
/* 108 */     while (parent != null)
/*     */     {
/* 110 */       if ((parent instanceof RepositoryClassLoader))
/*     */       {
/* 112 */         return ((RepositoryClassLoader)parent).getLoaderRepository();
/*     */       }
/* 114 */       parent = parent.getParent();
/*     */     }
/* 116 */     return null;
/*     */   }
/*     */ 
/*     */   private HeirarchicalLoaderRepository3 getScopedRepository()
/*     */   {
/* 121 */     ClassLoader classloader = getClassLoader();
/* 122 */     if (classloader == null)
/* 123 */       throw new IllegalStateException("ClassLoader no longer exists: " + this.classLoaderString);
/* 124 */     if (!(classloader instanceof RepositoryClassLoader))
/* 125 */       throw new IllegalStateException("ClassLoader is not an instanceof RepositoryClassLoader " + this.classLoaderString);
/* 126 */     RepositoryClassLoader repositoryClassLoader = (RepositoryClassLoader)classloader;
/* 127 */     LoaderRepository loaderRepository = repositoryClassLoader.getLoaderRepository();
/* 128 */     if (loaderRepository == null)
/* 129 */       throw new IllegalStateException("ClassLoader has been undeployed: " + this.classLoaderString);
/* 130 */     if (!(loaderRepository instanceof HeirarchicalLoaderRepository3))
/* 131 */       throw new IllegalStateException("Repository " + loaderRepository + " for classlaoder " + this.classLoaderString + " is not an HeirarchicalLoaderRepository3");
/* 132 */     return (HeirarchicalLoaderRepository3)loaderRepository;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.domain.ScopedRepositoryClassLoaderDomain
 * JD-Core Version:    0.6.0
 */