/*     */ package org.jboss.aop.deployment;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.util.Iterator;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.Notification;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.aop.AspectAnnotationLoader;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.AspectXmlLoader;
/*     */ import org.jboss.aop.asintegration.jboss4.ScopedRepositoryClassLoaderHelper;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.deployment.DeploymentInfo;
/*     */ import org.jboss.deployment.DeploymentState;
/*     */ import org.jboss.deployment.SubDeployer;
/*     */ import org.jboss.deployment.SubDeployerSupport;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.loading.HeirarchicalLoaderRepository3;
/*     */ import org.jboss.mx.loading.LoaderRepository;
/*     */ import org.jboss.mx.loading.RepositoryClassLoader;
/*     */ import org.jboss.util.file.ArchiveBrowser;
/*     */ import org.jboss.util.file.ClassFileFilter;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class AspectDeployer extends SubDeployerSupport
/*     */   implements SubDeployer, AspectDeployerMBean
/*     */ {
/*     */   public AspectDeployer()
/*     */   {
/*  74 */     initializeMainDeployer();
/*     */   }
/*     */ 
/*     */   protected void initializeMainDeployer()
/*     */   {
/*  85 */     setSuffixes(new String[] { ".aop", "-aop.xml" });
/*  86 */     setRelativeOrder(100);
/*     */   }
/*     */ 
/*     */   public boolean accepts(DeploymentInfo di)
/*     */   {
/*  97 */     String urlStr = di.url.toString();
/*  98 */     return (urlStr.endsWith(".aop")) || (urlStr.endsWith(".aop/")) || (urlStr.endsWith("-aop.xml"));
/*     */   }
/*     */ 
/*     */   public void init(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 114 */       if (di.watch == null)
/*     */       {
/* 117 */         if (di.url.getProtocol().equals("file"))
/*     */         {
/* 119 */           File file = new File(di.url.getFile());
/*     */ 
/* 122 */           if (!file.isDirectory())
/*     */           {
/* 124 */             di.watch = di.url;
/*     */           }
/*     */           else
/*     */           {
/* 129 */             di.watch = new URL(di.url, "META-INF/jboss-aop.xml");
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 135 */           di.watch = di.url;
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 141 */       this.log.error("failed to parse AOP document: ", e);
/* 142 */       throw new DeploymentException(e);
/*     */     }
/* 144 */     super.init(di);
/*     */   }
/*     */ 
/*     */   public void create(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/* 157 */     ClassLoader old = Thread.currentThread().getContextClassLoader();
/*     */     try
/*     */     {
/* 160 */       URL docURL = getDocUrl(di);
/* 161 */       ClassLoader scl = getScopedClassLoader(di, docURL);
/*     */ 
/* 163 */       if (scl != null)
/*     */       {
/* 165 */         this.log.info("AOP deployment is scoped using classloader " + scl);
/*     */       }
/*     */ 
/* 168 */       Thread.currentThread().setContextClassLoader(di.ucl);
/* 169 */       AspectManager manager = scl != null ? AspectManager.instance(scl) : AspectManager.instance();
/* 170 */       if (!di.isXML)
/*     */       {
/* 172 */         Iterator it = ArchiveBrowser.getBrowser(di.localUrl, new ClassFileFilter());
/* 173 */         AspectAnnotationLoader loader = new AspectAnnotationLoader(manager);
/* 174 */         loader.setClassLoader(scl);
/* 175 */         loader.deployInputStreamIterator(it);
/*     */       }
/*     */ 
/* 178 */       AspectXmlLoader.deployXML(docURL, scl, manager);
/* 179 */       Notification msg = new Notification("AOP Deploy", this, getNextNotificationSequenceNumber());
/* 180 */       sendNotification(msg);
/* 181 */       this.log.debug("Deployed AOP: " + di.url);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 185 */       ex.printStackTrace();
/* 186 */       throw new DeploymentException(ex);
/*     */     }
/*     */     finally
/*     */     {
/* 190 */       Thread.currentThread().setContextClassLoader(old);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop(DeploymentInfo di)
/*     */   {
/* 221 */     if (di.state != DeploymentState.STARTED)
/*     */     {
/* 223 */       this.log.debug("Ignoring request to stop '" + di.url + "', current state: " + di.state);
/* 224 */       return;
/*     */     }
/*     */ 
/* 227 */     this.log.debug("undeploying document " + di.url);
/* 228 */     ClassLoader old = Thread.currentThread().getContextClassLoader();
/*     */     try
/*     */     {
/* 231 */       Thread.currentThread().setContextClassLoader(di.ucl);
/* 232 */       if (!di.isXML)
/*     */       {
/* 234 */         Iterator it = ArchiveBrowser.getBrowser(di.localUrl, new ClassFileFilter());
/* 235 */         AspectAnnotationLoader loader = new AspectAnnotationLoader(AspectManager.instance());
/* 236 */         loader.undeployInputStreamIterator(it);
/*     */       }
/*     */ 
/* 240 */       URL docURL = getDocUrl(di);
/*     */ 
/* 242 */       AspectXmlLoader.undeployXML(docURL);
/* 243 */       AspectManager.instance().unregisterClassLoader(di.ucl);
/*     */ 
/* 250 */       Notification msg = new Notification("AOP Undeploy", this, getNextNotificationSequenceNumber());
/* 251 */       sendNotification(msg);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 255 */       this.log.error("failed to stop", ex);
/*     */     }
/*     */     finally
/*     */     {
/* 259 */       Thread.currentThread().setContextClassLoader(old);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy(DeploymentInfo di)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 282 */     super.startService();
/*     */   }
/*     */ 
/*     */   protected ObjectName getObjectName(MBeanServer server, ObjectName name)
/*     */     throws MalformedObjectNameException
/*     */   {
/* 288 */     return name == null ? OBJECT_NAME : name;
/*     */   }
/*     */ 
/*     */   private URL getDocUrl(DeploymentInfo di) throws DeploymentException
/*     */   {
/* 293 */     URL docURL = di.localUrl;
/* 294 */     if (!di.isXML) {
/* 295 */       docURL = di.localCl.findResource("META-INF/jboss-aop.xml");
/*     */     }
/* 297 */     if (docURL == null)
/* 298 */       throw new DeploymentException("Failed to find META-INF/jboss-aop.xml");
/* 299 */     return docURL;
/*     */   }
/*     */ 
/*     */   private ClassLoader getScopedClassLoader(DeploymentInfo di, URL docUrl)
/*     */     throws Exception
/*     */   {
/* 307 */     if (ScopedRepositoryClassLoaderHelper.isScopedClassLoader(di.ucl))
/*     */     {
/* 309 */       return di.ucl;
/*     */     }
/*     */ 
/* 312 */     LoaderRepository attachToRepository = getLoaderRepositoryIfAttaching(di, docUrl);
/* 313 */     if (attachToRepository != null)
/*     */     {
/* 315 */       di.ucl.setRepository(attachToRepository);
/* 316 */       attachToRepository.addClassLoader(di.ucl);
/* 317 */       return di.ucl;
/*     */     }
/* 319 */     return null;
/*     */   }
/*     */ 
/*     */   private LoaderRepository getLoaderRepositoryIfAttaching(DeploymentInfo di, URL docUrl) throws Exception
/*     */   {
/* 324 */     if (di.parent == null)
/*     */     {
/* 328 */       Document doc = AspectXmlLoader.loadURL(docUrl);
/* 329 */       Element top = doc.getDocumentElement();
/* 330 */       NodeList children = top.getChildNodes();
/* 331 */       int childlength = children.getLength();
/* 332 */       for (int i = 0; i < childlength; i++)
/*     */       {
/* 334 */         Node child = children.item(i);
/* 335 */         if (child.getNodeType() != 1)
/*     */           continue;
/* 337 */         Element element = (Element)child;
/* 338 */         if (!element.getTagName().equals("loader-repository"))
/*     */           continue;
/* 340 */         String repositoryName = null;
/* 341 */         NodeList nestedChildren = child.getChildNodes();
/* 342 */         int nestedChildLength = nestedChildren.getLength();
/* 343 */         for (int j = 0; j < nestedChildLength; j++)
/*     */         {
/* 345 */           Node nestedChild = nestedChildren.item(j);
/* 346 */           if ((nestedChild.getNodeType() != 3) && (nestedChild.getNodeType() != 4))
/*     */             continue;
/* 348 */           repositoryName = nestedChild.getNodeValue().trim();
/* 349 */           break;
/* 352 */         }
/*     */ this.log.info("Should attach deployment to loader repository " + repositoryName);
/*     */         ObjectName on;
/*     */         try {
/* 356 */           on = new ObjectName(repositoryName);
/*     */         }
/*     */         catch (MalformedObjectNameException e)
/*     */         {
/* 360 */           throw new RuntimeException("loader-repository='" + repositoryName + "' is not a valid object name", e);
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/* 365 */           info = this.server.getMBeanInfo(on);
/*     */         }
/*     */         catch (InstanceNotFoundException e)
/*     */         {
/*     */           MBeanInfo info;
/* 369 */           this.log.warn("No scoped loader repository exists with the name " + on);
/*     */         }
/*     */ 
/* 372 */         LoaderRepository repository = (LoaderRepository)this.server.getAttribute(on, "Instance");
/* 373 */         if ((repository instanceof HeirarchicalLoaderRepository3))
/*     */         {
/* 375 */           return repository;
/*     */         }
/*     */ 
/* 379 */         this.log.warn("Loader repository " + on + " is not a isolated loader repository. Deploying aspects in default domain.");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 386 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.deployment.AspectDeployer
 * JD-Core Version:    0.6.0
 */