/*    */ package org.jboss.aop.deployers;
/*    */ 
/*    */ import javax.management.MBeanServer;
/*    */ import javax.management.ObjectName;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class AspectManagerJMXRegistrar
/*    */ {
/* 36 */   static final Logger log = Logger.getLogger(AspectManagerJMXRegistrar.class.getName());
/*    */   static final String ASPECTMANAGER_OBJECTNAME = "jboss.aop:service=AspectManager";
/*    */   MBeanServer server;
/*    */   AbstractAspectManager aspectManager;
/*    */ 
/*    */   public void setMbeanServer(MBeanServer server)
/*    */   {
/* 44 */     this.server = server;
/*    */   }
/*    */ 
/*    */   public void setAspectManager(AbstractAspectManager aspectManager)
/*    */   {
/* 49 */     this.aspectManager = aspectManager;
/*    */   }
/*    */ 
/*    */   public void start() throws Exception
/*    */   {
/*    */     try
/*    */     {
/* 56 */       log.debug("Registering AspectManagerService in JMX under: jboss.aop:service=AspectManager");
/* 57 */       this.server.registerMBean(this.aspectManager.delegate, new ObjectName("jboss.aop:service=AspectManager"));
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 62 */       throw new RuntimeException("Error starting AspectManagerJMXWrapper", e);
/*    */     }
/*    */   }
/*    */ 
/*    */   public void stop()
/*    */   {
/*    */     try
/*    */     {
/* 71 */       log.debug("Unregistering AspectManagerService in JMX under: jboss.aop:service=AspectManager");
/* 72 */       this.server.unregisterMBean(new ObjectName("jboss.aop:service=AspectManager"));
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 77 */       throw new RuntimeException("Error stopping AspectManagerJMXWrapper", e);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.deployers.AspectManagerJMXRegistrar
 * JD-Core Version:    0.6.0
 */