/*    */ package org.jboss.aop.deployers;
/*    */ 
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ import org.jboss.deployers.spi.deployer.DeploymentStages;
/*    */ import org.jboss.deployers.vfs.spi.deployer.JAXPDeployer;
/*    */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*    */ import org.jboss.mx.loading.LoaderRepositoryFactory;
/*    */ import org.jboss.mx.loading.LoaderRepositoryFactory.LoaderRepositoryConfig;
/*    */ import org.jboss.virtual.VirtualFile;
/*    */ import org.w3c.dom.Document;
/*    */ import org.w3c.dom.Element;
/*    */ import org.w3c.dom.NodeList;
/*    */ 
/*    */ public class AspectAppParsingDeployer extends JAXPDeployer<AspectDeployment>
/*    */ {
/*    */   public AspectAppParsingDeployer()
/*    */   {
/* 47 */     super(AspectDeployment.class);
/* 48 */     setSuffix("-aop.xml");
/* 49 */     setStage(DeploymentStages.DESCRIBE);
/*    */   }
/*    */ 
/*    */   protected AspectDeployment parse(VFSDeploymentUnit unit, VirtualFile file, Document document) throws Exception
/*    */   {
/* 54 */     if (unit.getTopLevel() == unit)
/*    */     {
/* 57 */       NodeList loaders = document.getElementsByTagName("loader-repository");
/* 58 */       if (loaders.getLength() > 0)
/*    */       {
/* 60 */         Element loader = (Element)loaders.item(0);
/*    */         try
/*    */         {
/* 63 */           LoaderRepositoryFactory.LoaderRepositoryConfig config = LoaderRepositoryFactory.parseRepositoryConfig(loader);
/* 64 */           unit.addAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class, config);
/*    */         }
/*    */         catch (Exception e)
/*    */         {
/* 68 */           throw DeploymentException.rethrowAsDeploymentException("Unable to parse loader repository config", e);
/*    */         }
/*    */       }
/*    */     }
/* 72 */     return null;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.deployers.AspectAppParsingDeployer
 * JD-Core Version:    0.6.0
 */