/*     */ package org.jboss.aop.deployers;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.File;
/*     */ import java.io.InputStream;
/*     */ import javax.management.JMException;
/*     */ import javax.management.ListenerNotFoundException;
/*     */ import javax.management.MBeanNotificationInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.Notification;
/*     */ import javax.management.NotificationFilter;
/*     */ import javax.management.NotificationListener;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.AspectXmlLoader;
/*     */ import org.jboss.aop.asintegration.JBossIntegration;
/*     */ import org.jboss.aop.deployment.AspectManagerService;
/*     */ import org.jboss.deployment.DeploymentInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.w3c.dom.Document;
/*     */ 
/*     */ public abstract class AbstractAspectManager
/*     */ {
/*     */   static final String BASE_ASPECTS_XML = "base-aspects.xml";
/*  54 */   AspectManagerService delegate = null;
/*     */   String bootstrapXml;
/*     */ 
/*     */   public AbstractAspectManager(String bootstrapXml)
/*     */   {
/*  59 */     this.bootstrapXml = bootstrapXml;
/*     */   }
/*     */ 
/*     */   public AspectManager getAspectManager()
/*     */   {
/*  64 */     return AspectManager.getTopLevelAspectManager();
/*     */   }
/*     */ 
/*     */   public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback)
/*     */   {
/*  75 */     this.delegate.addNotificationListener(listener, filter, handback);
/*     */   }
/*     */ 
/*     */   public String aspectDefinitions()
/*     */   {
/*  84 */     return this.delegate.aspectDefinitions();
/*     */   }
/*     */ 
/*     */   public void attachClass(String classname)
/*     */   {
/*  93 */     this.delegate.attachClass(classname);
/*     */   }
/*     */ 
/*     */   public String bindings()
/*     */   {
/* 102 */     return this.delegate.bindings();
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 113 */       if ((this.bootstrapXml != null) && (this.bootstrapXml.trim().length() > 0))
/*     */       {
/* 115 */         InputStream in = new BufferedInputStream(new ByteArrayInputStream(this.bootstrapXml.getBytes()));
/*     */         try
/*     */         {
/* 118 */           Document doc = AspectXmlLoader.loadDocument(new BufferedInputStream(in));
/* 119 */           AspectXmlLoader loader = new AspectXmlLoader();
/* 120 */           loader.setManager(getAspectManager());
/* 121 */           loader.deployXML(doc, null);
/*     */         }
/*     */         finally
/*     */         {
/* 125 */           if (in != null)
/*     */           {
/* 127 */             in.close();
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 135 */       throw new RuntimeException("Problem starting AspectManager", e);
/*     */     }
/* 137 */     this.delegate.create();
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 146 */     this.delegate.start();
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 152 */     this.delegate.stop();
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */     try
/*     */     {
/* 162 */       if (this.bootstrapXml != null)
/*     */       {
/* 164 */         InputStream in = new BufferedInputStream(new ByteArrayInputStream(this.bootstrapXml.getBytes()));
/*     */         try
/*     */         {
/* 167 */           Document doc = AspectXmlLoader.loadDocument(new BufferedInputStream(in));
/* 168 */           AspectXmlLoader loader = new AspectXmlLoader();
/* 169 */           loader.setManager(getAspectManager());
/* 170 */           loader.deployXML(doc, null);
/*     */         }
/*     */         finally
/*     */         {
/* 174 */           if (in != null)
/*     */           {
/* 176 */             in.close();
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 183 */       throw new RuntimeException("Problem destroying AspectManager", e);
/*     */     }
/* 185 */     this.delegate.destroy();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 195 */     return this.delegate.equals(obj);
/*     */   }
/*     */ 
/*     */   public DeploymentInfo getDeploymentInfo()
/*     */     throws JMException
/*     */   {
/* 205 */     return this.delegate.getDeploymentInfo();
/*     */   }
/*     */ 
/*     */   public boolean getEnableLoadtimeWeaving()
/*     */   {
/* 214 */     return this.delegate.getEnableLoadtimeWeaving();
/*     */   }
/*     */ 
/*     */   public boolean getEnableTransformer()
/*     */   {
/* 223 */     return this.delegate.getEnableTransformer();
/*     */   }
/*     */ 
/*     */   public String getExclude()
/*     */   {
/* 232 */     return this.delegate.getExclude();
/*     */   }
/*     */ 
/*     */   public String getIgnore()
/*     */   {
/* 241 */     return this.delegate.getIgnore();
/*     */   }
/*     */ 
/*     */   public String getInclude()
/*     */   {
/* 250 */     return this.delegate.getInclude();
/*     */   }
/*     */ 
/*     */   public String getInstrumentor()
/*     */   {
/* 259 */     return this.delegate.getInstrumentor();
/*     */   }
/*     */ 
/*     */   public Logger getLog()
/*     */   {
/* 268 */     return this.delegate.getLog();
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 277 */     return this.delegate.getName();
/*     */   }
/*     */ 
/*     */   public MBeanNotificationInfo[] getNotificationInfo()
/*     */   {
/* 286 */     return this.delegate.getNotificationInfo();
/*     */   }
/*     */ 
/*     */   public boolean getOptimized()
/*     */   {
/* 295 */     return this.delegate.getOptimized();
/*     */   }
/*     */ 
/*     */   public boolean getPrune()
/*     */   {
/* 304 */     return this.delegate.getPrune();
/*     */   }
/*     */ 
/*     */   public MBeanServer getServer()
/*     */   {
/* 313 */     return this.delegate.getServer();
/*     */   }
/*     */ 
/*     */   public ObjectName getServiceName()
/*     */   {
/* 322 */     return this.delegate.getServiceName();
/*     */   }
/*     */ 
/*     */   public int getState()
/*     */   {
/* 331 */     return this.delegate.getState();
/*     */   }
/*     */ 
/*     */   public String getStateString()
/*     */   {
/* 340 */     return this.delegate.getStateString();
/*     */   }
/*     */ 
/*     */   public boolean getSuppressReferenceErrors()
/*     */   {
/* 349 */     return this.delegate.getSuppressReferenceErrors();
/*     */   }
/*     */ 
/*     */   public boolean getSuppressTransformationErrors()
/*     */   {
/* 358 */     return this.delegate.getSuppressTransformationErrors();
/*     */   }
/*     */ 
/*     */   public File getTmpClassesDir()
/*     */   {
/* 367 */     return this.delegate.getTmpClassesDir();
/*     */   }
/*     */ 
/*     */   public boolean getVerbose()
/*     */   {
/* 376 */     return this.delegate.getVerbose();
/*     */   }
/*     */ 
/*     */   public void handleNotification(NotificationListener listener, Notification notification, Object handback)
/*     */   {
/* 387 */     this.delegate.handleNotification(listener, notification, handback);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 396 */     return this.delegate.hashCode();
/*     */   }
/*     */ 
/*     */   public String interceptorFactories()
/*     */   {
/* 405 */     return this.delegate.interceptorFactories();
/*     */   }
/*     */ 
/*     */   public String introductions()
/*     */   {
/* 414 */     return this.delegate.introductions();
/*     */   }
/*     */ 
/*     */   public void jbossInternalLifecycle(String method)
/*     */     throws Exception
/*     */   {
/* 424 */     this.delegate.jbossInternalLifecycle(method);
/*     */   }
/*     */ 
/*     */   public long nextNotificationSequenceNumber()
/*     */   {
/* 433 */     return this.delegate.nextNotificationSequenceNumber();
/*     */   }
/*     */ 
/*     */   public void postDeregister()
/*     */   {
/* 442 */     this.delegate.postDeregister();
/*     */   }
/*     */ 
/*     */   public void postRegister(Boolean registrationDone)
/*     */   {
/* 451 */     this.delegate.postRegister(registrationDone);
/*     */   }
/*     */ 
/*     */   public void preDeregister()
/*     */     throws Exception
/*     */   {
/* 460 */     this.delegate.preDeregister();
/*     */   }
/*     */ 
/*     */   public ObjectName preRegister(MBeanServer server, ObjectName name)
/*     */     throws Exception
/*     */   {
/* 472 */     return this.delegate.preRegister(server, name);
/*     */   }
/*     */ 
/*     */   public String registeredClassLoaders()
/*     */   {
/* 481 */     return this.delegate.registeredClassLoaders();
/*     */   }
/*     */ 
/*     */   public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback)
/*     */     throws ListenerNotFoundException
/*     */   {
/* 493 */     this.delegate.removeNotificationListener(listener, filter, handback);
/*     */   }
/*     */ 
/*     */   public void removeNotificationListener(NotificationListener listener)
/*     */     throws ListenerNotFoundException
/*     */   {
/* 503 */     this.delegate.removeNotificationListener(listener);
/*     */   }
/*     */ 
/*     */   public void sendNotification(Notification notification)
/*     */   {
/* 512 */     this.delegate.sendNotification(notification);
/*     */   }
/*     */ 
/*     */   public void setEnableLoadtimeWeaving(boolean enableTransformer)
/*     */   {
/* 521 */     this.delegate.setEnableLoadtimeWeaving(enableTransformer);
/*     */   }
/*     */ 
/*     */   public void setEnableTransformer(boolean enableTransformer)
/*     */   {
/* 530 */     this.delegate.setEnableTransformer(enableTransformer);
/*     */   }
/*     */ 
/*     */   public void setExclude(String exclude)
/*     */   {
/* 539 */     this.delegate.setExclude(exclude);
/*     */   }
/*     */ 
/*     */   public void setIgnore(String ignore)
/*     */   {
/* 548 */     this.delegate.setIgnore(ignore);
/*     */   }
/*     */ 
/*     */   public void setInclude(String include)
/*     */   {
/* 557 */     this.delegate.setInclude(include);
/*     */   }
/*     */ 
/*     */   public void setInstrumentor(String instrumentor)
/*     */   {
/* 566 */     this.delegate.setInstrumentor(instrumentor);
/*     */   }
/*     */ 
/*     */   public void setOptimized(boolean verbose)
/*     */   {
/* 575 */     this.delegate.setOptimized(verbose);
/*     */   }
/*     */ 
/*     */   public void setPrune(boolean prune)
/*     */   {
/* 584 */     this.delegate.setPrune(prune);
/*     */   }
/*     */ 
/*     */   public void setSuppressReferenceErrors(boolean suppressReferenceErrors)
/*     */   {
/* 593 */     this.delegate.setSuppressReferenceErrors(suppressReferenceErrors);
/*     */   }
/*     */ 
/*     */   public void setSuppressTransformationErrors(boolean suppressTransformationErrors)
/*     */   {
/* 602 */     this.delegate.setSuppressTransformationErrors(suppressTransformationErrors);
/*     */   }
/*     */ 
/*     */   public void setTmpClassesDir(File tmpClassesDir)
/*     */   {
/* 611 */     this.delegate.setTmpClassesDir(tmpClassesDir);
/*     */   }
/*     */ 
/*     */   public void setVerbose(boolean verbose)
/*     */   {
/* 620 */     this.delegate.setVerbose(verbose);
/*     */   }
/*     */ 
/*     */   public String stacks()
/*     */   {
/* 629 */     return this.delegate.stacks();
/*     */   }
/*     */ 
/*     */   public void deployBaseAspects()
/*     */   {
/* 634 */     this.delegate.baseAop("base-aspects.xml");
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 643 */     return this.delegate.toString();
/*     */   }
/*     */ 
/*     */   public JBossIntegration getJbossIntegration()
/*     */   {
/* 652 */     return this.delegate.getJBossIntegration();
/*     */   }
/*     */ 
/*     */   public void setJbossIntegration(JBossIntegration integration)
/*     */   {
/* 661 */     this.delegate.setJBossIntegration(integration);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.deployers.AbstractAspectManager
 * JD-Core Version:    0.6.0
 */