/*     */ package org.jboss.aop.contrib;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.ArrayList;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.LoaderClassPath;
/*     */ import javassist.scopedpool.ScopedClassPool;
/*     */ import javassist.scopedpool.ScopedClassPoolFactory;
/*     */ import javassist.scopedpool.ScopedClassPoolRepository;
/*     */ import org.jboss.aop.classpool.AOPClassPool;
/*     */ 
/*     */ public class IDEClassPoolFactory
/*     */   implements ScopedClassPoolFactory
/*     */ {
/*     */   private ArrayList classPaths;
/*     */ 
/*     */   public IDEClassPoolFactory()
/*     */   {
/*  53 */     this.classPaths = new ArrayList();
/*     */   }
/*     */ 
/*     */   public ScopedClassPool create(ClassLoader loader, ClassPool pool, ScopedClassPoolRepository repository)
/*     */   {
/*  58 */     SimpleClassPool classPool = new SimpleClassPool(loader, pool, repository);
/*  59 */     return classPool;
/*     */   }
/*     */ 
/*     */   public ScopedClassPool create(ClassPool pool, ScopedClassPoolRepository repository)
/*     */   {
/*  64 */     SimpleClassPool classPool = new SimpleClassPool(pool, repository);
/*  65 */     return classPool;
/*     */   }
/*     */ 
/*     */   public void insertClasspath(String path)
/*     */   {
/*     */     try
/*     */     {
/*  72 */       this.classPaths.add(new URL(path));
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  76 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public ClassLoader getTCLIfScoped()
/*     */   {
/* 158 */     return null;
/*     */   }
/*     */ 
/*     */   private class Loader extends URLClassLoader
/*     */   {
/*     */     public Loader(URL[] urls, ClassLoader src)
/*     */     {
/* 143 */       super(src);
/*     */     }
/*     */ 
/*     */     public Class loadClass(String name, byte[] classfile)
/*     */       throws ClassFormatError
/*     */     {
/* 149 */       Class c = defineClass(name, classfile, 0, classfile.length);
/*     */ 
/* 151 */       resolveClass(c);
/* 152 */       return c;
/*     */     }
/*     */   }
/*     */ 
/*     */   private class SimpleClassPool extends AOPClassPool
/*     */   {
/*     */     private IDEClassPoolFactory.Loader loader;
/*     */ 
/*     */     public SimpleClassPool(ClassLoader loader, ClassPool pool, ScopedClassPoolRepository repository)
/*     */     {
/*  86 */       super(pool, repository);
/*  87 */       loadClasspath();
/*     */     }
/*     */ 
/*     */     public SimpleClassPool(ClassPool pool, ScopedClassPoolRepository repository)
/*     */     {
/*  92 */       super(repository);
/*  93 */       loadClasspath();
/*     */     }
/*     */ 
/*     */     private void loadClasspath()
/*     */     {
/*  99 */       this.childFirstLookup = true;
/*     */ 
/* 101 */       AccessController.doPrivileged(new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 105 */           URL[] urlPaths = (URL[])(URL[])IDEClassPoolFactory.this.classPaths.toArray(new URL[IDEClassPoolFactory.this.classPaths.size()]);
/* 106 */           IDEClassPoolFactory.SimpleClassPool.access$102(IDEClassPoolFactory.SimpleClassPool.this, new IDEClassPoolFactory.Loader(IDEClassPoolFactory.this, urlPaths, Thread.currentThread().getContextClassLoader()));
/* 107 */           IDEClassPoolFactory.SimpleClassPool.this.setClassLoader(IDEClassPoolFactory.SimpleClassPool.this.loader);
/*     */ 
/* 109 */           Thread.currentThread().setContextClassLoader(IDEClassPoolFactory.SimpleClassPool.this.loader);
/* 110 */           return null;
/*     */         }
/*     */       });
/* 114 */       this.classPath = new LoaderClassPath(this.loader);
/* 115 */       insertClassPath(this.classPath);
/*     */     }
/*     */ 
/*     */     public Class toClass(CtClass cc)
/*     */       throws CannotCompileException
/*     */     {
/*     */       try
/*     */       {
/* 123 */         return this.loader.loadClass(cc.getName());
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */         try
/*     */         {
/* 129 */           return this.loader.loadClass(cc.getName(), cc.toBytecode());
/*     */         } catch (IOException e2) {
/*     */         }
/*     */       }
/* 133 */       throw new CannotCompileException(e2);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.contrib.IDEClassPoolFactory
 * JD-Core Version:    0.6.0
 */