/*     */ package org.jboss.aop.classpool;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Field;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import javassist.ClassPool;
/*     */ import javassist.scopedpool.ScopedClassPool;
/*     */ import javassist.scopedpool.ScopedClassPoolFactory;
/*     */ import javassist.scopedpool.ScopedClassPoolRepository;
/*     */ import javassist.scopedpool.ScopedClassPoolRepositoryImpl;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.util.logging.AOPLogger;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class AOPClassPoolRepository
/*     */   implements ScopedClassPoolRepository
/*     */ {
/*  54 */   private static final Logger logger = AOPLogger.getLogger(AOPClassPoolRepository.class);
/*     */ 
/*  56 */   private static final AOPClassPoolRepository instance = new AOPClassPoolRepository();
/*     */ 
/*  59 */   protected final HashMap ucl2classes = new HashMap();
/*     */   AspectManager manager;
/*     */   ScopedClassPoolRepository delegate;
/*     */ 
/*     */   public static AOPClassPoolRepository getInstance()
/*     */   {
/*  68 */     return instance;
/*     */   }
/*     */ 
/*     */   private AOPClassPoolRepository()
/*     */   {
/*  73 */     this.delegate = ScopedClassPoolRepositoryImpl.getInstance();
/*     */ 
/*  75 */     this.delegate.setClassPoolFactory(new AOPClassPoolFactory());
/*     */   }
/*     */ 
/*     */   public void setClassPoolFactory(ScopedClassPoolFactory factory)
/*     */   {
/* 105 */     this.delegate.setClassPoolFactory(factory);
/*     */   }
/*     */ 
/*     */   public ScopedClassPoolFactory getClassPoolFactory()
/*     */   {
/* 110 */     return this.delegate.getClassPoolFactory();
/*     */   }
/*     */ 
/*     */   public boolean isPrune()
/*     */   {
/* 115 */     return this.delegate.isPrune();
/*     */   }
/*     */ 
/*     */   public void setPrune(boolean prune)
/*     */   {
/* 120 */     this.delegate.setPrune(prune);
/*     */   }
/*     */ 
/*     */   public ScopedClassPool createScopedClassPool(ClassLoader cl, ClassPool src)
/*     */   {
/* 125 */     return this.delegate.createScopedClassPool(cl, src);
/*     */   }
/*     */ 
/*     */   public ClassPool findClassPool(ClassLoader cl)
/*     */   {
/* 130 */     return this.delegate.findClassPool(cl);
/*     */   }
/*     */ 
/*     */   public void setAspectManager(AspectManager manager)
/*     */   {
/* 135 */     this.manager = manager;
/*     */   }
/*     */ 
/*     */   public Map getRegisteredCLs()
/*     */   {
/* 145 */     return this.delegate.getRegisteredCLs();
/*     */   }
/*     */ 
/*     */   public void clearUnregisteredClassLoaders()
/*     */   {
/* 153 */     this.delegate.clearUnregisteredClassLoaders();
/*     */   }
/*     */ 
/*     */   public ClassPool registerClassLoader(ClassLoader ucl)
/*     */   {
/* 158 */     return this.delegate.registerClassLoader(ucl);
/*     */   }
/*     */ 
/*     */   public void unregisterClassLoader(ClassLoader cl)
/*     */   {
/* 163 */     this.delegate.unregisterClassLoader(cl);
/*     */   }
/*     */ 
/*     */   public void registerClass(Class clazz)
/*     */   {
/* 168 */     HashSet classes = (HashSet)this.ucl2classes.get(clazz.getClassLoader());
/* 169 */     if (classes == null)
/*     */     {
/* 171 */       classes = new HashSet();
/* 172 */       this.ucl2classes.put(clazz.getClassLoader(), classes);
/*     */     }
/* 174 */     classes.add(clazz);
/*     */   }
/*     */ 
/*     */   public void perfomUnregisterClassLoader(ClassLoader cl)
/*     */   {
/* 179 */     if (System.getSecurityManager() == null)
/*     */     {
/* 181 */       UnregisterClassLoaderAction.NON_PRIVILEGED.unregister(this, cl);
/*     */     }
/*     */     else
/*     */     {
/* 185 */       UnregisterClassLoaderAction.PRIVILEGED.unregister(this, cl);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void doUnregisterClassLoader(ClassLoader cl)
/*     */   {
/* 191 */     synchronized (this.delegate.getRegisteredCLs())
/*     */     {
/* 193 */       HashSet classes = (HashSet)this.ucl2classes.remove(cl);
/* 194 */       if (classes != null)
/*     */       {
/* 196 */         Iterator it = classes.iterator();
/* 197 */         while (it.hasNext())
/*     */         {
/* 199 */           Object clazz = it.next();
/* 200 */           synchronized (this.manager.getAdvisors())
/*     */           {
/* 202 */             WeakReference ref = (WeakReference)this.manager.getAdvisors().get(clazz);
/* 203 */             if (ref != null)
/*     */             {
/* 205 */               Advisor advisor = (Advisor)ref.get();
/* 206 */               this.manager.getAdvisors().remove(clazz);
/* 207 */               if (advisor != null)
/*     */               {
/* 209 */                 advisor.cleanup();
/*     */               }
/*     */             }
/* 212 */             Class advisedClass = (Class)clazz;
/*     */             try
/*     */             {
/* 216 */               Field f = advisedClass.getDeclaredField("aop$classAdvisor$aop");
/* 217 */               f.setAccessible(true);
/* 218 */               f.set(null, null);
/*     */             }
/*     */             catch (NoSuchFieldException e)
/*     */             {
/* 222 */               logger.warn("Error unsetting advisor for " + advisedClass.getName() + " " + e);
/*     */             }
/*     */             catch (IllegalAccessException e)
/*     */             {
/* 226 */               logger.warn("Error unsetting advisor for " + advisedClass.getName() + " " + e);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface UnregisterClassLoaderAction
/*     */   {
/* 239 */     public static final UnregisterClassLoaderAction PRIVILEGED = new UnregisterClassLoaderAction()
/*     */     {
/*     */       public void unregister(AOPClassPoolRepository repository, ClassLoader loader)
/*     */       {
/*     */         try
/*     */         {
/* 245 */           AccessController.doPrivileged(new PrivilegedExceptionAction(repository, loader)
/*     */           {
/*     */             public Object run()
/*     */             {
/* 249 */               this.val$repository.doUnregisterClassLoader(this.val$loader);
/* 250 */               return null;
/*     */             }
/*     */           });
/*     */         }
/*     */         catch (PrivilegedActionException e) {
/* 256 */           Exception ex = e.getException();
/* 257 */           if ((ex instanceof RuntimeException))
/*     */           {
/* 259 */             throw ((RuntimeException)ex);
/*     */           }
/* 261 */           throw new RuntimeException(ex);
/*     */         }
/*     */       }
/* 239 */     };
/*     */ 
/* 266 */     public static final UnregisterClassLoaderAction NON_PRIVILEGED = new UnregisterClassLoaderAction()
/*     */     {
/*     */       public void unregister(AOPClassPoolRepository repository, ClassLoader loader)
/*     */       {
/* 270 */         repository.doUnregisterClassLoader(loader);
/*     */       }
/* 266 */     };
/*     */ 
/*     */     public abstract void unregister(AOPClassPoolRepository paramAOPClassPoolRepository, ClassLoader paramClassLoader);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.classpool.AOPClassPoolRepository
 * JD-Core Version:    0.6.0
 */