/*     */ package org.jboss.aop.classpool;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.util.Collection;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.scopedpool.ScopedClassPool;
/*     */ import javassist.scopedpool.ScopedClassPoolFactory;
/*     */ import javassist.scopedpool.ScopedClassPoolRepository;
/*     */ import javassist.scopedpool.SoftValueHashMap;
/*     */ import org.jboss.aop.AspectManager;
/*     */ 
/*     */ public class AOPClassPool extends ScopedClassPool
/*     */ {
/*  44 */   protected ConcurrentHashMap<String, String> generatedClasses = new ConcurrentHashMap();
/*     */ 
/*  46 */   protected ConcurrentHashMap<String, Boolean> localResources = new ConcurrentHashMap();
/*     */ 
/*  49 */   protected ConcurrentHashMap<String, Boolean> loadedButNotWovenClasses = new ConcurrentHashMap();
/*     */ 
/*     */   public AOPClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository)
/*     */   {
/*  59 */     this(cl, src, repository, false);
/*     */   }
/*     */ 
/*     */   protected AOPClassPool(ClassPool src, ScopedClassPoolRepository repository)
/*     */   {
/*  64 */     this(null, src, repository, true);
/*     */   }
/*     */ 
/*     */   private AOPClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, boolean isTemp)
/*     */   {
/*  69 */     super(cl, src, repository, isTemp);
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ClassLoader cl)
/*     */   {
/*  74 */     this.classLoader = new WeakReference(cl);
/*     */   }
/*     */ 
/*     */   public void registerGeneratedClass(String className)
/*     */   {
/*  79 */     this.generatedClasses.put(className, className);
/*     */   }
/*     */ 
/*     */   public void close()
/*     */   {
/*  84 */     super.close();
/*  85 */     AOPClassPoolRepository.getInstance().perfomUnregisterClassLoader(getClassLoader());
/*     */   }
/*     */ 
/*     */   public CtClass getCached(String classname)
/*     */   {
/*  90 */     CtClass clazz = getCachedLocally(classname);
/*  91 */     if (clazz == null)
/*     */     {
/*  93 */       boolean isLocal = false;
/*     */ 
/*  95 */       ClassLoader cl = getClassLoader0();
/*     */ 
/*  97 */       if (cl != null)
/*     */       {
/*  99 */         isLocal = isLocalResource(classname);
/*     */       }
/*     */ 
/* 102 */       if (!isLocal)
/*     */       {
/* 104 */         Object o = this.generatedClasses.get(classname);
/* 105 */         if (o == null)
/*     */         {
/* 107 */           Map registeredCLs = AspectManager.getRegisteredCLs();
/* 108 */           synchronized (registeredCLs)
/*     */           {
/* 110 */             Iterator it = registeredCLs.values().iterator();
/* 111 */             while (it.hasNext())
/*     */             {
/* 113 */               AOPClassPool pool = (AOPClassPool)it.next();
/* 114 */               if (pool.isUnloadedClassLoader())
/*     */               {
/* 116 */                 AspectManager.instance().unregisterClassLoader(pool.getClassLoader());
/* 117 */                 continue;
/*     */               }
/*     */ 
/* 121 */               if (!pool.includeInGlobalSearch())
/*     */               {
/*     */                 continue;
/*     */               }
/*     */ 
/* 126 */               clazz = pool.getCachedLocally(classname);
/* 127 */               if (clazz != null)
/*     */               {
/* 129 */                 return clazz;
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 137 */     return clazz;
/*     */   }
/*     */ 
/*     */   protected boolean includeInGlobalSearch()
/*     */   {
/* 142 */     return true;
/*     */   }
/*     */ 
/*     */   protected String getResourceName(String classname)
/*     */   {
/* 147 */     int lastIndex = classname.lastIndexOf('$');
/* 148 */     if (lastIndex < 0)
/*     */     {
/* 150 */       return classname.replaceAll("[\\.]", "/") + ".class";
/*     */     }
/*     */ 
/* 154 */     return classname.substring(0, lastIndex).replaceAll("[\\.]", "/") + classname.substring(lastIndex) + ".class";
/*     */   }
/*     */ 
/*     */   protected boolean isLocalResource(String resourceName)
/*     */   {
/* 160 */     String classResourceName = getResourceName(resourceName);
/* 161 */     Boolean isLocal = (Boolean)this.localResources.get(classResourceName);
/* 162 */     if (isLocal != null)
/*     */     {
/* 164 */       return isLocal.booleanValue();
/*     */     }
/* 166 */     boolean localResource = getClassLoader().getResource(classResourceName) != null;
/* 167 */     this.localResources.put(classResourceName, localResource ? Boolean.TRUE : Boolean.FALSE);
/* 168 */     return localResource;
/*     */   }
/*     */ 
/*     */   public synchronized CtClass getLocally(String classname)
/*     */     throws NotFoundException
/*     */   {
/* 174 */     this.softcache.remove(classname);
/* 175 */     CtClass clazz = (CtClass)this.classes.get(classname);
/* 176 */     if (clazz == null)
/*     */     {
/* 178 */       clazz = createCtClass(classname, true);
/* 179 */       if (clazz == null) throw new NotFoundException(classname);
/* 180 */       lockInCache(clazz);
/*     */     }
/*     */ 
/* 183 */     return clazz;
/*     */   }
/*     */ 
/*     */   public void setClassLoadedButNotWoven(String classname)
/*     */   {
/* 188 */     this.loadedButNotWovenClasses.put(classname, Boolean.TRUE);
/*     */   }
/*     */ 
/*     */   public boolean isClassLoadedButNotWoven(String classname)
/*     */   {
/* 193 */     return this.loadedButNotWovenClasses.get(classname) == Boolean.TRUE;
/*     */   }
/*     */ 
/*     */   public static AOPClassPool createAOPClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository)
/*     */   {
/* 198 */     return (AOPClassPool)AspectManager.getClassPoolFactory().create(cl, src, repository);
/*     */   }
/*     */ 
/*     */   public static AOPClassPool createAOPClassPool(ClassPool src, ScopedClassPoolRepository repository)
/*     */   {
/* 203 */     return (AOPClassPool)AspectManager.getClassPoolFactory().create(src, repository);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 208 */     ClassLoader cl = null;
/*     */     try
/*     */     {
/* 211 */       cl = getClassLoader();
/*     */     }
/*     */     catch (IllegalStateException ignore)
/*     */     {
/*     */     }
/* 216 */     return super.toString() + " - dcl " + cl;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  53 */     ClassPool.doPruning = false;
/*  54 */     ClassPool.releaseUnmodifiedClassFile = false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.classpool.AOPClassPool
 * JD-Core Version:    0.6.0
 */