/*     */ package org.jboss.aop.asintegration.jboss4;
/*     */ 
/*     */ import java.util.Map;
/*     */ import java.util.WeakHashMap;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.Domain;
/*     */ import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
/*     */ import org.jboss.aop.classpool.AOPClassPoolRepository;
/*     */ import org.jboss.aop.domain.DomainInitializer;
/*     */ import org.jboss.aop.domain.DomainInitializerCallback;
/*     */ import org.jboss.aop.domain.DomainInitializerCallbackHandler;
/*     */ import org.jboss.aop.domain.ScopedRepositoryClassLoaderDomain;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.loading.HeirarchicalLoaderRepository3;
/*     */ import org.jboss.mx.loading.RepositoryClassLoader;
/*     */ 
/*     */ public class RepositoryClassLoaderScopingPolicy
/*     */   implements AOPClassLoaderScopingPolicy, DomainInitializer
/*     */ {
/*  46 */   Logger log = Logger.getLogger(RepositoryClassLoaderScopingPolicy.class);
/*     */ 
/*  49 */   private Map<Object, Domain> scopedClassLoaderDomains = new WeakHashMap();
/*     */ 
/*     */   public Domain initializeDomain(DomainInitializerCallbackHandler handler)
/*     */   {
/*  54 */     DomainInitializerCallback callback = new DomainInitializerCallback(ClassLoader.class);
/*  55 */     DomainInitializerCallback[] callbacks = { callback };
/*  56 */     handler.handle(callbacks);
/*     */ 
/*  58 */     ClassLoader loader = (ClassLoader)callback.getValue();
/*  59 */     Domain domain = getDomain(loader, AspectManager.getTopLevelAspectManager());
/*     */ 
/*  61 */     AspectManager.instance().registerClassLoader(loader);
/*     */ 
/*  63 */     return domain;
/*     */   }
/*     */ 
/*     */   public synchronized Domain getDomain(ClassLoader classLoader, AspectManager parent)
/*     */   {
/*  68 */     ClassLoader scopedClassLoader = ifScopedDeploymentGetScopedParentUclForCL(classLoader);
/*  69 */     if (scopedClassLoader != null)
/*     */     {
/*  71 */       Domain scopedManager = null;
/*  72 */       synchronized (AOPClassPoolRepository.getInstance().getRegisteredCLs())
/*     */       {
/*  74 */         Object loaderRepository = getLoaderRepository(classLoader);
/*  75 */         scopedManager = (Domain)this.scopedClassLoaderDomains.get(loaderRepository);
/*     */ 
/*  78 */         if ((scopedManager != null) && (!scopedManager.isValid()))
/*     */         {
/*  80 */           this.scopedClassLoaderDomains.remove(loaderRepository);
/*  81 */           scopedManager = null;
/*     */         }
/*     */ 
/*  84 */         if (scopedManager == null)
/*     */         {
/*  86 */           scopedManager = getScopedClassLoaderDomain(scopedClassLoader, parent);
/*  87 */           this.log.debug("Created domain " + scopedManager + " for scoped deployment on: " + classLoader + "; identifying scoped ucl: " + scopedClassLoader);
/*     */ 
/*  89 */           scopedManager.setInheritsBindings(true);
/*  90 */           scopedManager.setInheritsDeclarations(true);
/*     */ 
/*  92 */           this.scopedClassLoaderDomains.put(loaderRepository, scopedManager);
/*     */         }
/*  94 */         return scopedManager;
/*     */       }
/*     */     }
/*  97 */     return null;
/*     */   }
/*     */ 
/*     */   public Domain getTopLevelDomain(AspectManager parent)
/*     */   {
/* 102 */     ClassLoader classLoader = getTopLevelJBossClassLoader();
/* 103 */     return getDomain(classLoader, parent);
/*     */   }
/*     */ 
/*     */   private ClassLoader ifScopedDeploymentGetScopedParentUclForCL(ClassLoader loader)
/*     */   {
/* 110 */     ClassLoader parent = loader;
/*     */ 
/* 112 */     while (parent != null)
/*     */     {
/* 114 */       if (ScopedRepositoryClassLoaderHelper.isScopedClassLoader(parent))
/*     */       {
/* 116 */         return parent;
/*     */       }
/* 118 */       if ((parent instanceof RepositoryClassLoader))
/*     */       {
/* 121 */         return null;
/*     */       }
/* 123 */       parent = parent.getParent();
/*     */     }
/* 125 */     return null;
/*     */   }
/*     */ 
/*     */   private ClassLoader getTopLevelJBossClassLoader()
/*     */   {
/* 130 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 131 */     RepositoryClassLoader topRcl = null;
/* 132 */     while (loader != null)
/*     */     {
/* 134 */       if ((loader instanceof RepositoryClassLoader))
/*     */       {
/* 136 */         topRcl = (RepositoryClassLoader)loader;
/*     */       }
/* 138 */       loader = loader.getParent();
/*     */     }
/* 140 */     return topRcl;
/*     */   }
/*     */ 
/*     */   private Domain getScopedClassLoaderDomain(ClassLoader cl, AspectManager parent)
/*     */   {
/* 145 */     boolean parentDelegation = true;
/* 146 */     if ((cl instanceof RepositoryClassLoader))
/*     */     {
/* 148 */       HeirarchicalLoaderRepository3 repository = (HeirarchicalLoaderRepository3)((RepositoryClassLoader)cl).getLoaderRepository();
/* 149 */       parentDelegation = repository.getUseParentFirst();
/*     */     }
/* 151 */     String name = String.valueOf(System.identityHashCode(cl));
/* 152 */     return new ScopedRepositoryClassLoaderDomain(cl, name, parentDelegation, parent, false);
/*     */   }
/*     */ 
/*     */   private Object getLoaderRepository(ClassLoader loader)
/*     */   {
/* 157 */     ClassLoader cl = ifScopedDeploymentGetScopedParentUclForCL(loader);
/* 158 */     if (cl != null)
/*     */     {
/* 160 */       return ((RepositoryClassLoader)cl).getLoaderRepository();
/*     */     }
/* 162 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.asintegration.jboss4.RepositoryClassLoaderScopingPolicy
 * JD-Core Version:    0.6.0
 */