/*     */ package org.jboss.aop.asintegration.jboss4;
/*     */ 
/*     */ import java.net.URL;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.Notification;
/*     */ import javax.management.NotificationListener;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.mx.loading.HeirarchicalLoaderRepository3;
/*     */ import org.jboss.mx.loading.LoaderRepository;
/*     */ import org.jboss.mx.util.MBeanServerLocator;
/*     */ 
/*     */ public class LoaderRepositoryUrlUtil
/*     */   implements NotificationListener
/*     */ {
/*  48 */   static final MBeanServer SERVER = MBeanServerLocator.locateJBoss();
/*     */   static final ObjectName MAIN_LOADER_REPOSITORY_OBJECT_NAME;
/*     */   static final LoaderRepository MAIN_LOADER_REPOSITORY;
/*     */   long currentSequenceNumber;
/*  61 */   long lastSequenceNumber = -1L;
/*     */   URL[] urls;
/*     */ 
/*     */   public LoaderRepositoryUrlUtil()
/*     */   {
/*     */     try
/*     */     {
/*  68 */       SERVER.addNotificationListener(MAIN_LOADER_REPOSITORY_OBJECT_NAME, this, null, null);
/*     */     }
/*     */     catch (InstanceNotFoundException e)
/*     */     {
/*  72 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void handleNotification(Notification notification, Object handback)
/*     */   {
/*  78 */     if (notification.getType().equals("jboss.mx.classloader.added"))
/*     */     {
/*  80 */       this.currentSequenceNumber = notification.getSequenceNumber();
/*     */     }
/*  82 */     else if (notification.getType().equals("jboss.mx.classloader.removed"))
/*     */     {
/*  84 */       this.currentSequenceNumber = notification.getSequenceNumber();
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized UrlInfo getURLInfo(HeirarchicalLoaderRepository3 scopedLoader, UrlInfo urlInfo)
/*     */   {
/*  90 */     boolean changed = false;
/*  91 */     if (this.lastSequenceNumber != this.currentSequenceNumber)
/*     */     {
/*  93 */       this.urls = MAIN_LOADER_REPOSITORY.getURLs();
/*  94 */       this.lastSequenceNumber = this.currentSequenceNumber;
/*  95 */       changed = true;
/*     */     }
/*  97 */     if (!changed)
/*     */     {
/*  99 */       changed = (urlInfo != null) && (urlInfo.getSequenceNumber() != this.lastSequenceNumber);
/*     */     }
/* 101 */     if ((urlInfo == null) || (changed))
/*     */     {
/* 103 */       URL[] localUrls = getLocalUrls(scopedLoader, this.urls);
/* 104 */       urlInfo = new UrlInfo(this.urls, localUrls, this.lastSequenceNumber);
/*     */     }
/* 106 */     return urlInfo;
/*     */   }
/*     */ 
/*     */   public long getCurrentSequenceNumber()
/*     */   {
/* 111 */     return this.currentSequenceNumber;
/*     */   }
/*     */ 
/*     */   private URL[] getLocalUrls(HeirarchicalLoaderRepository3 scopedRepository, URL[] globalUrls)
/*     */   {
/* 116 */     URL[] scopedRepositoryUrls = scopedRepository.getURLs();
/*     */ 
/* 120 */     int scopedLength = 0;
/* 121 */     for (int i = 0; i < scopedRepositoryUrls.length; i++)
/*     */     {
/* 123 */       URL scopedUrl = scopedRepositoryUrls[i];
/* 124 */       for (int j = 0; j < globalUrls.length; j++)
/*     */       {
/* 126 */         URL globalUrl = globalUrls[j];
/* 127 */         if (!scopedRepositoryUrls[i].equals(globalUrls[j]))
/*     */           continue;
/* 129 */         scopedLength = i;
/* 130 */         break;
/*     */       }
/*     */ 
/* 133 */       if (scopedLength > 0)
/*     */       {
/*     */         break;
/*     */       }
/*     */     }
/*     */ 
/* 139 */     URL[] localUrls = new URL[scopedLength];
/* 140 */     System.arraycopy(scopedRepositoryUrls, 0, localUrls, 0, scopedLength);
/* 141 */     return localUrls;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  51 */       MAIN_LOADER_REPOSITORY_OBJECT_NAME = new ObjectName("JMImplementation:name=Default,service=LoaderRepository");
/*  52 */       MAIN_LOADER_REPOSITORY = (LoaderRepository)SERVER.invoke(MAIN_LOADER_REPOSITORY_OBJECT_NAME, "getInstance", new Object[0], new String[0]);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  56 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public class UrlInfo
/*     */   {
/*     */     URL[] globalUrls;
/*     */     URL[] localUrls;
/*     */     long sequenceNumber;
/*     */ 
/*     */     public UrlInfo(URL[] globalUrls, URL[] localUrls, long sequenceNumber)
/*     */     {
/* 154 */       this.globalUrls = globalUrls;
/* 155 */       this.localUrls = localUrls;
/* 156 */       this.sequenceNumber = sequenceNumber;
/*     */     }
/*     */ 
/*     */     public URL[] getGlobalUrls()
/*     */     {
/* 161 */       return this.globalUrls;
/*     */     }
/*     */ 
/*     */     public URL[] getLocalUrls()
/*     */     {
/* 166 */       return this.localUrls;
/*     */     }
/*     */ 
/*     */     public long getSequenceNumber()
/*     */     {
/* 171 */       return this.sequenceNumber;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.asintegration.jboss4.LoaderRepositoryUrlUtil
 * JD-Core Version:    0.6.0
 */