/*     */ package org.jboss.aop.asintegration.jboss4;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.net.URL;
/*     */ import javassist.ClassPool;
/*     */ import javassist.scopedpool.ScopedClassPool;
/*     */ import javassist.scopedpool.ScopedClassPoolFactory;
/*     */ import javassist.scopedpool.ScopedClassPoolRepository;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
/*     */ import org.jboss.aop.classpool.AOPClassPool;
/*     */ import org.jboss.aop.classpool.AbstractJBossClassPoolFactory;
/*     */ import org.jboss.mx.loading.RepositoryClassLoader;
/*     */ 
/*     */ public class JBossClassPoolFactory extends AbstractJBossClassPoolFactory
/*     */   implements ScopedClassPoolFactory
/*     */ {
/*     */   protected File tmpClassesDir;
/*     */ 
/*     */   public JBossClassPoolFactory(File tmpClassesDir)
/*     */     throws IOException
/*     */   {
/*  51 */     this.tmpClassesDir = tmpClassesDir;
/*     */   }
/*     */ 
/*     */   public ScopedClassPool create(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository)
/*     */   {
/*  56 */     ClassPool parent = getCreateParentClassPools(cl, src, repository);
/*  57 */     if ((cl instanceof RepositoryClassLoader)) {
/*  59 */       File tempdir = getTempDirectory(cl);
/*     */       URL tmpCP;
/*     */       try {
/*  63 */         tmpCP = createURLAndAddToLoader(cl, tempdir);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/*  67 */         throw new RuntimeException(e);
/*     */       }
/*  69 */       AOPClassLoaderScopingPolicy policy = AspectManager.getClassLoaderScopingPolicy();
/*  70 */       if (ScopedRepositoryClassLoaderHelper.isScopedClassLoader(cl))
/*     */       {
/*  73 */         return new ScopedJBossClassPool(cl, parent, repository, tempdir, tmpCP);
/*     */       }
/*  75 */       return new JBossClassPool(cl, parent, repository, tempdir, tmpCP);
/*     */     }
/*  77 */     return new AOPClassPool(cl, parent, repository);
/*     */   }
/*     */ 
/*     */   protected File getTempDirectory(ClassLoader cl)
/*     */   {
/*  82 */     File tempdir = null;
/*  83 */     int attempts = 0;
/*  84 */     IOException ex = null;
/*  85 */     while ((tempdir == null) && (attempts < 5))
/*     */     {
/*     */       try
/*     */       {
/*  90 */         tempdir = createTempDir(cl);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/*  94 */         ex = e;
/*     */       }
/*     */     }
/*     */ 
/*  98 */     if (tempdir == null)
/*     */     {
/* 100 */       throw new RuntimeException("", ex);
/*     */     }
/*     */ 
/* 103 */     return tempdir;
/*     */   }
/*     */ 
/*     */   public File createTempDir(ClassLoader cl) throws IOException
/*     */   {
/* 108 */     File tempdir = File.createTempFile("ucl", "", this.tmpClassesDir);
/* 109 */     tempdir.delete();
/* 110 */     tempdir.mkdir();
/* 111 */     tempdir.deleteOnExit();
/*     */ 
/* 113 */     return tempdir;
/*     */   }
/*     */ 
/*     */   private URL createURLAndAddToLoader(ClassLoader cl, File tempdir) throws IOException
/*     */   {
/* 118 */     URL tmpURL = tempdir.toURL();
/* 119 */     URL tmpCP = new URL(tmpURL, "?dynamic=true");
/*     */ 
/* 121 */     RepositoryClassLoader ucl = (RepositoryClassLoader)cl;
/*     */ 
/* 124 */     if (ucl.getLoaderRepository() != null)
/*     */     {
/* 126 */       ucl.addURL(tmpCP);
/*     */     }
/*     */ 
/* 129 */     return tmpCP;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.asintegration.jboss4.JBossClassPoolFactory
 * JD-Core Version:    0.6.0
 */