/*     */ package org.jboss.aop.asintegration.jboss4;
/*     */ 
/*     */ import java.io.File;
/*     */ import javassist.ClassPool;
/*     */ import javassist.scopedpool.ScopedClassPool;
/*     */ import javassist.scopedpool.ScopedClassPoolFactory;
/*     */ import javassist.scopedpool.ScopedClassPoolRepository;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ReflectionException;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.asintegration.JBossIntegration;
/*     */ import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
/*     */ import org.jboss.aop.deployment.AspectManagerService;
/*     */ import org.jboss.mx.loading.RepositoryClassLoader;
/*     */ import org.jboss.mx.util.MBeanServerLocator;
/*     */ 
/*     */ public class JBoss4Integration
/*     */   implements JBossIntegration, ScopedClassPoolFactory
/*     */ {
/*     */   private ScopedClassPoolFactory delegateClassPoolFactory;
/*     */ 
/*     */   public boolean isValidClassLoader(ClassLoader loader)
/*     */   {
/*  73 */     if (!(loader instanceof RepositoryClassLoader)) return false;
/*  74 */     return ((RepositoryClassLoader)loader).getLoaderRepository() != null;
/*     */   }
/*     */ 
/*     */   public AOPClassLoaderScopingPolicy createAOPClassLoaderScopingPolicy()
/*     */   {
/*  79 */     return new RepositoryClassLoaderScopingPolicy();
/*     */   }
/*     */ 
/*     */   public ScopedClassPoolFactory createScopedClassPoolFactory(File tmpDir) throws Exception
/*     */   {
/*  84 */     this.delegateClassPoolFactory = new JBossClassPoolFactory(tmpDir);
/*  85 */     return this;
/*     */   }
/*     */ 
/*     */   public ScopedClassPool create(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository)
/*     */   {
/*  90 */     return this.delegateClassPoolFactory.create(cl, src, repository);
/*     */   }
/*     */ 
/*     */   public ScopedClassPool create(ClassPool src, ScopedClassPoolRepository repository)
/*     */   {
/*  95 */     return this.delegateClassPoolFactory.create(src, repository);
/*     */   }
/*     */ 
/*     */   public void attachDeprecatedTranslator()
/*     */   {
/* 100 */     AspectManager mgr = AspectManager.instance();
/* 101 */     MBeanServer server = MBeanServerLocator.locateJBoss();
/*     */     try
/*     */     {
/* 104 */       server.setAttribute(AspectManagerService.DEFAULT_LOADER_REPOSITORY, new Attribute("Translator", mgr));
/*     */     }
/*     */     catch (InstanceNotFoundException e)
/*     */     {
/* 108 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (AttributeNotFoundException e)
/*     */     {
/* 112 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (InvalidAttributeValueException e)
/*     */     {
/* 116 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (MBeanException e)
/*     */     {
/* 120 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (ReflectionException e)
/*     */     {
/* 124 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void detachDeprecatedTranslator()
/*     */   {
/* 130 */     MBeanServer server = MBeanServerLocator.locateJBoss();
/*     */     try
/*     */     {
/* 133 */       server.setAttribute(AspectManagerService.DEFAULT_LOADER_REPOSITORY, new Attribute("Translator", null));
/*     */     }
/*     */     catch (InstanceNotFoundException e)
/*     */     {
/* 137 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (AttributeNotFoundException e)
/*     */     {
/* 141 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (InvalidAttributeValueException e)
/*     */     {
/* 145 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (MBeanException e)
/*     */     {
/* 149 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (ReflectionException e)
/*     */     {
/* 153 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.asintegration.jboss4.JBoss4Integration
 * JD-Core Version:    0.6.0
 */