/*     */ package org.jboss.aop.array;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import java.util.WeakHashMap;
/*     */ import java.util.concurrent.locks.Lock;
/*     */ import java.util.concurrent.locks.ReadWriteLock;
/*     */ import java.util.concurrent.locks.ReentrantReadWriteLock;
/*     */ 
/*     */ public class ArrayRegistry
/*     */ {
/*  39 */   private static final ArrayRegistryEntryFactory ELEMENT_ARRAY_REGISTRY_ENTRY_FACTORY = new ElementArrayRegistryEntryFactory(null);
/*  40 */   private static final ArrayRegistryEntryFactory FIELD_ARRAY_REGISTRY_ENTRY_FACTORY = new FieldArrayRegistryEntryFactory(null);
/*  41 */   private ArrayReferenceBuilder referenceBuilder = new ArrayReferenceBuilder(null);
/*  42 */   private static ArrayRegistry singleton = new ArrayRegistry();
/*  43 */   private ReadWriteLock lock = new ReentrantReadWriteLock();
/*  44 */   private WeakHashMap<Object, WeakHashMap<Object, HashMap<Object, ArrayRegistryEntry>>> cache = new WeakHashMap();
/*     */ 
/*     */   public static ArrayRegistry getInstance()
/*     */   {
/*  48 */     return singleton;
/*     */   }
/*     */ 
/*     */   public void addFieldReference(Object owner, String fieldName, Object array)
/*     */   {
/*  58 */     if (array == null)
/*     */     {
/*  60 */       return;
/*     */     }
/*  62 */     addReference(owner, fieldName, array, FIELD_ARRAY_REGISTRY_ENTRY_FACTORY);
/*     */   }
/*     */ 
/*     */   public void addElementReference(Object owner, int index, Object array)
/*     */   {
/*  67 */     if (array == null)
/*     */     {
/*  69 */       return;
/*     */     }
/*  71 */     addReference(owner, new Integer(index), array, ELEMENT_ARRAY_REGISTRY_ENTRY_FACTORY);
/*     */   }
/*     */ 
/*     */   public void addReference(Object owner, Object qualifier, Object array, ArrayRegistryEntryFactory factory)
/*     */   {
/*  76 */     if (array == null)
/*     */     {
/*  78 */       return;
/*     */     }
/*  80 */     Lock writeLock = this.lock.writeLock();
/*  81 */     writeLock.lock();
/*     */     try
/*     */     {
/*  84 */       WeakHashMap arrayReferences = (WeakHashMap)this.cache.get(array);
/*  85 */       if (arrayReferences == null)
/*     */       {
/*  87 */         arrayReferences = new WeakHashMap();
/*  88 */         this.cache.put(array, arrayReferences);
/*     */       }
/*     */ 
/*  91 */       HashMap ownerReferences = (HashMap)arrayReferences.get(owner);
/*  92 */       if (ownerReferences == null)
/*     */       {
/*  94 */         ownerReferences = new HashMap();
/*  95 */         arrayReferences.put(owner, ownerReferences);
/*     */       }
/*     */ 
/*  98 */       ArrayRegistryEntry regEntry = (ArrayRegistryEntry)ownerReferences.get(qualifier);
/*  99 */       if ((regEntry == null) || (regEntry.getArray() != array))
/*     */       {
/* 101 */         ArrayRegistryEntry entry = factory.createArrayRegistryEntry(owner, qualifier, factory);
/* 102 */         ownerReferences.put(qualifier, entry);
/*     */       }
/* 104 */       addNestedArrays(array);
/*     */     }
/*     */     finally
/*     */     {
/* 108 */       writeLock.unlock();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeFieldReference(Object owner, String fieldName, Object array)
/*     */   {
/* 114 */     if (array == null)
/*     */     {
/* 116 */       return;
/*     */     }
/*     */ 
/* 119 */     removeReference(owner, fieldName, array);
/*     */   }
/*     */ 
/*     */   public void removeElementReference(Object owner, int index, Object array)
/*     */   {
/* 124 */     if (array == null)
/*     */     {
/* 126 */       return;
/*     */     }
/*     */ 
/* 129 */     removeReference(owner, new Integer(index), array);
/*     */   }
/*     */ 
/*     */   public void removeReference(Object owner, Object qualifier, Object array)
/*     */   {
/* 134 */     if (array == null)
/*     */     {
/* 136 */       return;
/*     */     }
/*     */ 
/* 139 */     Lock writeLock = this.lock.writeLock();
/* 140 */     writeLock.lock();
/*     */     try
/*     */     {
/* 143 */       WeakHashMap arrayReferences = (WeakHashMap)this.cache.get(array);
/* 144 */       if (arrayReferences != null)
/*     */       {
/* 146 */         HashMap ownerReferences = (HashMap)arrayReferences.get(owner);
/* 147 */         if (ownerReferences != null)
/*     */         {
/* 149 */           ArrayRegistryEntry regEntry = (ArrayRegistryEntry)ownerReferences.remove(qualifier);
/* 150 */           if (regEntry != null)
/*     */           {
/* 152 */             if (ownerReferences.size() == 0)
/*     */             {
/* 154 */               arrayReferences.remove(owner);
/*     */ 
/* 156 */               if (arrayReferences.size() == 0)
/*     */               {
/* 158 */                 this.cache.remove(array);
/*     */               }
/*     */             }
/*     */ 
/* 162 */             removeNestedArrays(array);
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */     finally
/*     */     {
/* 171 */       writeLock.unlock();
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isRegistered(Object array)
/*     */   {
/* 177 */     Lock readLock = this.lock.readLock();
/* 178 */     readLock.lock();
/*     */     try
/*     */     {
/* 182 */       WeakHashMap arrayReferences = (WeakHashMap)this.cache.get(array);
/* 183 */       if (arrayReferences == null)
/*     */       {
/* 185 */         i = 0;
/*     */         return i;
/*     */       }
/* 187 */       int i = 1;
/*     */       return i; } finally { readLock.unlock(); } throw localObject;
/*     */   }
/*     */ 
/*     */   public List<ArrayReference> getArrayOwners(Object array)
/*     */   {
/* 197 */     Lock readLock = this.lock.readLock();
/* 198 */     readLock.lock();
/*     */     try
/*     */     {
/* 202 */       List localList = this.referenceBuilder.getArrayReferences(array);
/*     */       return localList; } finally { readLock.unlock(); } throw localObject;
/*     */   }
/*     */ 
/*     */   private void addNestedArrays(Object array)
/*     */   {
/* 212 */     if (array == null)
/*     */     {
/* 214 */       return;
/*     */     }
/* 216 */     ArrayType type = isArray(array);
/* 217 */     if (type == ArrayType.MULTIDIM_ARRAY)
/*     */     {
/* 219 */       for (int i = 0; i < ((Object[])(Object[])array).length; i++)
/*     */       {
/* 221 */         addElementReference(array, i, ((Object[])(Object[])array)[i]);
/* 222 */         addNestedArrays(((Object[])(Object[])array)[i]);
/*     */       }
/*     */     }
/* 225 */     else if (type == ArrayType.OBJECT_ARRAY)
/*     */     {
/* 227 */       for (int i = 0; i < ((Object[])(Object[])array).length; i++)
/*     */       {
/* 229 */         Object val = ((Object[])(Object[])array)[i];
/* 230 */         if ((val == null) || (!val.getClass().isArray()))
/*     */           continue;
/* 232 */         addElementReference(array, i, ((Object[])(Object[])array)[i]);
/* 233 */         addNestedArrays(((Object[])(Object[])array)[i]);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void removeNestedArrays(Object array)
/*     */   {
/* 241 */     if (array == null)
/*     */     {
/* 243 */       return;
/*     */     }
/* 245 */     ArrayType type = isArray(array);
/* 246 */     if (type == ArrayType.MULTIDIM_ARRAY)
/*     */     {
/* 248 */       for (int i = 0; i < ((Object[])(Object[])array).length; i++)
/*     */       {
/* 250 */         removeElementReference(array, i, ((Object[])(Object[])array)[i]);
/* 251 */         removeNestedArrays(((Object[])(Object[])array)[i]);
/*     */       }
/*     */     }
/* 254 */     else if (type == ArrayType.OBJECT_ARRAY)
/*     */     {
/* 256 */       for (int i = 0; i < ((Object[])(Object[])array).length; i++)
/*     */       {
/* 258 */         Object val = ((Object[])(Object[])array)[i];
/* 259 */         if ((val == null) || (!val.getClass().isArray()))
/*     */           continue;
/* 261 */         removeElementReference(array, i, ((Object[])(Object[])array)[i]);
/* 262 */         removeNestedArrays(((Object[])(Object[])array)[i]);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private ArrayType isArray(Object arrayCandidate)
/*     */   {
/* 270 */     Class candidateClass = arrayCandidate.getClass();
/* 271 */     if (candidateClass.isArray())
/*     */     {
/* 273 */       Class componentType = candidateClass.getComponentType();
/* 274 */       if (componentType.isArray())
/*     */       {
/* 276 */         return ArrayType.MULTIDIM_ARRAY;
/*     */       }
/* 278 */       if (componentType == Object.class)
/*     */       {
/* 280 */         return ArrayType.OBJECT_ARRAY;
/*     */       }
/*     */     }
/* 283 */     return ArrayType.NOT_ARRAY;
/*     */   }
/*     */ 
/*     */   private static enum ArrayType
/*     */   {
/* 384 */     NOT_ARRAY, MULTIDIM_ARRAY, OBJECT_ARRAY;
/*     */   }
/*     */ 
/*     */   private class ArrayReferenceBuilder
/*     */   {
/*     */     private ArrayReferenceBuilder()
/*     */     {
/*     */     }
/*     */ 
/*     */     private List<ArrayReference> getArrayReferences(Object array)
/*     */     {
/* 311 */       List references = null;
/* 312 */       WeakHashMap arrayReferences = (WeakHashMap)ArrayRegistry.this.cache.get(array);
/*     */       Iterator i$;
/* 313 */       if ((arrayReferences != null) && (arrayReferences.size() > 0))
/*     */       {
/* 315 */         for (i$ = arrayReferences.keySet().iterator(); i$.hasNext(); ) { Object owner = i$.next();
/*     */ 
/* 317 */           ownerReferences = (HashMap)arrayReferences.get(owner);
/* 318 */           for (i$ = ownerReferences.keySet().iterator(); i$.hasNext(); ) { Object qualifier = i$.next();
/*     */ 
/* 320 */             ArrayRegistryEntry regEntry = (ArrayRegistryEntry)ownerReferences.get(qualifier);
/*     */ 
/* 322 */             if (regEntry.isOwnerRoot())
/*     */             {
/* 324 */               ArrayReference reference = getRootReference((FieldArrayRegistryEntry)regEntry);
/* 325 */               if (reference != null)
/*     */               {
/* 327 */                 if (references == null)
/*     */                 {
/* 329 */                   references = new ArrayList();
/*     */                 }
/* 331 */                 references.add(reference);
/*     */               }
/*     */             }
/*     */             else
/*     */             {
/* 336 */               List parentReferences = getElementReferences((ElementArrayRegistryEntry)regEntry);
/* 337 */               if (parentReferences != null)
/*     */               {
/* 339 */                 if (references == null)
/*     */                 {
/* 341 */                   references = new ArrayList();
/*     */                 }
/* 343 */                 references.addAll(parentReferences);
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */       HashMap ownerReferences;
/*     */       Iterator i$;
/* 349 */       return references;
/*     */     }
/*     */ 
/*     */     private ArrayReference getRootReference(FieldArrayRegistryEntry regEntry)
/*     */     {
/* 354 */       Object root = regEntry.getOwner();
/* 355 */       if (root != null)
/*     */       {
/* 357 */         String fieldName = regEntry.getFieldName();
/* 358 */         return new ArrayReferenceImpl(root, fieldName);
/*     */       }
/* 360 */       return null;
/*     */     }
/*     */ 
/*     */     private List<ArrayReference> getElementReferences(ElementArrayRegistryEntry regEntry)
/*     */     {
/* 365 */       Object ownerArray = regEntry.getOwner();
/* 366 */       if (ownerArray != null)
/*     */       {
/* 368 */         List references = getArrayReferences(ownerArray);
/* 369 */         if ((references != null) && (references.size() > 0))
/*     */         {
/* 371 */           for (ArrayReference reference : references)
/*     */           {
/* 373 */             ((ArrayReferenceImpl)reference).addNestedArrayIndex(regEntry.getIndex());
/*     */           }
/*     */         }
/* 376 */         return references;
/*     */       }
/* 378 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class ElementArrayRegistryEntryFactory
/*     */     implements ArrayRegistry.ArrayRegistryEntryFactory
/*     */   {
/*     */     public ArrayRegistryEntry createArrayRegistryEntry(Object owner, Object qualifier, Object array)
/*     */     {
/* 303 */       return new ElementArrayRegistryEntry(owner, (Integer)qualifier, array);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class FieldArrayRegistryEntryFactory
/*     */     implements ArrayRegistry.ArrayRegistryEntryFactory
/*     */   {
/*     */     public ArrayRegistryEntry createArrayRegistryEntry(Object owner, Object qualifier, Object array)
/*     */     {
/* 295 */       return new FieldArrayRegistryEntry(owner, (String)qualifier, array);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static abstract interface ArrayRegistryEntryFactory
/*     */   {
/*     */     public abstract ArrayRegistryEntry createArrayRegistryEntry(Object paramObject1, Object paramObject2, Object paramObject3);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.array.ArrayRegistry
 * JD-Core Version:    0.6.0
 */