/*     */ package org.jboss.aop.array;
/*     */ 
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.InvocationBase;
/*     */ import org.jboss.aop.metadata.MetaDataResolver;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ 
/*     */ public abstract class ArrayElementInvocation extends InvocationBase
/*     */ {
/*     */   int index;
/*     */ 
/*     */   public ArrayElementInvocation(Interceptor[] interceptors, Object array, int index)
/*     */   {
/*  46 */     super(interceptors);
/*  47 */     super.setTargetObject(array);
/*  48 */     this.index = index;
/*     */   }
/*     */ 
/*     */   public int getIndex()
/*     */   {
/*  53 */     return this.index;
/*     */   }
/*     */ 
/*     */   public Object invokeNext()
/*     */     throws Throwable
/*     */   {
/*  62 */     if ((this.interceptors != null) && (this.currentInterceptor < this.interceptors.length))
/*     */     {
/*     */       try
/*     */       {
/*  66 */         Object localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */         return localObject1; } finally { this.currentInterceptor -= 1;
/*     */       }
/*     */     }
/*     */ 
/*  75 */     return invokeTarget();
/*     */   }
/*     */ 
/*     */   public abstract Object invokeTarget();
/*     */ 
/*     */   public void addResponseAttachment(Object key, Object val)
/*     */   {
/*  84 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Advisor getAdvisor()
/*     */   {
/*  90 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public int getCurrentInterceptor()
/*     */   {
/*  96 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Object getResponseAttachment(Object key)
/*     */   {
/* 102 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Map getResponseContextInfo()
/*     */   {
/* 108 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Object resolveAnnotation(Class annotation)
/*     */   {
/* 114 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Object resolveAnnotation(Class[] annotations)
/*     */   {
/* 120 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Object resolveClassAnnotation(Class annotation)
/*     */   {
/* 126 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Object resolveClassMetaData(Object key, Object attr)
/*     */   {
/* 132 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public void setAdvisor(Advisor advisor)
/*     */   {
/* 138 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public void setInstanceResolver(MetaDataResolver instanceResolver)
/*     */   {
/* 144 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public void setResponseContextInfo(Map responseContextInfo)
/*     */   {
/* 150 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Invocation copy()
/*     */   {
/* 155 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Invocation getWrapper(Interceptor[] newchain)
/*     */   {
/* 160 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public List<ArrayReference> getArrayOwners()
/*     */   {
/* 165 */     ArrayRegistry registry = ArrayRegistry.getInstance();
/* 166 */     return registry.getArrayOwners(this.targetObject);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.array.ArrayElementInvocation
 * JD-Core Version:    0.6.0
 */