/*    */ package org.jboss.aop.array;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.Arrays;
/*    */ import java.util.List;
/*    */ import org.jboss.aop.advice.InterceptorFactory;
/*    */ 
/*    */ public class ArrayBinding
/*    */ {
/*    */   protected String name;
/*    */   protected Type type;
/* 42 */   protected InterceptorFactory[] interceptorFactories = new InterceptorFactory[0];
/*    */ 
/*    */   public ArrayBinding(String name, InterceptorFactory[] factories, Type type)
/*    */   {
/* 46 */     this.name = name;
/* 47 */     this.interceptorFactories = factories;
/* 48 */     this.type = type;
/*    */   }
/*    */ 
/*    */   public void addInterceptorFactory(InterceptorFactory factory)
/*    */   {
/* 53 */     List list = Arrays.asList(this.interceptorFactories);
/* 54 */     list = new ArrayList(list);
/* 55 */     list.add(factory);
/* 56 */     this.interceptorFactories = ((InterceptorFactory[])(InterceptorFactory[])list.toArray(new InterceptorFactory[list.size()]));
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 62 */     return this.name;
/*    */   }
/*    */ 
/*    */   public InterceptorFactory[] getInterceptorFactories()
/*    */   {
/* 67 */     return this.interceptorFactories;
/*    */   }
/*    */ 
/*    */   public boolean equals(Object obj)
/*    */   {
/* 72 */     if (obj == this) return true;
/* 73 */     if (!(obj instanceof ArrayBinding)) return false;
/* 74 */     return ((ArrayBinding)obj).getName().equals(this.name);
/*    */   }
/*    */ 
/*    */   public int hashCode()
/*    */   {
/* 79 */     return this.name.hashCode();
/*    */   }
/*    */ 
/*    */   public boolean isRead()
/*    */   {
/* 84 */     return (this.type == Type.READ_ONLY) || (this.type == Type.READ_WRITE);
/*    */   }
/*    */ 
/*    */   public boolean isWrite()
/*    */   {
/* 89 */     return (this.type == Type.WRITE_ONLY) || (this.type == Type.READ_WRITE);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.array.ArrayBinding
 * JD-Core Version:    0.6.0
 */