/*     */ package org.jboss.aop.array;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.LinkedHashSet;
/*     */ import java.util.concurrent.locks.Lock;
/*     */ import java.util.concurrent.locks.ReadWriteLock;
/*     */ import java.util.concurrent.locks.ReentrantReadWriteLock;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.advice.AdviceFactory;
/*     */ import org.jboss.aop.advice.GeneratedAdvisorInterceptor;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.advice.InterceptorFactory;
/*     */ import org.jboss.aop.advice.PerVmAdvice;
/*     */ import org.jboss.aop.advice.PrecedenceSorter;
/*     */ import org.jboss.aop.advice.ScopedInterceptorFactory;
/*     */ 
/*     */ public class ArrayAdvisor
/*     */ {
/*  47 */   static HashSet<ArrayBinding> bindings = new LinkedHashSet();
/*     */   static boolean updated;
/*     */ 
/*     */   public static void addBinding(ArrayBinding arrayBinding)
/*     */   {
/*  52 */     ChainCreator.addBinding(arrayBinding);
/*     */   }
/*     */ 
/*     */   public static void removeBinding(ArrayBinding arrayBinding)
/*     */   {
/*  57 */     ChainCreator.removeBinding(arrayBinding);
/*     */   }
/*     */ 
/*     */   public static Interceptor[] getReadInterceptors()
/*     */   {
/*  62 */     return ChainCreator.getReadInterceptors();
/*     */   }
/*     */ 
/*     */   public static Interceptor[] getWriteInterceptors()
/*     */   {
/*  67 */     return ChainCreator.getWriteInterceptors();
/*     */   }
/*     */ 
/*     */   public static void updateArrayField(Object target, String fieldName, Object oldValue, Object newValue)
/*     */   {
/*  72 */     ArrayRegistry registry = ArrayRegistry.getInstance();
/*  73 */     registry.removeFieldReference(target, fieldName, oldValue);
/*  74 */     registry.addFieldReference(target, fieldName, newValue);
/*     */   }
/*     */ 
/*     */   public static void arrayWriteObject(Object array, int index, Object value) throws Throwable
/*     */   {
/*  79 */     Interceptor[] interceptors = getWriteInterceptors();
/*  80 */     ArrayRegistry registry = ArrayRegistry.getInstance();
/*  81 */     if (registry.isRegistered(array))
/*     */     {
/*  84 */       Object oldValue = ((Object[])(Object[])array)[index];
/*  85 */       boolean ignoreUpdate = oldValue == value;
/*  86 */       if (!ignoreUpdate)
/*     */       {
/*  88 */         registry.removeElementReference(array, index, oldValue);
/*     */ 
/*  91 */         if ((value != null) && (value.getClass().isArray()))
/*     */         {
/*  93 */           registry.addElementReference(array, index, value);
/*     */         }
/*  95 */         if (interceptors != null)
/*     */         {
/*  97 */           ObjectArrayElementWriteInvocation invocation = new ObjectArrayElementWriteInvocation(interceptors, (Object[])(Object[])array, index, value);
/*  98 */           invocation.invokeNext();
/*  99 */           return;
/*     */         }
/*     */       }
/*     */     }
/* 103 */     ((Object[])(Object[])array)[index] = value;
/*     */   }
/*     */ 
/*     */   public static void arrayWriteInt(Object array, int index, int value) throws Throwable
/*     */   {
/* 108 */     Interceptor[] interceptors = getWriteInterceptors();
/* 109 */     if ((interceptors != null) && (ArrayRegistry.getInstance().isRegistered(array)) && (((int[])(int[])array)[index] != value))
/*     */     {
/* 111 */       IntArrayElementWriteInvocation invocation = new IntArrayElementWriteInvocation(interceptors, (int[])(int[])array, index, value);
/* 112 */       invocation.invokeNext();
/*     */     }
/*     */     else
/*     */     {
/* 116 */       ((int[])(int[])array)[index] = value;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void arrayWriteByteOrBoolean(Object array, int index, byte value) throws Throwable
/*     */   {
/* 122 */     Interceptor[] interceptors = getWriteInterceptors();
/* 123 */     if ((interceptors != null) && (ArrayRegistry.getInstance().isRegistered(array)))
/*     */     {
/* 125 */       if ((array instanceof boolean[]))
/*     */       {
/* 127 */         if (((boolean[])(boolean[])array)[index] != ByteBooleanConverter.toBoolean(value))
/*     */         {
/* 130 */           BooleanArrayElementWriteInvocation invocation = new BooleanArrayElementWriteInvocation(interceptors, (boolean[])(boolean[])array, index, ByteBooleanConverter.toBoolean(value));
/* 131 */           invocation.invokeNext();
/* 132 */           return;
/*     */         }
/* 134 */         ((boolean[])(boolean[])array)[index] = ByteBooleanConverter.toBoolean(value);
/*     */       }
/*     */       else
/*     */       {
/* 138 */         if (((byte[])(byte[])array)[index] != value)
/*     */         {
/* 140 */           ByteArrayElementWriteInvocation invocation = new ByteArrayElementWriteInvocation(interceptors, (byte[])(byte[])array, index, value);
/* 141 */           invocation.invokeNext();
/* 142 */           return;
/*     */         }
/* 144 */         ((byte[])(byte[])array)[index] = value;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void arrayWriteChar(Object array, int index, char value) throws Throwable
/*     */   {
/* 151 */     Interceptor[] interceptors = getWriteInterceptors();
/* 152 */     if ((interceptors != null) && (ArrayRegistry.getInstance().isRegistered(array)) && (((char[])(char[])array)[index] != value))
/*     */     {
/* 154 */       CharArrayElementWriteInvocation invocation = new CharArrayElementWriteInvocation(interceptors, (char[])(char[])array, index, value);
/* 155 */       invocation.invokeNext();
/*     */     }
/*     */     else
/*     */     {
/* 159 */       ((char[])(char[])array)[index] = value;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void arrayWriteDouble(Object array, int index, double value) throws Throwable
/*     */   {
/* 165 */     Interceptor[] interceptors = getWriteInterceptors();
/* 166 */     if ((interceptors != null) && (ArrayRegistry.getInstance().isRegistered(array)) && (((double[])(double[])array)[index] != value))
/*     */     {
/* 168 */       DoubleArrayElementWriteInvocation invocation = new DoubleArrayElementWriteInvocation(interceptors, (double[])(double[])array, index, value);
/* 169 */       invocation.invokeNext();
/*     */     }
/*     */     else
/*     */     {
/* 173 */       ((double[])(double[])array)[index] = value;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void arrayWriteShort(Object array, int index, short value) throws Throwable
/*     */   {
/* 179 */     Interceptor[] interceptors = getWriteInterceptors();
/* 180 */     if ((interceptors != null) && (ArrayRegistry.getInstance().isRegistered(array)) && (((short[])(short[])array)[index] != value))
/*     */     {
/* 182 */       ShortArrayElementWriteInvocation invocation = new ShortArrayElementWriteInvocation(interceptors, (short[])(short[])array, index, value);
/* 183 */       invocation.invokeNext();
/*     */     }
/*     */     else
/*     */     {
/* 187 */       ((short[])(short[])array)[index] = value;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void arrayWriteFloat(Object array, int index, float value) throws Throwable
/*     */   {
/* 193 */     Interceptor[] interceptors = getWriteInterceptors();
/* 194 */     if ((interceptors != null) && (ArrayRegistry.getInstance().isRegistered(array)) && (((float[])(float[])array)[index] != value))
/*     */     {
/* 196 */       FloatArrayElementWriteInvocation invocation = new FloatArrayElementWriteInvocation(interceptors, (float[])(float[])array, index, value);
/* 197 */       invocation.invokeNext();
/*     */     }
/*     */     else
/*     */     {
/* 201 */       ((float[])(float[])array)[index] = value;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void arrayWriteLong(Object array, int index, long value) throws Throwable
/*     */   {
/* 207 */     Interceptor[] interceptors = getWriteInterceptors();
/* 208 */     if ((interceptors != null) && (ArrayRegistry.getInstance().isRegistered(array)) && (((long[])(long[])array)[index] != value))
/*     */     {
/* 210 */       LongArrayElementWriteInvocation invocation = new LongArrayElementWriteInvocation(interceptors, (long[])(long[])array, index, value);
/* 211 */       invocation.invokeNext();
/*     */     }
/*     */     else
/*     */     {
/* 215 */       ((long[])(long[])array)[index] = value;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Object arrayReadObject(Object array, int index) throws Throwable
/*     */   {
/* 221 */     Interceptor[] interceptors = getReadInterceptors();
/* 222 */     if ((interceptors != null) && (ArrayRegistry.getInstance().isRegistered(array)))
/*     */     {
/* 224 */       ObjectArrayElementReadInvocation invocation = new ObjectArrayElementReadInvocation(interceptors, (Object[])(Object[])array, index);
/* 225 */       return invocation.invokeNext();
/*     */     }
/*     */ 
/* 229 */     return ((Object[])(Object[])array)[index];
/*     */   }
/*     */ 
/*     */   public static int arrayReadInt(Object array, int index)
/*     */     throws Throwable
/*     */   {
/* 235 */     Interceptor[] interceptors = getReadInterceptors();
/* 236 */     if ((interceptors != null) && (ArrayRegistry.getInstance().isRegistered(array)))
/*     */     {
/* 238 */       IntArrayElementReadInvocation invocation = new IntArrayElementReadInvocation(interceptors, (int[])(int[])array, index);
/* 239 */       return ((Integer)invocation.invokeNext()).intValue();
/*     */     }
/*     */ 
/* 243 */     return ((int[])(int[])array)[index];
/*     */   }
/*     */ 
/*     */   public static byte arrayReadByteOrBoolean(Object array, int index)
/*     */     throws Throwable
/*     */   {
/* 249 */     Interceptor[] interceptors = getReadInterceptors();
/* 250 */     if ((interceptors != null) && (ArrayRegistry.getInstance().isRegistered(array)))
/*     */     {
/* 252 */       if ((array instanceof boolean[]))
/*     */       {
/* 254 */         BooleanArrayElementReadInvocation invocation = new BooleanArrayElementReadInvocation(interceptors, (boolean[])(boolean[])array, index);
/* 255 */         boolean b = ((Boolean)invocation.invokeNext()).booleanValue();
/* 256 */         return ByteBooleanConverter.toByte(b);
/*     */       }
/*     */ 
/* 260 */       ByteArrayElementReadInvocation invocation = new ByteArrayElementReadInvocation(interceptors, (byte[])(byte[])array, index);
/* 261 */       return ((Byte)invocation.invokeNext()).byteValue();
/*     */     }
/*     */ 
/* 266 */     if ((array instanceof boolean[]))
/*     */     {
/* 268 */       return ByteBooleanConverter.toByte(((boolean[])(boolean[])array)[index]);
/*     */     }
/*     */ 
/* 272 */     return ((byte[])(byte[])array)[index];
/*     */   }
/*     */ 
/*     */   public static char arrayReadChar(Object array, int index)
/*     */     throws Throwable
/*     */   {
/* 279 */     Interceptor[] interceptors = getReadInterceptors();
/* 280 */     if ((interceptors != null) && (ArrayRegistry.getInstance().isRegistered(array)))
/*     */     {
/* 282 */       CharArrayElementReadInvocation invocation = new CharArrayElementReadInvocation(interceptors, (char[])(char[])array, index);
/* 283 */       return ((Character)invocation.invokeNext()).charValue();
/*     */     }
/*     */ 
/* 287 */     return ((char[])(char[])array)[index];
/*     */   }
/*     */ 
/*     */   public static double arrayReadDouble(Object array, int index)
/*     */     throws Throwable
/*     */   {
/* 293 */     Interceptor[] interceptors = getReadInterceptors();
/* 294 */     if ((interceptors != null) && (ArrayRegistry.getInstance().isRegistered(array)))
/*     */     {
/* 296 */       DoubleArrayElementReadInvocation invocation = new DoubleArrayElementReadInvocation(interceptors, (double[])(double[])array, index);
/* 297 */       return ((Double)invocation.invokeNext()).doubleValue();
/*     */     }
/*     */ 
/* 301 */     return ((double[])(double[])array)[index];
/*     */   }
/*     */ 
/*     */   public static float arrayReadFloat(Object array, int index)
/*     */     throws Throwable
/*     */   {
/* 307 */     Interceptor[] interceptors = getReadInterceptors();
/* 308 */     if ((interceptors != null) && (ArrayRegistry.getInstance().isRegistered(array)))
/*     */     {
/* 310 */       FloatArrayElementReadInvocation invocation = new FloatArrayElementReadInvocation(interceptors, (float[])(float[])array, index);
/* 311 */       return ((Float)invocation.invokeNext()).floatValue();
/*     */     }
/*     */ 
/* 315 */     return ((float[])(float[])array)[index];
/*     */   }
/*     */ 
/*     */   public static long arrayReadLong(Object array, int index)
/*     */     throws Throwable
/*     */   {
/* 321 */     Interceptor[] interceptors = getReadInterceptors();
/* 322 */     if ((interceptors != null) && (ArrayRegistry.getInstance().isRegistered(array)))
/*     */     {
/* 324 */       LongArrayElementReadInvocation invocation = new LongArrayElementReadInvocation(interceptors, (long[])(long[])array, index);
/* 325 */       return ((Long)invocation.invokeNext()).longValue();
/*     */     }
/*     */ 
/* 329 */     return ((long[])(long[])array)[index];
/*     */   }
/*     */ 
/*     */   public static short arrayReadShort(Object array, int index)
/*     */     throws Throwable
/*     */   {
/* 335 */     Interceptor[] interceptors = getReadInterceptors();
/* 336 */     if ((interceptors != null) && (ArrayRegistry.getInstance().isRegistered(array)))
/*     */     {
/* 338 */       ShortArrayElementReadInvocation invocation = new ShortArrayElementReadInvocation(interceptors, (short[])(short[])array, index);
/* 339 */       return ((Short)invocation.invokeNext()).shortValue();
/*     */     }
/*     */ 
/* 343 */     return ((short[])(short[])array)[index];
/*     */   }
/*     */   private static class ChainCreator {
/* 349 */     private static ReadWriteLock lock = new ReentrantReadWriteLock();
/*     */     static Interceptor[] readInterceptors;
/*     */     static Interceptor[] writeInterceptors;
/*     */ 
/* 354 */     public static void addBinding(ArrayBinding arrayBinding) { Lock writeLock = lock.writeLock();
/* 355 */       writeLock.lock();
/*     */       try
/*     */       {
/* 358 */         ArrayAdvisor.bindings.add(arrayBinding);
/* 359 */         ArrayAdvisor.updated = true;
/*     */       }
/*     */       finally
/*     */       {
/* 363 */         writeLock.unlock();
/*     */       }
/*     */     }
/*     */ 
/*     */     public static void removeBinding(ArrayBinding arrayBinding)
/*     */     {
/* 369 */       Lock writeLock = lock.writeLock();
/* 370 */       writeLock.lock();
/*     */       try
/*     */       {
/* 373 */         ArrayAdvisor.bindings.remove(arrayBinding);
/* 374 */         ArrayAdvisor.updated = true;
/*     */       }
/*     */       finally
/*     */       {
/* 378 */         writeLock.unlock();
/*     */       }
/*     */     }
/*     */ 
/*     */     public static Interceptor[] getReadInterceptors()
/*     */     {
/* 384 */       return getInterceptors(true);
/*     */     }
/*     */ 
/*     */     public static Interceptor[] getWriteInterceptors()
/*     */     {
/* 389 */       return getInterceptors(false);
/*     */     }
/*     */ 
/*     */     private static Interceptor[] getInterceptors(boolean read)
/*     */     {
/* 394 */       Lock readLock = lock.readLock();
/* 395 */       readLock.lock();
/* 396 */       boolean lockedRead = true;
/*     */       try
/*     */       {
/* 399 */         if (ArrayAdvisor.updated)
/*     */         {
/* 401 */           readLock.unlock();
/* 402 */           lockedRead = false;
/* 403 */           writeLock = lock.writeLock();
/* 404 */           writeLock.lock();
/*     */           try
/*     */           {
/* 407 */             if (ArrayAdvisor.updated)
/*     */             {
/* 410 */               ArrayList newReadInterceptors = new ArrayList();
/* 411 */               ArrayList newWriteInterceptors = new ArrayList();
/* 412 */               for (ArrayBinding binding : ArrayAdvisor.bindings)
/*     */               {
/* 414 */                 InterceptorFactory[] factories = binding.getInterceptorFactories();
/* 415 */                 for (int i = 0; i < factories.length; i++)
/*     */                 {
/* 417 */                   Interceptor icptr = createInterceptor(factories[i]);
/* 418 */                   if (icptr == null)
/*     */                     continue;
/* 420 */                   if (binding.isWrite())
/*     */                   {
/* 422 */                     newWriteInterceptors.add(icptr);
/*     */                   }
/* 424 */                   if (!binding.isRead())
/*     */                     continue;
/* 426 */                   newReadInterceptors.add(icptr);
/*     */                 }
/*     */ 
/*     */               }
/*     */ 
/* 431 */               readInterceptors = finalizeChain(newReadInterceptors);
/* 432 */               writeInterceptors = finalizeChain(newWriteInterceptors);
/* 433 */               ArrayAdvisor.updated = false;
/* 434 */               ??? = read ? readInterceptors : writeInterceptors;
/*     */ 
/* 439 */               writeLock.unlock();
/*     */ 
/* 446 */               if (lockedRead);
/*     */               return ???;
/*     */             }
/*     */           }
/*     */           finally
/*     */           {
/* 439 */             writeLock.unlock();
/*     */           }
/*     */         }
/* 442 */         Lock writeLock = read ? readInterceptors : writeInterceptors;
/*     */         return writeLock;
/*     */       }
/*     */       finally
/*     */       {
/* 446 */         if (lockedRead)
/*     */         {
/* 448 */           readLock.unlock(); } 
/* 448 */       }throw localObject2;
/*     */     }
/*     */ 
/*     */     private static Interceptor[] finalizeChain(ArrayList<Interceptor> newinterceptors)
/*     */     {
/* 455 */       Interceptor[] interceptors = newinterceptors.size() > 0 ? (Interceptor[])newinterceptors.toArray(new Interceptor[newinterceptors.size()]) : null;
/* 456 */       if (interceptors != null)
/*     */       {
/* 458 */         if ((interceptors[0] instanceof GeneratedAdvisorInterceptor));
/* 462 */         interceptors = PrecedenceSorter.applyPrecedence(interceptors, AspectManager.instance());
/*     */       }
/* 464 */       return interceptors;
/*     */     }
/*     */ 
/*     */     private static Interceptor createInterceptor(InterceptorFactory factory)
/*     */     {
/*     */       try
/*     */       {
/* 477 */         if (factory.isDeployed())
/*     */         {
/* 479 */           if ((factory instanceof AdviceFactory))
/*     */           {
/* 481 */             return PerVmAdvice.generateOptimized(null, AspectManager.instance(), factory.getAdvice(), factory.getAspect());
/*     */           }
/* 483 */           if ((factory instanceof ScopedInterceptorFactory))
/*     */           {
/* 485 */             return (Interceptor)AspectManager.instance().getPerVMAspect(factory.getAspect());
/*     */           }
/*     */         }
/*     */ 
/* 489 */         return null;
/*     */       }
/*     */       catch (Exception e) {
/*     */       }
/* 493 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.array.ArrayAdvisor
 * JD-Core Version:    0.6.0
 */