/*     */ package org.jboss.aop.annotation.util;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.bytecode.AnnotationsAttribute;
/*     */ import javassist.bytecode.ClassFile;
/*     */ import javassist.bytecode.ConstPool;
/*     */ import javassist.bytecode.FieldInfo;
/*     */ import javassist.bytecode.MethodInfo;
/*     */ import javassist.bytecode.annotation.Annotation;
/*     */ 
/*     */ public class FindAnnotations
/*     */ {
/*     */   public static ClassPool pool;
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws Exception
/*     */   {
/*  42 */     pool = ClassPool.getDefault();
/*  43 */     pool.appendSystemPath();
/*  44 */     pool.insertClassPath(".");
/*  45 */     CtClass clazz = pool.get(args[0]);
/*  46 */     clazz.getClassFile2().getConstPool().print();
/*  47 */     printClassAttributes(clazz);
/*     */   }
/*     */ 
/*     */   public static void printAnnotations(Annotation[] annotations)
/*     */   {
/*  52 */     for (int i = 0; i < annotations.length; i++)
/*     */     {
/*  54 */       printAnnotation(annotations[i]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void printClassAttributes(CtClass clazz) throws Exception
/*     */   {
/*  60 */     ClassFile cf = clazz.getClassFile();
/*  61 */     AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
/*  62 */     if (invisible != null)
/*     */     {
/*  64 */       System.out.println("** invisible class annotations **");
/*  65 */       Annotation[] annotations = invisible.getAnnotations();
/*  66 */       printAnnotations(annotations);
/*     */     }
/*     */ 
/*  69 */     AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
/*  70 */     if (visible != null)
/*     */     {
/*  72 */       System.out.println("** visible class annotations **");
/*  73 */       Annotation[] annotations = visible.getAnnotations();
/*  74 */       printAnnotations(annotations);
/*     */     }
/*     */ 
/*  77 */     System.out.println("**** method annotations ****");
/*  78 */     List methods = cf.getMethods();
/*  79 */     for (int i = 0; i < methods.size(); i++)
/*     */     {
/*  81 */       MethodInfo mi = (MethodInfo)methods.get(i);
/*  82 */       System.out.println("method: " + mi.getName());
/*  83 */       System.out.println("CONST POOL: ");
/*  84 */       mi.getConstPool().print();
/*  85 */       System.out.println("-------------");
/*  86 */       invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
/*  87 */       if (invisible != null)
/*     */       {
/*  89 */         System.out.println("** invisible method annotations **");
/*  90 */         Annotation[] annotations = invisible.getAnnotations();
/*  91 */         printAnnotations(annotations);
/*     */       }
/*     */ 
/*  94 */       visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
/*  95 */       if (visible != null)
/*     */       {
/*  97 */         System.out.println("** visible method annotations **");
/*  98 */         Annotation[] annotations = visible.getAnnotations();
/*  99 */         printAnnotations(annotations);
/*     */       }
/*     */ 
/* 102 */       System.out.println("----");
/*     */     }
/*     */ 
/* 105 */     System.out.println("**** field annotations ****");
/* 106 */     List fields = cf.getFields();
/* 107 */     for (int i = 0; i < fields.size(); i++)
/*     */     {
/* 109 */       FieldInfo mi = (FieldInfo)fields.get(i);
/* 110 */       System.out.println("field: " + mi.getName());
/* 111 */       System.out.println("CONST POOL: ");
/* 112 */       mi.getConstPool().print();
/* 113 */       System.out.println("field: " + mi.getName());
/* 114 */       invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
/* 115 */       if (invisible != null)
/*     */       {
/* 117 */         System.out.println("** invisible method annotations **");
/* 118 */         Annotation[] annotations = invisible.getAnnotations();
/* 119 */         printAnnotations(annotations);
/*     */       }
/*     */ 
/* 122 */       visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
/* 123 */       if (visible != null)
/*     */       {
/* 125 */         System.out.println("** visible method annotations **");
/* 126 */         Annotation[] annotations = visible.getAnnotations();
/* 127 */         printAnnotations(annotations);
/*     */       }
/*     */ 
/* 130 */       System.out.println("----");
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void printAnnotation(Annotation info)
/*     */   {
/* 136 */     System.out.print("@" + info.getTypeName());
/* 137 */     Set members = info.getMemberNames();
/* 138 */     if (members != null)
/*     */     {
/* 140 */       System.out.print("(");
/* 141 */       Iterator mit = members.iterator();
/* 142 */       while (mit.hasNext())
/*     */       {
/* 144 */         String name = (String)mit.next();
/* 145 */         System.out.print(name + "=" + info.getMemberValue(name).toString());
/* 146 */         if (mit.hasNext()) System.out.print(", ");
/*     */       }
/* 148 */       System.out.print(")");
/*     */     }
/* 150 */     System.out.println("");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.annotation.util.FindAnnotations
 * JD-Core Version:    0.6.0
 */