/*     */ package org.jboss.aop.annotation.compiler;
/*     */ 
/*     */ import com.thoughtworks.qdox.JavaDocBuilder;
/*     */ import com.thoughtworks.qdox.model.JavaClass;
/*     */ import com.thoughtworks.qdox.model.JavaField;
/*     */ import com.thoughtworks.qdox.model.JavaMethod;
/*     */ import com.thoughtworks.qdox.model.JavaParameter;
/*     */ import com.thoughtworks.qdox.model.JavaSource;
/*     */ import com.thoughtworks.qdox.model.Type;
/*     */ import java.io.File;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.FileReader;
/*     */ import java.io.PrintStream;
/*     */ import java.io.PrintWriter;
/*     */ import org.jboss.annotation.factory.ast.ASTAnnotation;
/*     */ import org.jboss.annotation.factory.ast.Node;
/*     */ 
/*     */ public class XmlAnnotationCompiler
/*     */ {
/*     */   public static void main(String[] args)
/*     */     throws Exception
/*     */   {
/*  46 */     XmlAnnotationCompiler c = new XmlAnnotationCompiler();
/*  47 */     c.compile(args);
/*     */   }
/*     */ 
/*     */   public void usage()
/*     */   {
/*  52 */     System.err.println("Usage: annotationc <files>+");
/*     */   }
/*     */ 
/*     */   public static void indenter(PrintWriter pw, int indent)
/*     */   {
/*  57 */     for (int i = 0; i < indent * 3; i++) pw.print(" ");
/*     */   }
/*     */ 
/*     */   public void compile(String[] args)
/*     */     throws Exception
/*     */   {
/*  63 */     if (args.length == 0)
/*     */     {
/*  65 */       usage();
/*  66 */       System.exit(1);
/*  67 */       return;
/*     */     }
/*  69 */     String outputFile = "metadata-aop.xml";
/*  70 */     JavaDocBuilder builder = new JavaDocBuilder(new AnnotationDocletTagFactory());
/*  71 */     for (int i = 0; i < args.length; i++)
/*     */     {
/*  73 */       if (args[i].equals("-o"))
/*     */       {
/*  75 */         i++; outputFile = args[i];
/*     */       }
/*     */       else {
/*  78 */         if (args[i].equals("-xml"))
/*     */         {
/*     */           continue;
/*     */         }
/*  82 */         File f = new File(args[i]).getCanonicalFile();
/*  83 */         builder.addSource(new FileReader(f));
/*     */       }
/*     */     }
/*  86 */     FileOutputStream os = new FileOutputStream(outputFile);
/*  87 */     PrintWriter pw = new PrintWriter(os);
/*  88 */     pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
/*  89 */     pw.println("<aop>");
/*  90 */     for (int i = 0; i < builder.getSources().length; i++)
/*     */     {
/*  92 */       JavaSource src = builder.getSources()[i];
/*  93 */       for (int j = 0; j < src.getClasses().length; j++)
/*     */       {
/*  95 */         JavaClass clazz = src.getClasses()[j];
/*  96 */         compileClass(clazz, pw);
/*     */       }
/*     */     }
/*  99 */     pw.println("</aop>");
/* 100 */     pw.close();
/* 101 */     os.close();
/*     */   }
/*     */ 
/*     */   private void compileClass(JavaClass clazz, PrintWriter pw) throws Exception
/*     */   {
/* 106 */     int indent = 1;
/* 107 */     for (int i = 0; i < clazz.getTags().length; i++)
/*     */     {
/* 109 */       AnnotationDocletTag tag = (AnnotationDocletTag)clazz.getTags()[i];
/* 110 */       if (tag.getAnnotation() == null)
/*     */         continue;
/* 112 */       indenter(pw, indent);
/* 113 */       pw.println("<metadata tag=\"" + tag.getName() + "\" class=\"" + clazz.getFullyQualifiedName() + "\">");
/* 114 */       indent++;
/* 115 */       indenter(pw, indent);
/* 116 */       pw.println("<class>");
/* 117 */       indent++;
/* 118 */       XmlAnnotationVisitor visitor = new XmlAnnotationVisitor(indent, pw);
/* 119 */       if (tag.getAnnotation().jjtGetNumChildren() > 0) tag.getAnnotation().jjtGetChild(0).jjtAccept(visitor, null);
/* 120 */       indent--;
/* 121 */       indenter(pw, indent);
/* 122 */       pw.println("</class>");
/* 123 */       indent--;
/* 124 */       indenter(pw, indent);
/* 125 */       pw.println("</metadata>");
/*     */     }
/* 127 */     for (int i = 0; i < clazz.getMethods().length; i++)
/*     */     {
/* 129 */       JavaMethod method = clazz.getMethods()[i];
/* 130 */       for (int j = 0; j < method.getTags().length; j++)
/*     */       {
/* 132 */         AnnotationDocletTag tag = (AnnotationDocletTag)method.getTags()[j];
/* 133 */         if (tag.getAnnotation() != null) {
/* 134 */           indenter(pw, indent);
/* 135 */           pw.println("<metadata tag=\"" + tag.getName() + "\" class=\"" + clazz.getFullyQualifiedName() + "\">");
/* 136 */           indent++;
/* 137 */           if (method.isConstructor())
/*     */           {
/* 139 */             indent = printConstructor(pw, method, indent, tag);
/*     */           }
/*     */           else
/*     */           {
/* 143 */             indent = printMethod(pw, method, indent, tag);
/*     */           }
/* 145 */           indent--;
/* 146 */           indenter(pw, indent);
/* 147 */           pw.println("</metadata>");
/*     */         }
/*     */       }
/*     */     }
/* 150 */     for (int i = 0; i < clazz.getFields().length; i++)
/*     */     {
/* 152 */       JavaField field = clazz.getFields()[i];
/* 153 */       for (int j = 0; j < field.getTags().length; j++)
/*     */       {
/* 155 */         AnnotationDocletTag tag = (AnnotationDocletTag)field.getTags()[j];
/* 156 */         if (tag.getAnnotation() != null) {
/* 157 */           indenter(pw, indent);
/* 158 */           pw.println("<metadata tag=\"" + tag.getName() + "\" class=\"" + clazz.getFullyQualifiedName() + "\">");
/* 159 */           indent++;
/* 160 */           printField(pw, field, indent, tag);
/* 161 */           indent--;
/* 162 */           indenter(pw, indent);
/* 163 */           pw.println("</metadata>");
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private int printMethod(PrintWriter pw, JavaMethod method, int indent, AnnotationDocletTag tag)
/*     */     throws Exception
/*     */   {
/* 172 */     indenter(pw, indent);
/* 173 */     pw.print("<method expr=\"");
/* 174 */     pw.print(method.getReturns().toString());
/* 175 */     pw.print(" " + method.getName() + "(");
/* 176 */     boolean first = true;
/* 177 */     for (int k = 0; k < method.getParameters().length; k++)
/*     */     {
/* 179 */       JavaParameter param = method.getParameters()[k];
/* 180 */       if (!first)
/* 181 */         pw.print(", ");
/*     */       else
/* 183 */         first = false;
/* 184 */       pw.print(param.getType().toString());
/*     */     }
/* 186 */     pw.println(")\">");
/* 187 */     indent++;
/* 188 */     XmlAnnotationVisitor visitor = new XmlAnnotationVisitor(indent, pw);
/* 189 */     if (tag.getAnnotation().jjtGetNumChildren() > 0) tag.getAnnotation().jjtGetChild(0).jjtAccept(visitor, null);
/* 190 */     indent--;
/* 191 */     indenter(pw, indent);
/* 192 */     pw.println("</method>");
/* 193 */     return indent;
/*     */   }
/*     */ 
/*     */   private int printField(PrintWriter pw, JavaField field, int indent, AnnotationDocletTag tag) throws Exception
/*     */   {
/* 198 */     indenter(pw, indent);
/* 199 */     pw.println("<field name=\"" + field.getName() + "\">");
/* 200 */     indent++;
/* 201 */     XmlAnnotationVisitor visitor = new XmlAnnotationVisitor(indent, pw);
/* 202 */     if (tag.getAnnotation().jjtGetNumChildren() > 0) tag.getAnnotation().jjtGetChild(0).jjtAccept(visitor, null);
/* 203 */     indent--;
/* 204 */     indenter(pw, indent);
/* 205 */     pw.println("</field>");
/* 206 */     return indent;
/*     */   }
/*     */ 
/*     */   private int printConstructor(PrintWriter pw, JavaMethod method, int indent, AnnotationDocletTag tag) throws Exception
/*     */   {
/* 211 */     indenter(pw, indent);
/* 212 */     pw.print("<constructor expr=\"");
/* 213 */     pw.print(method.getName() + "(");
/* 214 */     boolean first = true;
/* 215 */     for (int k = 0; k < method.getParameters().length; k++)
/*     */     {
/* 217 */       JavaParameter param = method.getParameters()[k];
/* 218 */       if (!first)
/* 219 */         pw.print(", ");
/*     */       else
/* 221 */         first = false;
/* 222 */       pw.print(param.getType().toString());
/*     */     }
/* 224 */     pw.println(")\">");
/* 225 */     indent++;
/* 226 */     XmlAnnotationVisitor visitor = new XmlAnnotationVisitor(indent, pw);
/* 227 */     if (tag.getAnnotation().jjtGetNumChildren() > 0) tag.getAnnotation().jjtGetChild(0).jjtAccept(visitor, null);
/* 228 */     indent--;
/* 229 */     indenter(pw, indent);
/* 230 */     pw.println("</constructor>");
/* 231 */     return indent;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.annotation.compiler.XmlAnnotationCompiler
 * JD-Core Version:    0.6.0
 */