/*     */ package org.jboss.aop.annotation.compiler;
/*     */ 
/*     */ import javassist.bytecode.annotation.AnnotationMemberValue;
/*     */ import javassist.bytecode.annotation.ArrayMemberValue;
/*     */ import javassist.bytecode.annotation.BooleanMemberValue;
/*     */ import javassist.bytecode.annotation.ByteMemberValue;
/*     */ import javassist.bytecode.annotation.CharMemberValue;
/*     */ import javassist.bytecode.annotation.ClassMemberValue;
/*     */ import javassist.bytecode.annotation.DoubleMemberValue;
/*     */ import javassist.bytecode.annotation.EnumMemberValue;
/*     */ import javassist.bytecode.annotation.FloatMemberValue;
/*     */ import javassist.bytecode.annotation.IntegerMemberValue;
/*     */ import javassist.bytecode.annotation.LongMemberValue;
/*     */ import javassist.bytecode.annotation.MemberValueVisitor;
/*     */ import javassist.bytecode.annotation.ShortMemberValue;
/*     */ import javassist.bytecode.annotation.StringMemberValue;
/*     */ 
/*     */ public class MemberValuePopulate
/*     */   implements MemberValueVisitor
/*     */ {
/*     */   private String value;
/*     */ 
/*     */   public MemberValuePopulate(String value)
/*     */   {
/*  51 */     this.value = value;
/*     */   }
/*     */ 
/*     */   public void visitAnnotationMemberValue(AnnotationMemberValue annotationMemberValue)
/*     */   {
/*  56 */     throw new RuntimeException("NOT IMPLEMENTED");
/*     */   }
/*     */ 
/*     */   public void visitArrayMemberValue(ArrayMemberValue arrayMemberValue)
/*     */   {
/*  61 */     throw new RuntimeException("NOT IMPLEMENTED");
/*     */   }
/*     */ 
/*     */   public void visitBooleanMemberValue(BooleanMemberValue booleanMemberValue)
/*     */   {
/*  66 */     Boolean bool = new Boolean(this.value);
/*  67 */     booleanMemberValue.setValue(bool.booleanValue());
/*     */   }
/*     */ 
/*     */   public void visitByteMemberValue(ByteMemberValue byteMemberValue)
/*     */   {
/*  72 */     byteMemberValue.setValue(Byte.parseByte(this.value));
/*     */   }
/*     */ 
/*     */   public void visitCharMemberValue(CharMemberValue charMemberValue)
/*     */   {
/*  77 */     charMemberValue.setValue(this.value.charAt(0));
/*     */   }
/*     */ 
/*     */   public void visitDoubleMemberValue(DoubleMemberValue doubleMemberValue)
/*     */   {
/*  82 */     doubleMemberValue.setValue(Double.parseDouble(this.value));
/*     */   }
/*     */ 
/*     */   public void visitEnumMemberValue(EnumMemberValue enumMemberValue)
/*     */   {
/*  87 */     int index = this.value.lastIndexOf('.');
/*  88 */     if (index == -1) throw new RuntimeException("Enum must be fully qualified: " + this.value);
/*  89 */     String className = this.value.substring(0, index);
/*  90 */     String en = this.value.substring(index + 1);
/*  91 */     enumMemberValue.setType(className);
/*  92 */     enumMemberValue.setValue(en);
/*     */   }
/*     */ 
/*     */   public void visitFloatMemberValue(FloatMemberValue floatMemberValue)
/*     */   {
/*  97 */     floatMemberValue.setValue(Float.parseFloat(this.value));
/*     */   }
/*     */ 
/*     */   public void visitIntegerMemberValue(IntegerMemberValue integerMemberValue)
/*     */   {
/* 102 */     integerMemberValue.setValue(Integer.parseInt(this.value));
/*     */   }
/*     */ 
/*     */   public void visitLongMemberValue(LongMemberValue longMemberValue)
/*     */   {
/* 107 */     longMemberValue.setValue(Long.parseLong(this.value));
/*     */   }
/*     */ 
/*     */   public void visitShortMemberValue(ShortMemberValue shortMemberValue)
/*     */   {
/* 112 */     shortMemberValue.setValue(Short.parseShort(this.value));
/*     */   }
/*     */ 
/*     */   public void visitStringMemberValue(StringMemberValue stringMemberValue)
/*     */   {
/* 117 */     stringMemberValue.setValue(this.value);
/*     */   }
/*     */ 
/*     */   public void visitClassMemberValue(ClassMemberValue classMemberValue)
/*     */   {
/* 122 */     if (this.value.endsWith(".class"))
/*     */     {
/* 124 */       this.value = this.value.substring(0, this.value.indexOf(".class"));
/*     */     }
/* 126 */     classMemberValue.setValue(this.value);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.annotation.compiler.MemberValuePopulate
 * JD-Core Version:    0.6.0
 */