/*     */ package org.jboss.aop.annotation.compiler;
/*     */ 
/*     */ import com.thoughtworks.qdox.JavaDocBuilder;
/*     */ import com.thoughtworks.qdox.model.JavaClass;
/*     */ import com.thoughtworks.qdox.model.JavaField;
/*     */ import com.thoughtworks.qdox.model.JavaMethod;
/*     */ import com.thoughtworks.qdox.model.JavaParameter;
/*     */ import com.thoughtworks.qdox.model.JavaSource;
/*     */ import com.thoughtworks.qdox.model.Type;
/*     */ import java.io.File;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.FileReader;
/*     */ import java.io.PrintStream;
/*     */ import java.net.URL;
/*     */ import java.net.URLDecoder;
/*     */ import java.util.ArrayList;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.LoaderClassPath;
/*     */ import javassist.bytecode.AnnotationsAttribute;
/*     */ import javassist.bytecode.ClassFile;
/*     */ import javassist.bytecode.FieldInfo;
/*     */ import javassist.bytecode.MethodInfo;
/*     */ import javassist.bytecode.annotation.Annotation;
/*     */ 
/*     */ public class ByteCodeAnnotationCompiler
/*     */ {
/*     */   ClassPool pool;
/*     */ 
/*     */   public void usage()
/*     */   {
/*  58 */     System.err.println("Usage: annotationc <files>+");
/*     */   }
/*     */ 
/*     */   public void compile(String[] args) throws Exception
/*     */   {
/*  63 */     if (args.length == 0)
/*     */     {
/*  65 */       usage();
/*  66 */       System.exit(1);
/*  67 */       return;
/*     */     }
/*  69 */     JavaDocBuilder builder = new JavaDocBuilder(new AnnotationDocletTagFactory());
/*  70 */     this.pool = new ClassPool();
/*  71 */     this.pool.appendSystemPath();
/*  72 */     this.pool.appendClassPath(new LoaderClassPath(SecurityActions.getContextClassLoader()));
/*  73 */     for (int i = 0; i < args.length; i++)
/*     */     {
/*  75 */       if (args[i].equals("-bytecode"))
/*     */       {
/*     */         continue;
/*     */       }
/*  79 */       if ((args[i].equals("-o")) || 
/*  80 */         (args[i].equals("-xml"))) continue;
/*  81 */       File f = new File(args[i]).getCanonicalFile();
/*     */       try
/*     */       {
/*  84 */         builder.addSource(new FileReader(f));
/*     */       }
/*     */       catch (RuntimeException e)
/*     */       {
/*  88 */         throw new RuntimeException("Error adding source for file " + f, e);
/*     */       }
/*     */     }
/*     */ 
/*  92 */     for (int i = 0; i < builder.getSources().length; i++)
/*     */     {
/*  94 */       JavaSource src = builder.getSources()[i];
/*  95 */       for (int j = 0; j < src.getClasses().length; j++)
/*     */       {
/*  97 */         JavaClass clazz = src.getClasses()[j];
/*     */         try
/*     */         {
/* 100 */           compileClass(clazz);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 104 */           throw new RuntimeException("failed to compile class: " + clazz.getFullyQualifiedName(), e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private CtMethod getJavassistMethod(JavaMethod method, CtClass clazz) throws Exception
/*     */   {
/* 112 */     CtMethod[] methods = clazz.getDeclaredMethods();
/* 113 */     ArrayList possible = new ArrayList();
/* 114 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 116 */       if (!methods[i].getName().equals(method.getName()))
/*     */         continue;
/* 118 */       if (methods[i].getParameterTypes().length != method.getParameters().length)
/*     */         continue;
/* 120 */       possible.add(methods[i]);
/*     */     }
/*     */ 
/* 124 */     if (possible.size() == 0) throw new RuntimeException("cannot resolve method" + method.toString());
/* 125 */     if (possible.size() == 1) return (CtMethod)possible.get(0);
/*     */ 
/* 127 */     for (int i = 0; i < possible.size(); i++)
/*     */     {
/* 129 */       CtMethod ctMethod = (CtMethod)possible.get(i);
/* 130 */       CtClass[] params = ctMethod.getParameterTypes();
/* 131 */       boolean bad = false;
/* 132 */       for (int k = 0; k < params.length; k++)
/*     */       {
/* 134 */         if (params[k].getName().equals(method.getParameters()[k].getType().toString()))
/*     */           continue;
/* 136 */         bad = true;
/* 137 */         break;
/*     */       }
/*     */ 
/* 140 */       if (!bad) return ctMethod;
/*     */     }
/* 142 */     throw new RuntimeException("cannot resolve method" + method.toString());
/*     */   }
/*     */ 
/*     */   private CtConstructor getJavassistConstructor(JavaMethod method, CtClass clazz, boolean isInnerClass) throws Exception
/*     */   {
/* 147 */     CtConstructor[] cons = clazz.getDeclaredConstructors();
/* 148 */     ArrayList possible = new ArrayList();
/* 149 */     for (int i = 0; i < cons.length; i++)
/*     */     {
/* 152 */       if (isInnerClass)
/*     */       {
/* 154 */         if (cons[i].getParameterTypes().length != method.getParameters().length + 1)
/*     */           continue;
/* 156 */         possible.add(cons[i]);
/*     */       }
/*     */       else
/*     */       {
/* 161 */         if (cons[i].getParameterTypes().length != method.getParameters().length)
/*     */           continue;
/* 163 */         possible.add(cons[i]);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 168 */     if (possible.size() == 0) throw new RuntimeException("cannot resolve constructor" + method.toString());
/* 169 */     if (possible.size() == 1) return (CtConstructor)possible.get(0);
/*     */ 
/* 171 */     for (int i = 0; i < possible.size(); i++)
/*     */     {
/* 173 */       CtConstructor ctCon = (CtConstructor)possible.get(i);
/* 174 */       CtClass[] params = ctCon.getParameterTypes();
/* 175 */       boolean bad = false;
/* 176 */       for (int k = 0; k < params.length; k++)
/*     */       {
/* 178 */         if (params[k].getName().equals(method.getParameters()[k].getType().toString()))
/*     */           continue;
/* 180 */         bad = true;
/* 181 */         break;
/*     */       }
/*     */ 
/* 184 */       if (!bad) return ctCon;
/*     */     }
/* 186 */     throw new RuntimeException("cannot resolve constructor" + method.toString());
/*     */   }
/*     */ 
/*     */   private void compileClass(JavaClass clazz) throws Exception
/*     */   {
/* 191 */     CtClass ctClass = this.pool.get(clazz.getFullyQualifiedName());
/* 192 */     boolean modified = false;
/* 193 */     for (int i = 0; i < clazz.getTags().length; i++)
/*     */     {
/* 195 */       AnnotationDocletTag tag = (AnnotationDocletTag)clazz.getTags()[i];
/* 196 */       if (tag.getAnnotation() != null) {
/* 197 */         modified = true;
/* 198 */         Annotation info = AnnotationInfoCreator.createAnnotationInfo(this.pool, ctClass.getClassFile().getConstPool(), tag.getAnnotation());
/* 199 */         AnnotationsAttribute visible = getVisibleAnnotationsAttribute(ctClass);
/* 200 */         visible.addAnnotation(info);
/* 201 */         visible.getAnnotations();
/*     */       }
/*     */     }
/* 203 */     for (int i = 0; i < clazz.getMethods().length; i++)
/*     */     {
/* 205 */       JavaMethod method = clazz.getMethods()[i];
/* 206 */       for (int j = 0; j < method.getTags().length; j++)
/*     */       {
/* 208 */         AnnotationDocletTag tag = (AnnotationDocletTag)method.getTags()[j];
/* 209 */         if (tag.getAnnotation() != null) {
/* 210 */           modified = true;
/* 211 */           if (method.isConstructor())
/*     */           {
/* 215 */             if ((clazz.isInner()) && (!clazz.isStatic()))
/*     */             {
/* 217 */               compileConstructor(method, tag, ctClass, true);
/*     */             }
/*     */             else
/*     */             {
/* 221 */               compileConstructor(method, tag, ctClass, false);
/*     */             }
/*     */           }
/*     */           else
/*     */           {
/* 226 */             compileMethod(method, tag, ctClass);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 230 */     for (int i = 0; i < clazz.getFields().length; i++)
/*     */     {
/* 232 */       JavaField field = clazz.getFields()[i];
/* 233 */       for (int j = 0; j < field.getTags().length; j++)
/*     */       {
/* 235 */         AnnotationDocletTag tag = (AnnotationDocletTag)field.getTags()[j];
/* 236 */         if (tag.getAnnotation() != null) {
/* 237 */           modified = true;
/* 238 */           compileField(field, tag, ctClass);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 243 */     for (int i = 0; i < clazz.getNestedClasses().length; i++)
/*     */     {
/* 245 */       JavaClass innerClass = clazz.getNestedClasses()[i];
/* 246 */       compileClass(innerClass);
/*     */     }
/*     */ 
/* 249 */     if (modified)
/*     */     {
/* 251 */       String classFile = ctClass.getName().replace('.', '/') + ".class";
/* 252 */       URL url = SecurityActions.getContextClassLoader().getResource(classFile);
/* 253 */       if (!url.getProtocol().equals("file"))
/*     */       {
/* 255 */         throw new RuntimeException(".class file must not be in a jar: " + url.toString());
/*     */       }
/* 257 */       byte[] byteCode = ctClass.toBytecode();
/* 258 */       String path = URLDecoder.decode(url.getFile(), "UTF-8");
/* 259 */       File fp = new File(path);
/* 260 */       FileOutputStream os = new FileOutputStream(fp);
/* 261 */       os.write(byteCode);
/* 262 */       os.close();
/* 263 */       System.out.println("[compiled] " + fp);
/*     */     }
/*     */   }
/*     */ 
/*     */   private AnnotationsAttribute getVisibleAnnotationsAttribute(CtClass ctClass)
/*     */   {
/* 271 */     AnnotationsAttribute visible = (AnnotationsAttribute)ctClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
/* 272 */     if (visible == null)
/*     */     {
/* 274 */       ClassFile cf = ctClass.getClassFile();
/* 275 */       visible = new AnnotationsAttribute(cf.getConstPool(), "RuntimeVisibleAnnotations");
/* 276 */       cf.addAttribute(visible);
/*     */     }
/* 278 */     return visible;
/*     */   }
/*     */ 
/*     */   private void compileMethod(JavaMethod method, AnnotationDocletTag tag, CtClass clazz) throws Exception
/*     */   {
/* 283 */     CtMethod ctMethod = getJavassistMethod(method, clazz);
/* 284 */     MethodInfo minfo = ctMethod.getMethodInfo();
/* 285 */     Annotation info = AnnotationInfoCreator.createAnnotationInfo(this.pool, minfo.getConstPool(), tag.getAnnotation());
/* 286 */     AnnotationsAttribute visible = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
/* 287 */     if (visible == null)
/*     */     {
/* 289 */       visible = new AnnotationsAttribute(minfo.getConstPool(), "RuntimeVisibleAnnotations");
/* 290 */       minfo.addAttribute(visible);
/*     */     }
/* 292 */     visible.addAnnotation(info);
/*     */   }
/*     */ 
/*     */   private void compileField(JavaField field, AnnotationDocletTag tag, CtClass clazz)
/*     */     throws Exception
/*     */   {
/* 298 */     CtField ctField = clazz.getDeclaredField(field.getName());
/* 299 */     FieldInfo minfo = ctField.getFieldInfo();
/* 300 */     Annotation info = AnnotationInfoCreator.createAnnotationInfo(this.pool, minfo.getConstPool(), tag.getAnnotation());
/* 301 */     AnnotationsAttribute visible = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
/* 302 */     if (visible == null)
/*     */     {
/* 304 */       visible = new AnnotationsAttribute(minfo.getConstPool(), "RuntimeVisibleAnnotations");
/* 305 */       minfo.addAttribute(visible);
/*     */     }
/* 307 */     visible.addAnnotation(info);
/*     */   }
/*     */ 
/*     */   private void compileConstructor(JavaMethod method, AnnotationDocletTag tag, CtClass clazz, boolean isInnerClass) throws Exception
/*     */   {
/* 312 */     CtConstructor ctMethod = getJavassistConstructor(method, clazz, isInnerClass);
/* 313 */     MethodInfo minfo = ctMethod.getMethodInfo();
/* 314 */     Annotation info = AnnotationInfoCreator.createAnnotationInfo(this.pool, minfo.getConstPool(), tag.getAnnotation());
/* 315 */     AnnotationsAttribute visible = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
/* 316 */     if (visible == null)
/*     */     {
/* 318 */       visible = new AnnotationsAttribute(minfo.getConstPool(), "RuntimeVisibleAnnotations");
/* 319 */       minfo.addAttribute(visible);
/*     */     }
/* 321 */     visible.addAnnotation(info);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.annotation.compiler.ByteCodeAnnotationCompiler
 * JD-Core Version:    0.6.0
 */