/*     */ package org.jboss.aop.annotation.compiler;
/*     */ 
/*     */ import com.thoughtworks.qdox.model.AbstractJavaEntity;
/*     */ import com.thoughtworks.qdox.model.DocletTag;
/*     */ import java.io.StringReader;
/*     */ import java.util.Map;
/*     */ import org.jboss.annotation.factory.ast.ASTAnnotation;
/*     */ import org.jboss.annotation.factory.ast.ASTStart;
/*     */ import org.jboss.annotation.factory.ast.AnnotationParser;
/*     */ import org.jboss.annotation.factory.ast.ParseException;
/*     */ 
/*     */ public class AnnotationDocletTag
/*     */   implements DocletTag
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String name;
/*     */   private final String value;
/*     */   private final int lineNumber;
/*     */   private ASTAnnotation ast;
/*     */   private AbstractJavaEntity owner;
/*     */ 
/*     */   public AnnotationDocletTag(String name, String value, int lineNumber)
/*     */   {
/*  55 */     this.name = name;
/*  56 */     this.value = value;
/*  57 */     this.lineNumber = lineNumber;
/*  58 */     if (name.startsWith("@"))
/*     */     {
/*  60 */       if (name.indexOf('(') != -1)
/*     */       {
/*  62 */         throw new RuntimeException("illegal annotation syntax for doclet at line number " + lineNumber + ".  You should have a space after the tag name otherwise the compiler messes up. " + name + " ***value=" + value);
/*     */       }
/*     */ 
/*  71 */       AnnotationParser parser = new AnnotationParser(new StringReader(name + value));
/*     */       try
/*     */       {
/*  74 */         ASTStart start = parser.Start();
/*  75 */         this.ast = ((ASTAnnotation)start.jjtGetChild(0));
/*     */       }
/*     */       catch (ParseException e)
/*     */       {
/*  79 */         throw new RuntimeException(e);
/*     */       }
/*  81 */       this.name = name.substring(1);
/*     */     }
/*     */   }
/*     */ 
/*     */   public AnnotationDocletTag(String name, String value)
/*     */   {
/*  87 */     this(name, value, 0);
/*     */   }
/*     */ 
/*     */   public ASTAnnotation getAnnotation()
/*     */   {
/*  92 */     return this.ast;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  97 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getValue()
/*     */   {
/* 102 */     return this.value;
/*     */   }
/*     */ 
/*     */   public String[] getParameters()
/*     */   {
/* 107 */     return null;
/*     */   }
/*     */ 
/*     */   public Map getNamedParameterMap()
/*     */   {
/* 112 */     return null;
/*     */   }
/*     */ 
/*     */   public String getNamedParameter(String key)
/*     */   {
/* 117 */     return null;
/*     */   }
/*     */ 
/*     */   public int getLineNumber()
/*     */   {
/* 122 */     return this.lineNumber;
/*     */   }
/*     */ 
/*     */   public final AbstractJavaEntity getContext()
/*     */   {
/* 127 */     return this.owner;
/*     */   }
/*     */ 
/*     */   public void setContext(AbstractJavaEntity owner)
/*     */   {
/* 132 */     this.owner = owner;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.annotation.compiler.AnnotationDocletTag
 * JD-Core Version:    0.6.0
 */