/*     */ package org.jboss.aop.annotation;
/*     */ 
/*     */ import java.lang.reflect.Member;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import java.util.concurrent.locks.ReentrantReadWriteLock;
/*     */ import java.util.concurrent.locks.ReentrantReadWriteLock.WriteLock;
/*     */ import javassist.CtMember;
/*     */ import org.jboss.annotation.factory.AnnotationCreator;
/*     */ import org.jboss.aop.util.UnmodifiableEmptyCollections;
/*     */ 
/*     */ public class AnnotationRepository
/*     */ {
/*     */   private static final String CLASS_ANNOTATION = "CLASS";
/*  51 */   protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
/*     */ 
/*  53 */   volatile Map annotations = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
/*  54 */   volatile Map classAnnotations = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
/*  55 */   volatile Map disabledAnnotations = UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP;
/*     */ 
/*     */   public Map getAnnotations()
/*     */   {
/*  59 */     return this.annotations;
/*     */   }
/*     */ 
/*     */   public Map getClassAnnotations()
/*     */   {
/*  64 */     return this.classAnnotations;
/*     */   }
/*     */ 
/*     */   public void addClassAnnotation(String annotation, String value)
/*     */   {
/*  69 */     initClassAnnotationsMap();
/*  70 */     this.classAnnotations.put(annotation, value);
/*     */   }
/*     */ 
/*     */   public void addClassAnnotation(Class annotation, Object value)
/*     */   {
/*  75 */     initClassAnnotationsMap();
/*  76 */     this.classAnnotations.put(annotation.getName(), value);
/*     */   }
/*     */ 
/*     */   public Object resolveClassAnnotation(Class annotation)
/*     */   {
/*  81 */     Object value = this.classAnnotations.get(annotation.getName());
/*  82 */     boolean reinsert = value instanceof String;
/*  83 */     value = extractAnnotation(value, annotation);
/*  84 */     if (reinsert)
/*     */     {
/*  86 */       this.classAnnotations.put(annotation.getName(), value);
/*     */     }
/*  88 */     return value;
/*     */   }
/*     */ 
/*     */   public Object resolveAnnotation(Member m, Class annotation)
/*     */   {
/*  93 */     Object value = resolveAnnotation(m, annotation.getName());
/*  94 */     boolean reinsert = value instanceof String;
/*  95 */     value = extractAnnotation(value, annotation);
/*  96 */     if (reinsert)
/*     */     {
/*  98 */       addAnnotation(m, annotation, value);
/*     */     }
/* 100 */     return value;
/*     */   }
/*     */ 
/*     */   protected Object extractAnnotation(Object value, Class annotation)
/*     */   {
/* 105 */     if (value == null) return null;
/* 106 */     if ((value instanceof String))
/*     */     {
/* 108 */       String expr = (String)value;
/*     */       try
/*     */       {
/* 111 */         return AnnotationCreator.createAnnotation(expr, annotation);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 115 */         throw new RuntimeException("Bad annotation expression " + expr, e);
/*     */       }
/*     */     }
/* 118 */     return value;
/*     */   }
/*     */ 
/*     */   protected Object resolveAnnotation(Member m, String annotation)
/*     */   {
/* 123 */     Map map = (Map)this.annotations.get(m);
/* 124 */     if (map != null)
/*     */     {
/* 126 */       return map.get(annotation);
/*     */     }
/* 128 */     return null;
/*     */   }
/*     */ 
/*     */   public void disableAnnotation(Member m, String annotation)
/*     */   {
/* 133 */     List annotationList = (List)this.disabledAnnotations.get(m);
/* 134 */     if (annotationList == null)
/*     */     {
/* 136 */       annotationList = new ArrayList();
/* 137 */       initDisabledAnnotationsMap();
/* 138 */       this.disabledAnnotations.put(m, annotationList);
/*     */     }
/* 140 */     annotationList.add(annotation);
/*     */   }
/*     */ 
/*     */   public void disableAnnotation(String annotation)
/*     */   {
/* 145 */     List annotationList = (List)this.disabledAnnotations.get("CLASS");
/* 146 */     if (annotationList == null)
/*     */     {
/* 148 */       annotationList = new ArrayList();
/* 149 */       initDisabledAnnotationsMap();
/* 150 */       this.disabledAnnotations.put("CLASS", annotationList);
/*     */     }
/* 152 */     annotationList.add(annotation);
/*     */   }
/*     */ 
/*     */   public void enableAnnotation(String annotation)
/*     */   {
/* 157 */     List annotationList = (List)this.disabledAnnotations.get("CLASS");
/* 158 */     if (annotationList != null)
/*     */     {
/* 160 */       annotationList.remove(annotation);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isDisabled(Member m, Class annotation)
/*     */   {
/* 167 */     return isDisabled(m, annotation.getName());
/*     */   }
/*     */ 
/*     */   public boolean isDisabled(Member m, String annotation)
/*     */   {
/* 172 */     List overrideList = (List)this.disabledAnnotations.get(m);
/* 173 */     if (overrideList != null)
/*     */     {
/* 175 */       Iterator overrides = overrideList.iterator();
/* 176 */       while (overrides.hasNext())
/*     */       {
/* 178 */         String override = (String)overrides.next();
/* 179 */         if (override.equals(annotation))
/* 180 */           return true;
/*     */       }
/*     */     }
/* 183 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isDisabled(Class annotation)
/*     */   {
/* 188 */     return isDisabled(annotation.getName());
/*     */   }
/*     */ 
/*     */   public boolean isDisabled(String annotation)
/*     */   {
/* 193 */     List overrideList = (List)this.disabledAnnotations.get("CLASS");
/* 194 */     if (overrideList != null)
/*     */     {
/* 196 */       Iterator overrides = overrideList.iterator();
/* 197 */       while (overrides.hasNext())
/*     */       {
/* 199 */         String override = (String)overrides.next();
/* 200 */         if (override.equals(annotation))
/* 201 */           return true;
/*     */       }
/*     */     }
/* 204 */     return false;
/*     */   }
/*     */ 
/*     */   public void addAnnotation(Member m, Class annotation, Object value)
/*     */   {
/* 209 */     Map map = (Map)this.annotations.get(m);
/* 210 */     if (map == null)
/*     */     {
/* 212 */       map = new HashMap();
/* 213 */       initAnnotationsMap();
/* 214 */       this.annotations.put(m, map);
/*     */     }
/* 216 */     map.put(annotation.getName(), value);
/*     */   }
/*     */ 
/*     */   public void addAnnotation(Member m, String annotation, Object value)
/*     */   {
/* 221 */     Map map = (Map)this.annotations.get(m);
/* 222 */     if (map == null)
/*     */     {
/* 224 */       map = new HashMap();
/* 225 */       initAnnotationsMap();
/* 226 */       this.annotations.put(m, map);
/*     */     }
/* 228 */     map.put(annotation, value);
/*     */   }
/*     */ 
/*     */   public boolean hasClassAnnotation(String annotation)
/*     */   {
/* 233 */     return this.classAnnotations.containsKey(annotation);
/*     */   }
/*     */ 
/*     */   public boolean hasClassAnnotation(Class annotation)
/*     */   {
/* 238 */     return this.classAnnotations.containsKey(annotation.getName());
/*     */   }
/*     */ 
/*     */   public boolean hasAnnotation(Member m, Class annotation)
/*     */   {
/* 243 */     return resolveAnnotation(m, annotation.getName()) != null;
/*     */   }
/*     */ 
/*     */   public boolean hasAnnotation(Member m, String annotation)
/*     */   {
/* 248 */     return resolveAnnotation(m, annotation) != null;
/*     */   }
/*     */ 
/*     */   public boolean hasAnnotation(CtMember m, String annotation)
/*     */   {
/* 253 */     Set set = (Set)this.annotations.get(m);
/* 254 */     if (set != null) return set.contains(annotation);
/* 255 */     return false;
/*     */   }
/*     */ 
/*     */   public void addAnnotation(CtMember m, String annotation)
/*     */   {
/* 260 */     Set set = (Set)this.annotations.get(m);
/* 261 */     if (set == null)
/*     */     {
/* 263 */       set = new HashSet();
/* 264 */       initAnnotationsMap();
/* 265 */       this.annotations.put(m, set);
/*     */     }
/* 267 */     set.add(annotation);
/*     */   }
/*     */ 
/*     */   protected void lockWrite()
/*     */   {
/* 275 */     this.lock.writeLock().lock();
/*     */   }
/*     */ 
/*     */   protected void unlockWrite()
/*     */   {
/* 283 */     this.lock.writeLock().unlock();
/*     */   }
/*     */ 
/*     */   protected void initAnnotationsMap()
/*     */   {
/* 288 */     if (this.annotations == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*     */     {
/* 290 */       lockWrite();
/*     */       try
/*     */       {
/* 293 */         if (this.annotations == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*     */         {
/* 295 */           this.annotations = new ConcurrentHashMap();
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/* 300 */         unlockWrite();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initClassAnnotationsMap()
/*     */   {
/* 307 */     if (this.classAnnotations == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*     */     {
/* 309 */       lockWrite();
/*     */       try
/*     */       {
/* 312 */         if (this.classAnnotations == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*     */         {
/* 314 */           this.classAnnotations = new ConcurrentHashMap();
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/* 319 */         unlockWrite();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initDisabledAnnotationsMap()
/*     */   {
/* 326 */     if (this.disabledAnnotations == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*     */     {
/* 328 */       lockWrite();
/*     */       try
/*     */       {
/* 331 */         if (this.disabledAnnotations == UnmodifiableEmptyCollections.EMPTY_CONCURRENT_HASHMAP)
/*     */         {
/* 333 */           this.disabledAnnotations = new ConcurrentHashMap();
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/* 338 */         unlockWrite();
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.annotation.AnnotationRepository
 * JD-Core Version:    0.6.0
 */