/*     */ package org.jboss.aop.annotation;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ 
/*     */ public class AnnotationElement extends PortableAnnotationElement
/*     */ {
/*     */   public static Object getVisibleAnnotation(Method method, Class annotation)
/*     */   {
/*  52 */     if (System.getSecurityManager() == null)
/*     */     {
/*  54 */       return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotation(method, annotation);
/*     */     }
/*     */ 
/*  58 */     return AnnotationElementAction.PRIVILEGED.getVisibleAnnotation(method, annotation);
/*     */   }
/*     */ 
/*     */   public static Object getVisibleAnnotation(Constructor con, Class annotation)
/*     */   {
/*  72 */     if (System.getSecurityManager() == null)
/*     */     {
/*  74 */       return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotation(con, annotation);
/*     */     }
/*     */ 
/*  78 */     return AnnotationElementAction.PRIVILEGED.getVisibleAnnotation(con, annotation);
/*     */   }
/*     */ 
/*     */   public static Object getVisibleAnnotation(Field field, Class annotation)
/*     */   {
/*  92 */     if (System.getSecurityManager() == null)
/*     */     {
/*  94 */       return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotation(field, annotation);
/*     */     }
/*     */ 
/*  98 */     return AnnotationElementAction.PRIVILEGED.getVisibleAnnotation(field, annotation);
/*     */   }
/*     */ 
/*     */   public static Object getVisibleAnnotation(Class clazz, Class annotation)
/*     */   {
/* 112 */     if (System.getSecurityManager() == null)
/*     */     {
/* 114 */       return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotation(clazz, annotation);
/*     */     }
/*     */ 
/* 118 */     return AnnotationElementAction.PRIVILEGED.getVisibleAnnotation(clazz, annotation);
/*     */   }
/*     */ 
/*     */   public static boolean isVisibleAnnotationPresent(Class clazz, Class annotation)
/*     */   {
/* 124 */     if (System.getSecurityManager() == null)
/*     */     {
/* 126 */       return AnnotationElementAction.NON_PRIVILEGED.isVisibleAnnotationPresent(clazz, annotation);
/*     */     }
/*     */ 
/* 130 */     return AnnotationElementAction.PRIVILEGED.isVisibleAnnotationPresent(clazz, annotation);
/*     */   }
/*     */ 
/*     */   public static boolean isVisibleAnnotationPresent(Method m, Class annotation)
/*     */   {
/* 136 */     if (System.getSecurityManager() == null)
/*     */     {
/* 138 */       return AnnotationElementAction.NON_PRIVILEGED.isVisibleAnnotationPresent(m, annotation);
/*     */     }
/*     */ 
/* 142 */     return AnnotationElementAction.PRIVILEGED.isVisibleAnnotationPresent(m, annotation);
/*     */   }
/*     */ 
/*     */   public static boolean isVisibleAnnotationPresent(Field f, Class annotation)
/*     */   {
/* 148 */     if (System.getSecurityManager() == null)
/*     */     {
/* 150 */       return AnnotationElementAction.NON_PRIVILEGED.isVisibleAnnotationPresent(f, annotation);
/*     */     }
/*     */ 
/* 154 */     return AnnotationElementAction.PRIVILEGED.isVisibleAnnotationPresent(f, annotation);
/*     */   }
/*     */ 
/*     */   public static boolean isVisibleAnnotationPresent(Constructor con, Class annotation)
/*     */   {
/* 160 */     if (System.getSecurityManager() == null)
/*     */     {
/* 162 */       return AnnotationElementAction.NON_PRIVILEGED.isVisibleAnnotationPresent(con, annotation);
/*     */     }
/*     */ 
/* 166 */     return AnnotationElementAction.PRIVILEGED.isVisibleAnnotationPresent(con, annotation);
/*     */   }
/*     */ 
/*     */   public static Object[] getVisibleAnnotations(Class clazz)
/*     */     throws Exception
/*     */   {
/* 172 */     if (System.getSecurityManager() == null)
/*     */     {
/* 174 */       return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotations(clazz);
/*     */     }
/*     */ 
/* 178 */     return AnnotationElementAction.PRIVILEGED.getVisibleAnnotations(clazz);
/*     */   }
/*     */ 
/*     */   public static Object[] getVisibleAnnotations(Method m)
/*     */     throws Exception
/*     */   {
/* 184 */     if (System.getSecurityManager() == null)
/*     */     {
/* 186 */       return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotations(m);
/*     */     }
/*     */ 
/* 190 */     return AnnotationElementAction.PRIVILEGED.getVisibleAnnotations(m);
/*     */   }
/*     */ 
/*     */   public static Object[] getVisibleAnnotations(Field f)
/*     */     throws Exception
/*     */   {
/* 196 */     if (System.getSecurityManager() == null)
/*     */     {
/* 198 */       return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotations(f);
/*     */     }
/*     */ 
/* 202 */     return AnnotationElementAction.PRIVILEGED.getVisibleAnnotations(f);
/*     */   }
/*     */ 
/*     */   public static Object[] getVisibleAnnotations(Constructor c)
/*     */     throws Exception
/*     */   {
/* 208 */     if (System.getSecurityManager() == null)
/*     */     {
/* 210 */       return AnnotationElementAction.NON_PRIVILEGED.getVisibleAnnotations(c);
/*     */     }
/*     */ 
/* 214 */     return AnnotationElementAction.PRIVILEGED.getVisibleAnnotations(c);
/*     */   }
/*     */ 
/*     */   private static abstract interface AnnotationElementAction
/*     */   {
/* 245 */     public static final AnnotationElementAction NON_PRIVILEGED = new AnnotationElementAction()
/*     */     {
/*     */       public Object getVisibleAnnotation(Method method, Class annotation)
/*     */       {
/* 249 */         return method.getAnnotation(annotation);
/*     */       }
/*     */ 
/*     */       public Object getVisibleAnnotation(Constructor con, Class annotation)
/*     */       {
/* 254 */         return con.getAnnotation(annotation);
/*     */       }
/*     */ 
/*     */       public Object getVisibleAnnotation(Field field, Class annotation)
/*     */       {
/* 259 */         return field.getAnnotation(annotation);
/*     */       }
/*     */ 
/*     */       public Object getVisibleAnnotation(Class clazz, Class annotation)
/*     */       {
/* 264 */         return clazz.getAnnotation(annotation);
/*     */       }
/*     */ 
/*     */       public boolean isVisibleAnnotationPresent(Class clazz, Class annotation)
/*     */       {
/* 269 */         return clazz.isAnnotationPresent(annotation);
/*     */       }
/*     */ 
/*     */       public boolean isVisibleAnnotationPresent(Method m, Class annotation)
/*     */       {
/* 274 */         return m.isAnnotationPresent(annotation);
/*     */       }
/*     */ 
/*     */       public boolean isVisibleAnnotationPresent(Field f, Class annotation)
/*     */       {
/* 279 */         return f.isAnnotationPresent(annotation);
/*     */       }
/*     */ 
/*     */       public boolean isVisibleAnnotationPresent(Constructor con, Class annotation)
/*     */       {
/* 284 */         return con.isAnnotationPresent(annotation);
/*     */       }
/*     */ 
/*     */       public Object[] getVisibleAnnotations(Class clazz) throws Exception
/*     */       {
/* 289 */         return clazz.getAnnotations();
/*     */       }
/*     */ 
/*     */       public Object[] getVisibleAnnotations(Method m) throws Exception
/*     */       {
/* 294 */         return m.getAnnotations();
/*     */       }
/*     */ 
/*     */       public Object[] getVisibleAnnotations(Field f) throws Exception
/*     */       {
/* 299 */         return f.getAnnotations();
/*     */       }
/*     */ 
/*     */       public Object[] getVisibleAnnotations(Constructor c) throws Exception
/*     */       {
/* 304 */         return c.getAnnotations();
/*     */       }
/* 245 */     };
/*     */ 
/* 309 */     public static final AnnotationElementAction PRIVILEGED = new AnnotationElementAction()
/*     */     {
/*     */       public Object getVisibleAnnotation(Method method, Class annotation)
/*     */       {
/* 313 */         return AccessController.doPrivileged(new PrivilegedAction(method, annotation)
/*     */         {
/*     */           public Object run() {
/* 316 */             return this.val$method.getAnnotation(this.val$annotation);
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public Object getVisibleAnnotation(Constructor con, Class annotation) {
/* 323 */         return AccessController.doPrivileged(new PrivilegedAction(con, annotation)
/*     */         {
/*     */           public Object run() {
/* 326 */             return this.val$con.getAnnotation(this.val$annotation);
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public Object getVisibleAnnotation(Field field, Class annotation) {
/* 333 */         return AccessController.doPrivileged(new PrivilegedAction(field, annotation)
/*     */         {
/*     */           public Object run() {
/* 336 */             return this.val$field.getAnnotation(this.val$annotation);
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public Object getVisibleAnnotation(Class clazz, Class annotation) {
/* 343 */         return AccessController.doPrivileged(new PrivilegedAction(clazz, annotation)
/*     */         {
/*     */           public Object run() {
/* 346 */             return this.val$clazz.getAnnotation(this.val$annotation);
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public boolean isVisibleAnnotationPresent(Class clazz, Class annotation) {
/* 353 */         Boolean present = (Boolean)AccessController.doPrivileged(new PrivilegedAction(clazz, annotation)
/*     */         {
/*     */           public Object run() {
/* 356 */             return this.val$clazz.isAnnotationPresent(this.val$annotation) ? Boolean.TRUE : Boolean.FALSE;
/*     */           }
/*     */         });
/* 360 */         return present.booleanValue();
/*     */       }
/*     */ 
/*     */       public boolean isVisibleAnnotationPresent(Method m, Class annotation)
/*     */       {
/* 365 */         Boolean present = (Boolean)AccessController.doPrivileged(new PrivilegedAction(m, annotation)
/*     */         {
/*     */           public Object run() {
/* 368 */             return this.val$m.isAnnotationPresent(this.val$annotation) ? Boolean.TRUE : Boolean.FALSE;
/*     */           }
/*     */         });
/* 372 */         return present.booleanValue();
/*     */       }
/*     */ 
/*     */       public boolean isVisibleAnnotationPresent(Field f, Class annotation)
/*     */       {
/* 377 */         Boolean present = (Boolean)AccessController.doPrivileged(new PrivilegedAction(f, annotation)
/*     */         {
/*     */           public Object run() {
/* 380 */             return this.val$f.isAnnotationPresent(this.val$annotation) ? Boolean.TRUE : Boolean.FALSE;
/*     */           }
/*     */         });
/* 383 */         return present.booleanValue();
/*     */       }
/*     */ 
/*     */       public boolean isVisibleAnnotationPresent(Constructor con, Class annotation)
/*     */       {
/* 388 */         Boolean present = (Boolean)AccessController.doPrivileged(new PrivilegedAction(con, annotation)
/*     */         {
/*     */           public Object run() {
/* 391 */             return this.val$con.isAnnotationPresent(this.val$annotation) ? Boolean.TRUE : Boolean.FALSE;
/*     */           }
/*     */         });
/* 394 */         return present.booleanValue();
/*     */       }
/*     */ 
/*     */       public Object[] getVisibleAnnotations(Class clazz) throws Exception
/*     */       {
/*     */         try
/*     */         {
/* 401 */           return (Object[])(Object[])AccessController.doPrivileged(new PrivilegedExceptionAction(clazz)
/*     */           {
/*     */             public Object run() throws Exception
/*     */             {
/* 405 */               return this.val$clazz.getAnnotations();
/*     */             } } );
/*     */         }
/*     */         catch (PrivilegedActionException e) {
/*     */         }
/* 411 */         throw e.getException();
/*     */       }
/*     */ 
/*     */       public Object[] getVisibleAnnotations(Method m)
/*     */         throws Exception
/*     */       {
/*     */         try
/*     */         {
/* 419 */           return (Object[])(Object[])AccessController.doPrivileged(new PrivilegedExceptionAction(m)
/*     */           {
/*     */             public Object run() throws Exception {
/* 422 */               return this.val$m.getAnnotations();
/*     */             } } );
/*     */         }
/*     */         catch (PrivilegedActionException e) {
/*     */         }
/* 428 */         throw e.getException();
/*     */       }
/*     */ 
/*     */       public Object[] getVisibleAnnotations(Field f)
/*     */         throws Exception
/*     */       {
/*     */         try
/*     */         {
/* 436 */           return (Object[])(Object[])AccessController.doPrivileged(new PrivilegedExceptionAction(f)
/*     */           {
/*     */             public Object run() throws Exception {
/* 439 */               return this.val$f.getAnnotations();
/*     */             } } );
/*     */         }
/*     */         catch (PrivilegedActionException e) {
/*     */         }
/* 445 */         throw e.getException();
/*     */       }
/*     */ 
/*     */       public Object[] getVisibleAnnotations(Constructor c)
/*     */         throws Exception
/*     */       {
/*     */         try
/*     */         {
/* 453 */           return (Object[])(Object[])AccessController.doPrivileged(new PrivilegedExceptionAction(c)
/*     */           {
/*     */             public Object run() throws Exception {
/* 456 */               return this.val$c.getAnnotations();
/*     */             } } );
/*     */         }
/*     */         catch (PrivilegedActionException e) {
/*     */         }
/* 462 */         throw e.getException();
/*     */       }
/* 309 */     };
/*     */ 
/*     */     public abstract Object getVisibleAnnotation(Method paramMethod, Class paramClass);
/*     */ 
/*     */     public abstract Object getVisibleAnnotation(Constructor paramConstructor, Class paramClass);
/*     */ 
/*     */     public abstract Object getVisibleAnnotation(Field paramField, Class paramClass);
/*     */ 
/*     */     public abstract Object getVisibleAnnotation(Class paramClass1, Class paramClass2);
/*     */ 
/*     */     public abstract boolean isVisibleAnnotationPresent(Class paramClass1, Class paramClass2);
/*     */ 
/*     */     public abstract boolean isVisibleAnnotationPresent(Method paramMethod, Class paramClass);
/*     */ 
/*     */     public abstract boolean isVisibleAnnotationPresent(Field paramField, Class paramClass);
/*     */ 
/*     */     public abstract boolean isVisibleAnnotationPresent(Constructor paramConstructor, Class paramClass);
/*     */ 
/*     */     public abstract Object[] getVisibleAnnotations(Class paramClass)
/*     */       throws Exception;
/*     */ 
/*     */     public abstract Object[] getVisibleAnnotations(Method paramMethod)
/*     */       throws Exception;
/*     */ 
/*     */     public abstract Object[] getVisibleAnnotations(Field paramField)
/*     */       throws Exception;
/*     */ 
/*     */     public abstract Object[] getVisibleAnnotations(Constructor paramConstructor)
/*     */       throws Exception;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.annotation.AnnotationElement
 * JD-Core Version:    0.6.0
 */