/*     */ package org.jboss.aop.advice.annotation.assignability;
/*     */ 
/*     */ import java.lang.reflect.ParameterizedType;
/*     */ import java.lang.reflect.Type;
/*     */ 
/*     */ class ParamTypeAssignabilityAlgorithm
/*     */ {
/*     */   public static <C, T> boolean isAssignable(ParameterizedType paramType, Type fromType, EqualityChecker<C, T> checker, C caller, T checkerToken)
/*     */   {
/* 105 */     Class fromRaw = null;
/* 106 */     ParameterizedType fromParamType = null;
/* 107 */     Class desiredType = (Class)paramType.getRawType();
/* 108 */     if ((fromType instanceof Class))
/*     */     {
/* 110 */       fromRaw = (Class)fromType;
/* 111 */       if (!desiredType.isAssignableFrom(fromRaw))
/*     */       {
/* 113 */         return false;
/*     */       }
/* 115 */       if (fromRaw.getTypeParameters().length > 0)
/*     */       {
/* 121 */         return true;
/*     */       }
/*     */     }
/* 124 */     else if ((fromType instanceof ParameterizedType))
/*     */     {
/* 126 */       fromParamType = (ParameterizedType)fromType;
/* 127 */       fromRaw = (Class)fromParamType.getRawType();
/* 128 */       if (fromRaw == desiredType)
/*     */       {
/* 131 */         return checker.isSame(paramType.getActualTypeArguments(), fromParamType.getActualTypeArguments(), caller, checkerToken);
/*     */       }
/*     */ 
/* 134 */       if (!desiredType.isAssignableFrom(fromRaw))
/*     */       {
/* 136 */         return false;
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 141 */       return false;
/*     */     }
/*     */ 
/* 144 */     Type[] arguments = ArgumentContextualizer.getContextualizedArguments(fromParamType, fromRaw, desiredType);
/*     */ 
/* 146 */     if (arguments == null)
/*     */     {
/* 148 */       return true;
/*     */     }
/* 150 */     return checker.isSame(paramType.getActualTypeArguments(), arguments, caller, checkerToken);
/*     */   }
/*     */ 
/*     */   static abstract class EqualityChecker<C, T>
/*     */   {
/*     */     protected boolean isSame(Type[] arguments, Type[] fromArguments, C caller, T token)
/*     */     {
/*  63 */       for (int i = 0; i < arguments.length; i++)
/*     */       {
/*  65 */         if (!isSame(arguments[i], fromArguments[i], caller, token))
/*     */         {
/*  67 */           return false;
/*     */         }
/*     */       }
/*  70 */       return true;
/*     */     }
/*     */ 
/*     */     abstract boolean isSame(Type paramType1, Type paramType2, C paramC, T paramT);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.annotation.assignability.ParamTypeAssignabilityAlgorithm
 * JD-Core Version:    0.6.0
 */