/*     */ package org.jboss.aop.advice.annotation.assignability;
/*     */ 
/*     */ import java.lang.reflect.ParameterizedType;
/*     */ import java.lang.reflect.Type;
/*     */ import java.lang.reflect.TypeVariable;
/*     */ import java.util.LinkedList;
/*     */ import java.util.ListIterator;
/*     */ 
/*     */ class ArgumentContextualizer
/*     */ {
/*     */   private Type[] arguments;
/*     */   private LinkedList<VariableReplacer> variableReplacements;
/* 243 */   boolean initialized = false;
/*     */   private ListIterator<VariableReplacer> iterator;
/* 453 */   private static ReplacementScheduler<ArgumentContextualizer> replacementCreator = new ReplacementScheduler()
/*     */   {
/*     */     public void scheduleReplacement(Type[] replacementTarget, int targetIndex, int variableIndex, ArgumentContextualizer outer)
/*     */     {
/* 459 */       outer.initialize();
/* 460 */       outer.createVariableReplacement(outer.arguments, targetIndex, variableIndex);
/*     */     }
/* 453 */   };
/*     */ 
/* 470 */   private static ReplacementScheduler<VariableReplacer> updater = new ReplacementScheduler()
/*     */   {
/*     */     public void scheduleReplacement(Type[] replacementTarget, int targetIndex, int variableIndex, ArgumentContextualizer.VariableReplacer replacer)
/*     */     {
/* 476 */       if (replacer.pendingExecution)
/*     */       {
/* 478 */         replacer.getContextualizer().createVariableReplacement(replacementTarget, targetIndex, variableIndex);
/*     */       }
/*     */       else
/*     */       {
/* 483 */         ArgumentContextualizer.VariableReplacer.access$602(replacer, variableIndex);
/* 484 */         ArgumentContextualizer.VariableReplacer.access$702(replacer, replacementTarget);
/* 485 */         ArgumentContextualizer.VariableReplacer.access$802(replacer, targetIndex);
/* 486 */         ArgumentContextualizer.VariableReplacer.access$502(replacer, true);
/*     */       }
/*     */     }
/* 470 */   };
/*     */ 
/*     */   public static final Type[] getContextualizedArguments(ParameterizedType paramType, Class rawType, Class desiredType)
/*     */   {
/*  41 */     ArgumentContextualizer contextualizedArguments = getContextualizedArgumentsInternal(desiredType, rawType);
/*     */ 
/*  43 */     if (contextualizedArguments == null)
/*     */     {
/*  45 */       return null;
/*     */     }
/*  47 */     if (paramType != null)
/*     */     {
/*  49 */       contextualizedArguments.contextualizeVariables(null, paramType);
/*     */     }
/*  51 */     return contextualizedArguments.getArguments();
/*     */   }
/*     */ 
/*     */   private static final ArgumentContextualizer getContextualizedArgumentsInternal(Class<?> desiredType, Class<?> classType)
/*     */   {
/*  58 */     Type superType = null;
/*  59 */     if (desiredType.isInterface())
/*     */     {
/*  61 */       for (Type superInterface : classType.getGenericInterfaces())
/*     */       {
/*  63 */         if (((!(superInterface instanceof Class)) || (!desiredType.isAssignableFrom((Class)superInterface))) && ((!(superInterface instanceof ParameterizedType)) || (!desiredType.isAssignableFrom((Class)((ParameterizedType)superInterface).getRawType()))))
/*     */         {
/*     */           continue;
/*     */         }
/*     */ 
/*  69 */         superType = superInterface;
/*  70 */         break;
/*     */       }
/*     */     }
/*     */ 
/*  74 */     if (superType == null)
/*     */     {
/*  76 */       superType = classType.getGenericSuperclass();
/*     */     }
/*  78 */     ArgumentContextualizer result = null;
/*  79 */     if ((superType instanceof Class))
/*     */     {
/*  81 */       if (superType == desiredType)
/*     */       {
/*  83 */         return null;
/*     */       }
/*  85 */       result = getContextualizedArgumentsInternal(desiredType, (Class)superType);
/*     */     }
/*     */     else
/*     */     {
/*  90 */       ParameterizedType superParamType = (ParameterizedType)superType;
/*  91 */       Class superClassType = (Class)superParamType.getRawType();
/*  92 */       if (superClassType == desiredType)
/*     */       {
/*  94 */         return new ArgumentContextualizer(superParamType.getActualTypeArguments(), classType);
/*     */       }
/*     */ 
/*  99 */       result = getContextualizedArgumentsInternal(desiredType, superClassType);
/*     */     }
/*     */ 
/* 103 */     if ((result == null) || (!result.contextualizeVariables(classType, superType)))
/*     */     {
/* 106 */       return null;
/*     */     }
/* 108 */     return result;
/*     */   }
/*     */ 
/*     */   private ArgumentContextualizer(Type[] arguments, Class<?> declaringClass)
/*     */   {
/* 130 */     this.arguments = arguments;
/* 131 */     for (int i = 0; i < arguments.length; i++)
/*     */     {
/* 133 */       Type newArgument = processArgument(arguments, i, declaringClass, replacementCreator, this);
/*     */ 
/* 135 */       if (newArgument == null)
/*     */         continue;
/* 137 */       this.arguments[i] = newArgument;
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean contextualizeVariables(Class subClass, Type superType)
/*     */   {
/* 156 */     if ((!this.initialized) || (this.variableReplacements.isEmpty()))
/*     */     {
/* 158 */       this.initialized = false;
/* 159 */       return true;
/*     */     }
/* 161 */     if ((superType instanceof Class))
/*     */     {
/* 163 */       return false;
/*     */     }
/* 165 */     ParameterizedType superParamType = (ParameterizedType)superType;
/* 166 */     for (this.iterator = this.variableReplacements.listIterator(); this.iterator.hasNext(); )
/*     */     {
/* 168 */       if (!((VariableReplacer)this.iterator.next()).replace(superParamType, subClass))
/*     */         continue;
/* 170 */       this.iterator.remove();
/*     */     }
/*     */ 
/* 173 */     this.iterator = null;
/* 174 */     return true;
/*     */   }
/*     */ 
/*     */   private static <O> Type processArgument(Type[] argumentContainer, int argumentIndex, Class<?> declaringClass, ReplacementScheduler<O> recorder, O outer)
/*     */   {
/* 200 */     Type argument = argumentContainer[argumentIndex];
/* 201 */     if ((argument instanceof Class))
/*     */     {
/* 203 */       return null;
/*     */     }
/* 205 */     if ((argument instanceof ParameterizedType))
/*     */     {
/* 207 */       ParameterizedType paramType = (ParameterizedType)argument;
/* 208 */       ParameterizedType_ newParamType = null;
/* 209 */       Type[] arguments = paramType.getActualTypeArguments();
/* 210 */       for (int i = 0; i < arguments.length; i++)
/*     */       {
/* 212 */         Type newType = processArgument(arguments, i, declaringClass, recorder, outer);
/*     */ 
/* 214 */         if (newType == null)
/*     */           continue;
/* 216 */         if (newParamType == null)
/*     */         {
/* 218 */           newParamType = new ParameterizedType_(paramType);
/*     */         }
/* 220 */         newParamType.getActualTypeArguments()[i] = newType;
/*     */       }
/*     */ 
/* 223 */       return newParamType;
/*     */     }
/*     */ 
/* 226 */     if (declaringClass == null)
/*     */     {
/* 228 */       return null;
/*     */     }
/* 230 */     String paramName = ((TypeVariable)argument).getName();
/* 231 */     int index = 0;
/* 232 */     TypeVariable[] typeVariables = declaringClass.getTypeParameters();
/* 233 */     for (index = 0; index < typeVariables.length; index++)
/*     */     {
/* 235 */       if (typeVariables[index].getName().equals(paramName)) {
/*     */         break;
/*     */       }
/*     */     }
/* 239 */     recorder.scheduleReplacement(argumentContainer, argumentIndex, index, outer);
/* 240 */     return argument;
/*     */   }
/*     */ 
/*     */   private void initialize()
/*     */   {
/* 247 */     if (!this.initialized)
/*     */     {
/* 249 */       Type[] oldResult = this.arguments;
/* 250 */       this.arguments = new Type[oldResult.length];
/* 251 */       System.arraycopy(oldResult, 0, this.arguments, 0, this.arguments.length);
/* 252 */       this.variableReplacements = new LinkedList();
/* 253 */       this.initialized = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Type[] getArguments()
/*     */   {
/* 265 */     return this.arguments;
/*     */   }
/*     */ 
/*     */   private void createVariableReplacement(Type[] argumentContainer, int argumentIndex, int variableIndex)
/*     */   {
/* 284 */     if (this.iterator != null)
/*     */     {
/* 286 */       this.iterator.add(new VariableReplacer(argumentContainer, argumentIndex, variableIndex));
/*     */     }
/*     */     else
/*     */     {
/* 291 */       this.variableReplacements.add(new VariableReplacer(argumentContainer, argumentIndex, variableIndex));
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface ReplacementScheduler<C>
/*     */   {
/*     */     public abstract void scheduleReplacement(Type[] paramArrayOfType, int paramInt1, int paramInt2, C paramC);
/*     */   }
/*     */ 
/*     */   private static final class ParameterizedType_
/*     */     implements ParameterizedType
/*     */   {
/*     */     private Type[] arguments;
/*     */     private Type ownerType;
/*     */     private Type rawType;
/*     */ 
/*     */     ParameterizedType_(ParameterizedType type)
/*     */     {
/* 376 */       Type[] actualArguments = type.getActualTypeArguments();
/* 377 */       this.arguments = new Type[actualArguments.length];
/* 378 */       System.arraycopy(actualArguments, 0, this.arguments, 0, actualArguments.length);
/* 379 */       this.ownerType = type.getOwnerType();
/* 380 */       this.rawType = type.getRawType();
/*     */     }
/*     */ 
/*     */     public Type[] getActualTypeArguments()
/*     */     {
/* 386 */       return this.arguments;
/*     */     }
/*     */ 
/*     */     public Type getOwnerType()
/*     */     {
/* 391 */       return this.ownerType;
/*     */     }
/*     */ 
/*     */     public Type getRawType()
/*     */     {
/* 396 */       return this.rawType;
/*     */     }
/*     */ 
/*     */     public boolean equals(Object obj)
/*     */     {
/* 401 */       if (!(obj instanceof ParameterizedType))
/*     */       {
/* 403 */         return false;
/*     */       }
/* 405 */       ParameterizedType other = (ParameterizedType)obj;
/* 406 */       if ((!this.ownerType.equals(other.getOwnerType())) || (!this.rawType.equals(other.getRawType())))
/*     */       {
/* 409 */         return false;
/*     */       }
/* 411 */       Type[] otherArguments = other.getActualTypeArguments();
/* 412 */       for (int i = 0; i < this.arguments.length; i++)
/*     */       {
/* 414 */         if (!this.arguments[i].equals(otherArguments[i]))
/*     */         {
/* 416 */           return false;
/*     */         }
/*     */       }
/* 419 */       return true;
/*     */     }
/*     */   }
/*     */ 
/*     */   class VariableReplacer
/*     */   {
/*     */     private Type[] arguments;
/*     */     private int argumentIndex;
/*     */     private int valueIndex;
/*     */     private boolean pendingExecution;
/*     */ 
/*     */     public VariableReplacer(Type[] arguments, int argumentIndex, int valueIndex)
/*     */     {
/* 320 */       this.valueIndex = valueIndex;
/* 321 */       this.arguments = arguments;
/* 322 */       this.argumentIndex = argumentIndex;
/* 323 */       this.pendingExecution = true;
/*     */     }
/*     */ 
/*     */     public boolean replace(ParameterizedType paramType, Class<?> declaringClass)
/*     */     {
/* 339 */       this.arguments[this.argumentIndex] = paramType.getActualTypeArguments()[this.valueIndex];
/* 340 */       this.pendingExecution = false;
/* 341 */       Type newType = ArgumentContextualizer.access$100(this.arguments, this.argumentIndex, declaringClass, ArgumentContextualizer.updater, this);
/*     */ 
/* 343 */       if (newType != null)
/*     */       {
/* 345 */         this.arguments[this.argumentIndex] = newType;
/* 346 */         return false;
/*     */       }
/* 348 */       return true;
/*     */     }
/*     */ 
/*     */     ArgumentContextualizer getContextualizer()
/*     */     {
/* 358 */       return ArgumentContextualizer.this;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.annotation.assignability.ArgumentContextualizer
 * JD-Core Version:    0.6.0
 */