/*     */ package org.jboss.aop.advice.annotation;
/*     */ 
/*     */ import org.jboss.aop.advice.AdviceMethodProperties;
/*     */ import org.jboss.aop.joinpoint.FieldReadInvocation;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.JoinPointBean;
/*     */ 
/*     */  enum ParameterAnnotationRule
/*     */ {
/*  19 */   JOIN_POINT(JoinPoint.class, JoinPointBean.class, -1, 700, false, true), 
/*     */ 
/*  32 */   INVOCATION(JoinPoint.class, Invocation.class, -2, 700, false, true), 
/*     */ 
/*  45 */   TARGET(Target.class, null, -3, 300, false, true), 
/*     */ 
/*  62 */   CALLER(Caller.class, null, -7, 150, false, true), 
/*     */ 
/*  79 */   RETURN(Return.class, null, -4, 50, false, true), 
/*     */ 
/*  91 */   OPTIONAL_THROWN(Thrown.class, Throwable.class, -5, 50, false, true), 
/*     */ 
/*  98 */   MANDATORY_THROWN(Thrown.class, Throwable.class, -5, 50, true, true), 
/*     */ 
/* 105 */   ARG(Arg.class, null, -8, 2, false, false), 
/*     */ 
/* 117 */   ARGS(Args.class, [Ljava.lang.Object.class, -6, 1, false, true);
/*     */ 
/*     */   private Class annotation;
/*     */   private Class assignableFrom;
/*     */   private int rankGrade;
/*     */   private boolean mandatory;
/*     */   private boolean singleEnforced;
/*     */   private int property;
/*     */ 
/*     */   private ParameterAnnotationRule(Class annotation, Class assignableFrom, int property, int rankGrade, boolean mandatory, boolean singleEnforced)
/*     */   {
/* 152 */     this.annotation = annotation;
/* 153 */     this.assignableFrom = assignableFrom;
/* 154 */     this.property = property;
/* 155 */     this.rankGrade = rankGrade;
/* 156 */     this.mandatory = mandatory;
/* 157 */     this.singleEnforced = singleEnforced;
/*     */   }
/*     */ 
/*     */   public final Class getAnnotation()
/*     */   {
/* 166 */     return this.annotation;
/*     */   }
/*     */ 
/*     */   public Object getAssignableFrom(AdviceMethodProperties properties)
/*     */   {
/* 181 */     return this.assignableFrom;
/*     */   }
/*     */ 
/*     */   public final int getProperty()
/*     */   {
/* 191 */     return this.property;
/*     */   }
/*     */ 
/*     */   public final int getRankGrade()
/*     */   {
/* 202 */     return this.rankGrade;
/*     */   }
/*     */ 
/*     */   public boolean lowerRankGrade(AdviceMethodProperties properties)
/*     */   {
/* 216 */     return false;
/*     */   }
/*     */ 
/*     */   public final boolean isMandatory()
/*     */   {
/* 226 */     return this.mandatory;
/*     */   }
/*     */ 
/*     */   public final boolean isSingleEnforced()
/*     */   {
/* 237 */     return this.singleEnforced;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 242 */     return "@" + this.annotation.getSimpleName();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.annotation.ParameterAnnotationRule
 * JD-Core Version:    0.6.0
 */