/*     */ package org.jboss.aop.advice.annotation;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Type;
/*     */ import org.jboss.aop.advice.AdviceMethodProperties;
/*     */ import org.jboss.aop.advice.AdviceType;
/*     */ import org.jboss.aop.advice.InvalidAdviceException;
/*     */ import org.jboss.aop.advice.annotation.assignability.AssignabilityAlgorithm;
/*     */ import org.jboss.aop.advice.annotation.assignability.DegreeAlgorithm;
/*     */ import org.jboss.aop.advice.annotation.assignability.VariableHierarchy;
/*     */ 
/*     */ class AnnotatedParameterAdviceInfo extends AdviceInfo
/*     */ {
/*     */   private ParameterAnnotationType[] paramTypes;
/*     */   private ParameterAnnotationType[] contextParamTypes;
/*     */   private AdviceType adviceType;
/*     */   private VariableHierarchy hierarchy;
/*     */   private boolean prevalidated;
/*     */ 
/*     */   public AnnotatedParameterAdviceInfo(AdviceMethodProperties properties, AdviceType adviceType, Method method, ParameterAnnotationRule[] rules, ParameterAnnotationRule[] contextRules, int[][] mutuallyExclusive, int[][] compulsory, AdviceMethodFactory.ReturnType returnType)
/*     */     throws InvalidAdviceException
/*     */   {
/*  57 */     super(method, 0);
/*  58 */     this.paramTypes = createParameterAnnotationTypes(rules);
/*  59 */     this.contextParamTypes = createParameterAnnotationTypes(contextRules);
/*  60 */     this.adviceType = adviceType;
/*  61 */     this.hierarchy = new VariableHierarchy();
/*  62 */     applyRules(properties);
/*     */ 
/*  64 */     if ((returnType == AdviceMethodFactory.ReturnType.VOID) && (method.getReturnType() != Void.TYPE))
/*     */     {
/*  66 */       throw new InvalidAdviceException("The " + adviceType + " advice method '" + method + "' return type must be void");
/*     */     }
/*     */ 
/*  70 */     for (int i = 0; i < mutuallyExclusive.length; i++)
/*     */     {
/*  72 */       int[] exclusiveParamTypes = mutuallyExclusive[i];
/*  73 */       int found = -1;
/*  74 */       for (int j = 0; j < exclusiveParamTypes.length; j++)
/*     */       {
/*  76 */         if (!this.contextParamTypes[exclusiveParamTypes[j]].isSet())
/*     */           continue;
/*  78 */         if (found != -1)
/*     */         {
/*  80 */           throw new InvalidAdviceException("Mutually exclusive parameter annotations '" + this.contextParamTypes[exclusiveParamTypes[found]].rule + "' and '" + this.contextParamTypes[exclusiveParamTypes[j]].rule + "' found on " + adviceType + " advice method '" + method + "'");
/*     */         }
/*     */ 
/*  87 */         found = j;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  92 */     if (compulsory != null)
/*     */     {
/*  94 */       for (int i = 0; i < compulsory.length; i++)
/*     */       {
/*  96 */         ParameterAnnotationType precondition = this.paramTypes[compulsory[i][0]];
/*  97 */         if (!precondition.isSet())
/*     */           continue;
/*  99 */         for (int j = 1; j < compulsory[i].length; j++)
/*     */         {
/* 101 */           if (this.paramTypes[compulsory[i][j]].isSet())
/*     */             continue;
/* 103 */           throw new InvalidAdviceException("Compulsory " + this.paramTypes[compulsory[i][j]].rule + "-annotated parameter not found on " + adviceType + " advice method '" + method + "' (this parameter is compulsory in the presence of a " + precondition.rule + "-annotated parameter)");
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean matches(AdviceMethodProperties properties, AdviceMethodFactory.ReturnType returnType)
/*     */   {
/* 118 */     if (!this.prevalidated)
/*     */     {
/* 120 */       return false;
/*     */     }
/* 122 */     for (ParameterAnnotationType paramType : this.paramTypes)
/*     */     {
/* 124 */       if (!paramType.validate(properties))
/*     */       {
/* 126 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 130 */     for (ParameterAnnotationType paramType : this.contextParamTypes)
/*     */     {
/* 132 */       if (!paramType.validate(properties))
/*     */       {
/* 134 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 138 */     if ((this.method.getReturnType() == Void.TYPE) && (returnType == AdviceMethodFactory.ReturnType.NOT_VOID) && (properties.getJoinpointReturnType() != Void.TYPE))
/*     */     {
/* 141 */       AdviceMethodFactory.appendNewMatchingMessage(this.method, "return value cannot be void (it must match the joinpoint return type)");
/*     */ 
/* 143 */       return false;
/*     */     }
/* 145 */     if ((this.method.getReturnType() != Void.TYPE) && (this.method.getReturnType() != Object.class) && (!AssignabilityAlgorithm.FROM_VARIABLE.isAssignable(properties.getJoinpointReturnType(), this.method.getGenericReturnType(), this.hierarchy)))
/*     */     {
/* 151 */       AdviceMethodFactory.appendNewMatchingMessage(this.method, "return value cannot be assigned to type '");
/*     */ 
/* 153 */       AdviceMethodFactory.appendMatchingMessage(properties.getJoinpointReturnType());
/* 154 */       AdviceMethodFactory.appendMatchingMessage("'");
/* 155 */       return false;
/*     */     }
/* 157 */     return true;
/*     */   }
/*     */ 
/*     */   public void resetMatching()
/*     */   {
/* 162 */     for (int i = 0; i < this.paramTypes.length; i++)
/*     */     {
/* 164 */       this.paramTypes[i].resetValidation();
/*     */     }
/* 166 */     for (int i = 0; i < this.contextParamTypes.length; i++)
/*     */     {
/* 168 */       this.contextParamTypes[i].resetValidation();
/*     */     }
/*     */   }
/*     */ 
/*     */   public short getAssignabilityDegree(int annotationIndex, boolean isContextRule, AdviceMethodProperties properties)
/*     */   {
/* 175 */     if (isContextRule)
/*     */     {
/* 177 */       return this.contextParamTypes[annotationIndex].getAssignabilityDegree(properties);
/*     */     }
/* 179 */     return this.paramTypes[annotationIndex].getAssignabilityDegree(properties);
/*     */   }
/*     */ 
/*     */   public void assignAdviceInfo(AdviceMethodProperties properties)
/*     */   {
/* 184 */     int[] args = new int[this.parameterTypes.length];
/* 185 */     for (int i = 0; i < this.paramTypes.length; i++)
/*     */     {
/* 187 */       this.paramTypes[i].assignParameterInfo(args);
/*     */     }
/* 189 */     for (int i = 0; i < this.contextParamTypes.length; i++)
/*     */     {
/* 191 */       this.contextParamTypes[i].assignParameterInfo(args);
/*     */     }
/* 193 */     properties.setFoundProperties(this.method, args);
/*     */   }
/*     */ 
/*     */   private final ParameterAnnotationType[] createParameterAnnotationTypes(ParameterAnnotationRule[] rules)
/*     */   {
/* 207 */     ParameterAnnotationType[] types = new ParameterAnnotationType[rules.length];
/*     */ 
/* 209 */     for (int i = 0; i < rules.length; i++)
/*     */     {
/* 211 */       if (rules[i].isSingleEnforced())
/*     */       {
/* 213 */         types[i] = new SingleParameterType(rules[i]);
/*     */       }
/*     */       else
/*     */       {
/* 217 */         types[i] = new MultipleParameterType(rules[i], this.method.getParameterTypes().length);
/*     */       }
/*     */     }
/*     */ 
/* 221 */     return types;
/*     */   }
/*     */ 
/*     */   private void applyRules(AdviceMethodProperties properties)
/*     */   {
/* 232 */     Annotation[][] paramAnnotations = this.method.getParameterAnnotations();
/*     */ 
/* 234 */     boolean nullifyRank = false;
/* 235 */     for (int i = 0; i < paramAnnotations.length; i++)
/*     */     {
/* 237 */       ParameterAnnotationType typeFound = null;
/* 238 */       for (Annotation annotation : paramAnnotations[i])
/*     */       {
/* 241 */         if (typeFound == null)
/*     */         {
/* 243 */           typeFound = findAnnotationType(annotation, i);
/*     */         } else {
/* 245 */           if (findAnnotationType(annotation, i) == null)
/*     */             continue;
/* 247 */           throw new InvalidAdviceException("Parameter " + i + " of " + this.adviceType + " advice method '" + this.method + "' contains more than one valid annotation");
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 252 */       if (typeFound == null)
/*     */       {
/* 254 */         if (paramAnnotations[i].length == 0)
/*     */         {
/* 256 */           throw new InvalidAdviceException("Parameter " + i + " of " + this.adviceType + " advice method '" + this.method + "' is not annotated\nFor interception of joinpoint " + properties.getJoinPoint() + " expecting one of annotations: " + getDescription(this.paramTypes) + getDescription(this.contextParamTypes));
/*     */         }
/*     */ 
/* 262 */         AdviceMethodFactory.appendNewMatchingMessage(this.method, "parameter ");
/* 263 */         AdviceMethodFactory.appendMatchingMessage(Integer.valueOf(i));
/* 264 */         AdviceMethodFactory.appendMatchingMessage("' is not annotated correctly. Expecting one of: ");
/* 265 */         AdviceMethodFactory.appendMatchingMessage(getDescription(this.paramTypes));
/* 266 */         AdviceMethodFactory.appendMatchingMessage(getDescription(this.contextParamTypes));
/* 267 */         this.prevalidated = false;
/* 268 */         return;
/*     */       }
/*     */ 
/* 273 */       nullifyRank = (nullifyRank) || (typeFound.rule.lowerRankGrade(properties));
/*     */     }
/* 275 */     if (nullifyRank)
/*     */     {
/* 277 */       this.rank = 0;
/*     */     }
/* 279 */     this.prevalidated = true;
/*     */   }
/*     */ 
/*     */   private String getDescription(ParameterAnnotationType[] types)
/*     */   {
/* 284 */     StringBuffer buffer = new StringBuffer();
/* 285 */     for (int i = 1; i < types.length; i++)
/*     */     {
/* 287 */       buffer.append("\n          ");
/* 288 */       buffer.append(types[i].rule);
/*     */     }
/* 290 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   private final ParameterAnnotationType findAnnotationType(Annotation annotation, int i)
/*     */   {
/* 309 */     for (int j = 0; j < this.paramTypes.length; j++)
/*     */     {
/* 312 */       if (this.paramTypes[j].applies(annotation, i))
/*     */       {
/* 314 */         return this.paramTypes[j];
/*     */       }
/*     */     }
/* 317 */     for (int j = 0; j < this.contextParamTypes.length; j++)
/*     */     {
/* 320 */       if (this.contextParamTypes[j].applies(annotation, i))
/*     */       {
/* 322 */         return this.contextParamTypes[j];
/*     */       }
/*     */     }
/* 325 */     return null;
/*     */   }
/*     */ 
/*     */   class MultipleParameterType extends AnnotatedParameterAdviceInfo.ParameterAnnotationType
/*     */   {
/*     */     private int[][] indexes;
/*     */     private int[] originalIndexValues;
/*     */     private int indexesLength;
/*     */ 
/*     */     public MultipleParameterType(ParameterAnnotationRule rule, int totalArgs)
/*     */     {
/* 505 */       super(rule);
/* 506 */       this.indexes = new int[totalArgs][2];
/* 507 */       this.indexesLength = 0;
/* 508 */       this.originalIndexValues = new int[totalArgs];
/*     */     }
/*     */ 
/*     */     public final void setIndex(int index, Annotation annotation)
/*     */     {
/* 513 */       if (this.indexesLength == this.indexes.length)
/*     */       {
/* 515 */         throw new RuntimeException("Unexpected call to setIndex method during processing of '" + AnnotatedParameterAdviceInfo.this.method + "'");
/*     */       }
/*     */ 
/* 519 */       this.indexes[this.indexesLength][0] = index;
/* 520 */       this.originalIndexValues[this.indexesLength] = ((Arg)annotation).index();
/* 521 */       this.indexes[this.indexesLength][1] = this.originalIndexValues[this.indexesLength];
/* 522 */       this.indexesLength += 1;
/* 523 */       AnnotatedParameterAdviceInfo.this.rank += this.rule.getRankGrade();
/*     */     }
/*     */ 
/*     */     public final boolean isSet()
/*     */     {
/* 528 */       return this.indexesLength > 0;
/*     */     }
/*     */ 
/*     */     public final boolean internalValidate(AdviceMethodProperties properties)
/*     */     {
/* 533 */       Type[] expectedTypes = (Type[])(Type[])this.rule.getAssignableFrom(properties);
/* 534 */       Type[] adviceTypes = AnnotatedParameterAdviceInfo.this.method.getGenericParameterTypes();
/* 535 */       if ((this.indexesLength > 0) && (expectedTypes.length == 0))
/*     */       {
/* 537 */         AdviceMethodFactory.appendNewMatchingMessage(AnnotatedParameterAdviceInfo.this.method, "joinpoint has no arguments; unexpected ");
/* 538 */         AdviceMethodFactory.appendMatchingMessage(this.rule);
/* 539 */         AdviceMethodFactory.appendMatchingMessage("-annotated parameter found");
/* 540 */         return false;
/*     */       }
/* 542 */       if (this.indexesLength > expectedTypes.length)
/*     */       {
/* 544 */         AdviceMethodFactory.appendNewMatchingMessage(AnnotatedParameterAdviceInfo.this.method, "found more ");
/* 545 */         AdviceMethodFactory.appendMatchingMessage(this.rule);
/* 546 */         AdviceMethodFactory.appendMatchingMessage("-annotated parameters than the number of arguments available on the joinpoint");
/* 547 */         return false;
/*     */       }
/*     */ 
/* 550 */       boolean[] taken = new boolean[expectedTypes.length];
/* 551 */       for (int i = 0; i < this.indexesLength; i++)
/*     */       {
/* 554 */         if (this.indexes[i][1] == -1) {
/*     */           continue;
/*     */         }
/* 557 */         if (this.indexes[i][1] < 0)
/*     */         {
/* 559 */           throw new InvalidAdviceException("Negative joinpoint parameter index found at method '" + AnnotatedParameterAdviceInfo.this.method + "'");
/*     */         }
/*     */ 
/* 564 */         if (this.indexes[i][1] >= expectedTypes.length)
/*     */         {
/* 566 */           AdviceMethodFactory.appendNewMatchingMessage(AnnotatedParameterAdviceInfo.this.method, "there is no joinpoint argument with index ");
/*     */ 
/* 568 */           AdviceMethodFactory.appendMatchingMessage(Integer.valueOf(this.indexes[i][1]));
/* 569 */           AdviceMethodFactory.appendMatchingMessage(", since there are ");
/* 570 */           AdviceMethodFactory.appendMatchingMessage(expectedTypes.length == 0 ? "no" : Integer.valueOf(expectedTypes.length));
/* 571 */           AdviceMethodFactory.appendMatchingMessage(" joinpoint arguments available");
/* 572 */           return false;
/*     */         }
/*     */ 
/* 575 */         if (!AssignabilityAlgorithm.VARIABLE_TARGET.isAssignable(adviceTypes[this.indexes[i][0]], expectedTypes[this.indexes[i][1]], AnnotatedParameterAdviceInfo.this.hierarchy))
/*     */         {
/* 579 */           AdviceMethodFactory.appendNewMatchingMessage(AnnotatedParameterAdviceInfo.this.method, "advice parameter ");
/* 580 */           AdviceMethodFactory.appendMatchingMessage(Integer.valueOf(this.indexes[i][0]));
/* 581 */           AdviceMethodFactory.appendMatchingMessage(", of type '");
/* 582 */           AdviceMethodFactory.appendMatchingMessage(adviceTypes[this.indexes[i][0]]);
/* 583 */           AdviceMethodFactory.appendMatchingMessage("', cannot be assigned to the value of joinpoint argument with index ");
/* 584 */           AdviceMethodFactory.appendMatchingMessage(this.indexes[i][1] + ", whose type is '");
/* 585 */           AdviceMethodFactory.appendMatchingMessage(expectedTypes[this.indexes[i][1]]);
/* 586 */           AdviceMethodFactory.appendMatchingMessage("'");
/* 587 */           return false;
/*     */         }
/*     */ 
/* 590 */         if (taken[this.indexes[i][1]] != 0)
/*     */         {
/* 592 */           throw new InvalidAdviceException("Joinpoint parameter index '" + this.indexes[i][0] + "' cannot be assigned to more than one " + this.rule + "-annotated advice parameter (on " + AnnotatedParameterAdviceInfo.this.adviceType + " advice method '" + AnnotatedParameterAdviceInfo.this.method + "')");
/*     */         }
/*     */ 
/* 599 */         taken[this.indexes[i][1]] = true;
/*     */       }
/*     */ 
/* 603 */       for (int i = 0; i < this.indexesLength; i++)
/*     */       {
/* 606 */         if (this.indexes[i][1] != -1)
/*     */         {
/*     */           continue;
/*     */         }
/* 610 */         boolean found = false;
/* 611 */         for (int j = 0; j < expectedTypes.length; j++)
/*     */         {
/* 613 */           if ((adviceTypes[this.indexes[i][0]] != expectedTypes[j]) || (taken[j] != 0))
/*     */             continue;
/* 615 */           this.indexes[i][1] = j;
/* 616 */           taken[j] = true;
/* 617 */           found = true;
/* 618 */           break;
/*     */         }
/*     */ 
/* 621 */         if (found)
/*     */           continue;
/* 623 */         for (int j = 0; j < expectedTypes.length; j++)
/*     */         {
/* 625 */           if ((!AssignabilityAlgorithm.VARIABLE_TARGET.isAssignable(adviceTypes[this.indexes[i][0]], expectedTypes[j], AnnotatedParameterAdviceInfo.this.hierarchy)) || (taken[j] != 0))
/*     */           {
/*     */             continue;
/*     */           }
/* 629 */           this.indexes[i][1] = j;
/* 630 */           taken[j] = true;
/* 631 */           found = true;
/* 632 */           break;
/*     */         }
/*     */ 
/* 635 */         if (found)
/*     */           continue;
/* 637 */         AdviceMethodFactory.appendNewMatchingMessage(AnnotatedParameterAdviceInfo.this.method, "not found a match for argument ");
/*     */ 
/* 639 */         AdviceMethodFactory.appendMatchingMessage(adviceTypes[this.indexes[i][0]]);
/* 640 */         AdviceMethodFactory.appendMatchingMessage("; expected one of types: ");
/* 641 */         for (int j = 0; j < expectedTypes.length; j++)
/*     */         {
/* 643 */           if (taken[j] != 0)
/*     */             continue;
/* 645 */           AdviceMethodFactory.appendMatchingMessage(expectedTypes[j]);
/* 646 */           AdviceMethodFactory.appendMatchingMessage(" ");
/*     */         }
/*     */ 
/* 649 */         return false;
/*     */       }
/*     */ 
/* 653 */       return true;
/*     */     }
/*     */ 
/*     */     public void resetValidation()
/*     */     {
/* 658 */       for (int i = 0; i < this.indexesLength; i++)
/*     */       {
/* 660 */         this.indexes[i][1] = this.originalIndexValues[i];
/*     */       }
/*     */     }
/*     */ 
/*     */     public short getAssignabilityDegree(AdviceMethodProperties properties)
/*     */     {
/* 666 */       if (this.indexesLength == 0)
/*     */       {
/* 668 */         return -1;
/*     */       }
/* 670 */       Type[] expectedTypes = (Type[])(Type[])this.rule.getAssignableFrom(properties);
/* 671 */       short level = 0;
/* 672 */       for (int i = 0; i < this.indexesLength; i++)
/*     */       {
/* 674 */         level = (short)(level + AdviceInfo.DEGREE.getAssignabilityDegree(AnnotatedParameterAdviceInfo.this.method.getGenericParameterTypes()[this.indexes[i][0]], expectedTypes[this.indexes[i][1]]));
/*     */       }
/*     */ 
/* 678 */       return level;
/*     */     }
/*     */ 
/*     */     public void assignParameterInfo(int[] args)
/*     */     {
/* 683 */       for (int i = 0; i < this.indexesLength; i++)
/*     */       {
/* 685 */         args[this.indexes[i][0]] = this.indexes[i][1];
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   class SingleParameterType extends AnnotatedParameterAdviceInfo.ParameterAnnotationType
/*     */   {
/*     */     int index;
/*     */ 
/*     */     public SingleParameterType(ParameterAnnotationRule rule)
/*     */     {
/* 434 */       super(rule);
/* 435 */       this.index = -1;
/*     */     }
/*     */ 
/*     */     public final void setIndex(int parameterIndex, Annotation annotation)
/*     */     {
/* 440 */       if (this.index != -1)
/*     */       {
/* 442 */         throw new InvalidAdviceException("Found more than one occurence of '" + this.rule + "' on parameters of " + AnnotatedParameterAdviceInfo.this.adviceType + " advice method '" + AnnotatedParameterAdviceInfo.this.method + "'");
/*     */       }
/*     */ 
/* 447 */       this.index = parameterIndex;
/* 448 */       AnnotatedParameterAdviceInfo.this.rank += this.rule.getRankGrade();
/*     */     }
/*     */ 
/*     */     public final boolean isSet()
/*     */     {
/* 453 */       return this.index != -1;
/*     */     }
/*     */ 
/*     */     public final boolean internalValidate(AdviceMethodProperties properties)
/*     */     {
/* 458 */       if ((this.index != -1) && (!AssignabilityAlgorithm.VARIABLE_TARGET.isAssignable(AnnotatedParameterAdviceInfo.this.method.getGenericParameterTypes()[this.index], (Type)this.rule.getAssignableFrom(properties), AnnotatedParameterAdviceInfo.this.hierarchy)))
/*     */       {
/* 462 */         AdviceMethodFactory.appendNewMatchingMessage(AnnotatedParameterAdviceInfo.this.method, this.rule);
/* 463 */         AdviceMethodFactory.appendMatchingMessage("-annotated parameter is not assignable from expected type ");
/* 464 */         AdviceMethodFactory.appendMatchingMessage((Type)this.rule.getAssignableFrom(properties));
/* 465 */         return false;
/*     */       }
/* 467 */       return true;
/*     */     }
/*     */ 
/*     */     public final void resetValidation()
/*     */     {
/*     */     }
/*     */ 
/*     */     public final short getAssignabilityDegree(AdviceMethodProperties properties) {
/* 475 */       if (this.index == -1)
/*     */       {
/* 477 */         return -1;
/*     */       }
/* 479 */       return AdviceInfo.DEGREE.getAssignabilityDegree(AnnotatedParameterAdviceInfo.this.method.getGenericParameterTypes()[this.index], (Type)this.rule.getAssignableFrom(properties));
/*     */     }
/*     */ 
/*     */     public final void assignParameterInfo(int[] args)
/*     */     {
/* 486 */       if (this.index != -1)
/*     */       {
/* 488 */         args[this.index] = this.rule.getProperty();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   abstract class ParameterAnnotationType
/*     */   {
/*     */     ParameterAnnotationRule rule;
/*     */ 
/*     */     public ParameterAnnotationType(ParameterAnnotationRule rule)
/*     */     {
/* 337 */       this.rule = rule;
/*     */     }
/*     */ 
/*     */     public final boolean applies(Annotation parameterAnnotation, int parameterIndex)
/*     */     {
/* 350 */       if (parameterAnnotation.annotationType() == this.rule.getAnnotation())
/*     */       {
/* 352 */         setIndex(parameterIndex, parameterAnnotation);
/* 353 */         return true;
/*     */       }
/* 355 */       return false;
/*     */     }
/*     */ 
/*     */     public final boolean validate(AdviceMethodProperties properties)
/*     */     {
/* 367 */       if ((this.rule.isMandatory()) && (!isSet()))
/*     */       {
/* 369 */         AdviceMethodFactory.appendNewMatchingMessage(AnnotatedParameterAdviceInfo.this.method, "mandatory ");
/* 370 */         AdviceMethodFactory.appendMatchingMessage(this.rule);
/* 371 */         AdviceMethodFactory.appendMatchingMessage("-annotated parameter  not found");
/* 372 */         return false;
/*     */       }
/* 374 */       return internalValidate(properties);
/*     */     }
/*     */ 
/*     */     public abstract void setIndex(int paramInt, Annotation paramAnnotation);
/*     */ 
/*     */     public abstract boolean isSet();
/*     */ 
/*     */     public abstract boolean internalValidate(AdviceMethodProperties paramAdviceMethodProperties);
/*     */ 
/*     */     public abstract void resetValidation();
/*     */ 
/*     */     public abstract short getAssignabilityDegree(AdviceMethodProperties paramAdviceMethodProperties);
/*     */ 
/*     */     public abstract void assignParameterInfo(int[] paramArrayOfInt);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.annotation.AnnotatedParameterAdviceInfo
 * JD-Core Version:    0.6.0
 */