/*     */ package org.jboss.aop.advice.annotation;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.ListIterator;
/*     */ import java.util.Map;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.advice.AdviceMethodProperties;
/*     */ import org.jboss.aop.advice.AdviceType;
/*     */ import org.jboss.aop.advice.InvalidAdviceException;
/*     */ import org.jboss.aop.advice.NoMatchingAdviceException;
/*     */ import org.jboss.aop.advice.annotation.assignability.DegreeAlgorithm;
/*     */ import org.jboss.aop.util.ReflectUtils;
/*     */ 
/*     */ public class AdviceMethodFactory
/*     */ {
/*  62 */   public static final AdviceMethodFactory BEFORE = new AdviceMethodFactory(null, new ParameterAnnotationRule[] { ParameterAnnotationRule.JOIN_POINT }, ReturnType.VOID, (int[][])null);
/*     */ 
/*  68 */   public static final AdviceMethodFactory AFTER = new AdviceMethodFactory(null, new ParameterAnnotationRule[] { ParameterAnnotationRule.JOIN_POINT, ParameterAnnotationRule.RETURN }, ReturnType.ANY, (int[][])null);
/*     */ 
/*  74 */   public static final AdviceMethodFactory THROWING = new AdviceMethodFactory(null, new ParameterAnnotationRule[] { ParameterAnnotationRule.JOIN_POINT, ParameterAnnotationRule.MANDATORY_THROWN }, ReturnType.VOID, (int[][])null);
/*     */ 
/*  80 */   public static final AdviceMethodFactory FINALLY = new AdviceMethodFactory(null, new ParameterAnnotationRule[] { ParameterAnnotationRule.JOIN_POINT, ParameterAnnotationRule.RETURN, ParameterAnnotationRule.OPTIONAL_THROWN }, ReturnType.ANY, new int[][] { { 1, 2 } });
/*     */ 
/*  87 */   public static final AdviceMethodFactory AROUND = new AdviceMethodFactory(new AdviceSignatureRule()
/*     */   {
/*     */     public boolean applies(Method method)
/*     */     {
/*  95 */       Annotation[][] annotations = method.getParameterAnnotations();
/*  96 */       if (annotations.length != 1)
/*     */       {
/*  98 */         return false;
/*     */       }
/*     */ 
/* 101 */       for (Annotation annotation : annotations[0])
/*     */       {
/* 103 */         if (annotation.annotationType().getPackage() == AdviceMethodFactory.class.getPackage())
/*     */         {
/* 106 */           return false;
/*     */         }
/*     */       }
/*     */ 
/* 110 */       if (method.getReturnType() != Object.class)
/*     */       {
/* 112 */         throw new InvalidAdviceException("Method '" + method + "' does not match default around signature because it returns " + method.getReturnType() + " instead of java.lang.Object");
/*     */       }
/*     */ 
/* 118 */       for (Class exceptionType : method.getExceptionTypes())
/*     */       {
/* 120 */         if (exceptionType == Throwable.class)
/*     */         {
/* 122 */           return true;
/*     */         }
/*     */       }
/* 125 */       throw new InvalidAdviceException("Method '" + method + "' does not match default around signature because it does not throw java.lang.Throwable");
/*     */     }
/*     */ 
/*     */     public AdviceInfo getAdviceInfo(Method method)
/*     */     {
/* 132 */       return new AdviceInfo(method, 2000)
/*     */       {
/*     */         public boolean matches(AdviceMethodProperties properties, AdviceMethodFactory.ReturnType adviceReturn)
/*     */         {
/* 137 */           if (this.parameterTypes[0].isAssignableFrom(properties.getInvocationType()))
/*     */           {
/* 139 */             return true;
/*     */           }
/* 141 */           if (AspectManager.verbose)
/*     */           {
/* 143 */             AdviceMethodFactory.appendNewMatchingMessage(this.method, "argument 0 is not assignable from ");
/* 144 */             AdviceMethodFactory.appendMatchingMessage(properties.getInvocationType());
/*     */           }
/* 146 */           return false;
/*     */         }
/*     */ 
/*     */         public void resetMatching()
/*     */         {
/*     */         }
/*     */ 
/*     */         public short getAssignabilityDegree(int typeIndex, boolean isContextRule, AdviceMethodProperties properties) {
/* 154 */           return DEGREE.getAssignabilityDegree(properties.getInvocationType(), this.parameterTypes[0]);
/*     */         }
/*     */ 
/*     */         public void assignAdviceInfo(AdviceMethodProperties properties)
/*     */         {
/* 159 */           properties.setFoundProperties(this.method, new int[] { -2 });
/*     */         } } ;
/*     */     }
/*     */   }
/*     */   , new ParameterAnnotationRule[] { ParameterAnnotationRule.INVOCATION }, ReturnType.NOT_VOID, (int[][])null);
/*     */ 
/* 169 */   static final ParameterAnnotationRule[] TARGET_AVAILABLE = { ParameterAnnotationRule.TARGET, ParameterAnnotationRule.ARGS, ParameterAnnotationRule.ARG };
/*     */ 
/* 172 */   static final int[][] TA_INCOMPATIBILITY = { { 1, 2 } };
/*     */ 
/* 174 */   static final ParameterAnnotationRule[] TARGET_CALLER_AVAILABLE = { ParameterAnnotationRule.TARGET, ParameterAnnotationRule.CALLER, ParameterAnnotationRule.ARGS, ParameterAnnotationRule.ARG };
/*     */ 
/* 178 */   static final int[][] TCA_INCOMPATIBILITY = { { 2, 3 } };
/*     */ 
/* 181 */   private static StringBuffer adviceMatchingMessage = new StringBuffer();
/*     */   private Map<String, Map<ParameterAnnotationRule[], WeakReference<Collection<AdviceInfo>>>> adviceInfoCache;
/*     */   private ReturnType returnType;
/*     */   private AdviceSignatureRule adviceSignatureRule;
/*     */   private ParameterAnnotationRule[] rules;
/*     */   private int[][] compulsory;
/*     */   private AdviceType adviceType;
/*     */ 
/*     */   static <T> void appendNewMatchingMessage(Method method, T message) {
/* 194 */     adviceMatchingMessage.append("\n  On method '");
/* 195 */     adviceMatchingMessage.append(method);
/* 196 */     adviceMatchingMessage.append("'\n    ");
/* 197 */     adviceMatchingMessage.append(message);
/*     */   }
/*     */ 
/*     */   static <T> void appendMatchingMessage(T message)
/*     */   {
/* 203 */     adviceMatchingMessage.append(message);
/*     */   }
/*     */ 
/*     */   private AdviceMethodFactory(AdviceSignatureRule adviceSignatureRule, ParameterAnnotationRule[] rules, ReturnType returnType, int[][] compulsory)
/*     */   {
/* 223 */     this.adviceSignatureRule = adviceSignatureRule;
/* 224 */     this.rules = rules;
/* 225 */     this.returnType = returnType;
/* 226 */     this.adviceInfoCache = new HashMap();
/*     */ 
/* 228 */     this.compulsory = compulsory;
/*     */   }
/*     */ 
/*     */   public void setAdviceType(AdviceType adviceType)
/*     */   {
/* 241 */     if (this.adviceType != null)
/*     */     {
/* 243 */       throw new RuntimeException("Unexpected call to setAdviceType method");
/*     */     }
/* 245 */     this.adviceType = adviceType;
/*     */   }
/*     */ 
/*     */   public final AdviceMethodProperties findAdviceMethod(AdviceMethodProperties properties)
/*     */     throws NoMatchingAdviceException
/*     */   {
/* 258 */     adviceMatchingMessage.delete(0, adviceMatchingMessage.length());
/*     */ 
/* 260 */     ParameterAnnotationRule[] contextRules = null;
/* 261 */     int[][] mutuallyExclusive = (int[][])null;
/* 262 */     switch (2.$SwitchMap$org$jboss$aop$advice$AdviceMethodProperties$OptionalParameters[properties.getOptionalParameters().ordinal()])
/*     */     {
/*     */     case 1:
/* 265 */       contextRules = TARGET_AVAILABLE;
/* 266 */       mutuallyExclusive = TA_INCOMPATIBILITY;
/* 267 */       break;
/*     */     case 2:
/* 269 */       contextRules = TARGET_CALLER_AVAILABLE;
/* 270 */       mutuallyExclusive = TCA_INCOMPATIBILITY;
/* 271 */       break;
/*     */     default:
/* 273 */       throw new RuntimeException("Unexpected Optional Parameters Option" + properties.getOptionalParameters());
/*     */     }
/*     */ 
/* 277 */     Collection cacheCollection = getRankedAdvices(properties, contextRules, mutuallyExclusive);
/*     */ 
/* 281 */     if ((cacheCollection == null) || (cacheCollection.isEmpty()))
/*     */     {
/* 283 */       throw new NoMatchingAdviceException(properties, this.adviceType, adviceMatchingMessage.toString());
/*     */     }
/*     */ 
/* 286 */     synchronized (cacheCollection)
/*     */     {
/* 288 */       LinkedList rankedAdvices = new LinkedList(cacheCollection);
/*     */ 
/* 291 */       AdviceInfo bestAdvice = bestValidAdvice(rankedAdvices, properties, contextRules);
/*     */ 
/* 293 */       if (bestAdvice == null)
/*     */       {
/* 295 */         throw new NoMatchingAdviceException(properties, this.adviceType, adviceMatchingMessage.toString());
/*     */       }
/*     */ 
/* 299 */       bestAdvice.assignAdviceInfo(properties);
/* 300 */       properties.setAdviceOverloaded(rankedAdvices.size() > 1);
/*     */     }
/* 302 */     return properties;
/*     */   }
/*     */ 
/*     */   private Collection<AdviceInfo> getRankedAdvices(AdviceMethodProperties properties, ParameterAnnotationRule[] contextRules, int[][] mutuallyExclusive)
/*     */   {
/*     */     Map map;
/* 325 */     synchronized (this.adviceInfoCache)
/*     */     {
/* 328 */       String key = properties.getAspectClass().getName() + properties.getAdviceName();
/*     */ 
/* 330 */       map = (Map)this.adviceInfoCache.get(key);
/* 331 */       if (map == null)
/*     */       {
/* 333 */         map = new HashMap();
/* 334 */         this.adviceInfoCache.put(key, map);
/*     */       }
/*     */     }
/* 337 */     synchronized (map)
/*     */     {
/* 339 */       if (map.containsKey(contextRules))
/*     */       {
/* 341 */         WeakReference advicesReference = (WeakReference)map.get(contextRules);
/* 342 */         Collection advices = (Collection)advicesReference.get();
/* 343 */         if (advices != null)
/*     */         {
/* 345 */           for (AdviceInfo adviceInfo : advices)
/*     */           {
/* 347 */             adviceInfo.resetMatching();
/*     */           }
/* 349 */           return advices;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 354 */       Method[] methods = ReflectUtils.getMethodsWithName(properties.getAspectClass(), properties.getAdviceName());
/*     */ 
/* 356 */       ArrayList rankedAdvices = new ArrayList(methods.length);
/*     */ 
/* 359 */       map.put(contextRules, new WeakReference(rankedAdvices));
/*     */ 
/* 362 */       if (methods.length == 0)
/*     */       {
/* 364 */         if (AspectManager.verbose)
/*     */         {
/* 366 */           throw new NoMatchingAdviceException(properties, this.adviceType, ": no method named " + properties.getAdviceName() + " was found");
/*     */         }
/*     */ 
/* 370 */         return null;
/*     */       }
/*     */ 
/* 373 */       for (int i = 0; i < methods.length; i++)
/*     */       {
/* 376 */         if ((this.adviceSignatureRule != null) && (this.adviceSignatureRule.applies(methods[i])))
/*     */         {
/* 379 */           rankedAdvices.add(this.adviceSignatureRule.getAdviceInfo(methods[i]));
/*     */         }
/*     */         else
/*     */         {
/* 384 */           rankedAdvices.add(new AnnotatedParameterAdviceInfo(properties, this.adviceType, methods[i], this.rules, contextRules, mutuallyExclusive, this.compulsory, this.returnType));
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 390 */       Collections.sort(rankedAdvices);
/* 391 */       return rankedAdvices;
/*     */     }
/*     */   }
/*     */ 
/*     */   private AdviceInfo bestValidAdvice(LinkedList<AdviceInfo> rankedAdvices, AdviceMethodProperties properties, ParameterAnnotationRule[] contextRules)
/*     */   {
/* 407 */     AdviceInfo bestAdvice = null;
/* 408 */     ListIterator iterator = rankedAdvices.listIterator();
/* 409 */     while (iterator.hasNext())
/*     */     {
/* 411 */       AdviceInfo advice = (AdviceInfo)iterator.next();
/* 412 */       if (advice.matches(properties, this.returnType))
/*     */       {
/* 414 */         bestAdvice = advice;
/* 415 */         break;
/*     */       }
/*     */ 
/* 419 */       iterator.remove();
/*     */     }
/*     */ 
/* 423 */     switch (rankedAdvices.size())
/*     */     {
/*     */     case 0:
/* 427 */       return null;
/*     */     case 1:
/* 430 */       return bestAdvice;
/*     */     }
/*     */ 
/* 433 */     while (iterator.hasNext())
/*     */     {
/* 435 */       AdviceInfo advice = (AdviceInfo)iterator.next();
/* 436 */       if (advice.getRank() == bestAdvice.getRank())
/*     */       {
/* 438 */         if (!advice.matches(properties, this.returnType))
/*     */         {
/* 440 */           iterator.remove();
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 445 */         iterator.previous();
/* 446 */         break;
/*     */       }
/*     */     }
/*     */ 
/* 450 */     if (iterator.previous() == bestAdvice)
/*     */     {
/* 452 */       return bestAdvice;
/*     */     }
/* 454 */     iterator.next();
/*     */ 
/* 456 */     List bestAdvices = rankedAdvices.subList(0, iterator.nextIndex());
/*     */ 
/* 459 */     return bestMatch(bestAdvices, properties, contextRules);
/*     */   }
/*     */ 
/*     */   AdviceInfo bestMatch(Collection<AdviceInfo> greatestRank, AdviceMethodProperties properties, ParameterAnnotationRule[] contextRules)
/*     */   {
/* 481 */     AdviceInfo bestAdvice = selectBestRuleMatch(greatestRank, properties, this.rules.length, false);
/*     */ 
/* 483 */     if (bestAdvice != null)
/*     */     {
/* 485 */       return bestAdvice;
/*     */     }
/*     */ 
/* 488 */     bestAdvice = selectBestRuleMatch(greatestRank, properties, contextRules.length, true);
/*     */ 
/* 490 */     if (bestAdvice != null)
/*     */     {
/* 492 */       return bestAdvice;
/*     */     }
/* 494 */     short bestDegree = 32767;
/* 495 */     if ((this.returnType == ReturnType.ANY) || (this.returnType == ReturnType.NOT_VOID))
/*     */     {
/* 497 */       for (AdviceInfo currentAdvice : greatestRank)
/*     */       {
/* 499 */         short currentDegree = currentAdvice.getReturnAssignabilityDegree(properties);
/* 500 */         if (currentDegree < bestDegree)
/*     */         {
/* 502 */           bestAdvice = currentAdvice;
/* 503 */           bestDegree = currentDegree;
/*     */         }
/*     */       }
/*     */ 
/* 507 */       return bestAdvice;
/*     */     }
/*     */ 
/* 510 */     return (AdviceInfo)greatestRank.iterator().next();
/*     */   }
/*     */ 
/*     */   private AdviceInfo selectBestRuleMatch(Collection<AdviceInfo> greatestRank, AdviceMethodProperties properties, int totalRules, boolean isContextRule)
/*     */   {
/* 531 */     short bestDegree = 32767;
/* 532 */     List bestAdviceList = new ArrayList();
/*     */ 
/* 535 */     for (int i = 0; i < totalRules; i++)
/*     */     {
/* 537 */       Iterator iterator = greatestRank.iterator();
/* 538 */       while (iterator.hasNext())
/*     */       {
/* 540 */         AdviceInfo currentAdvice = (AdviceInfo)iterator.next();
/* 541 */         short currentDegree = currentAdvice.getAssignabilityDegree(i, isContextRule, properties);
/*     */ 
/* 543 */         if (currentDegree < bestDegree)
/*     */         {
/* 545 */           bestAdviceList.clear();
/* 546 */           bestAdviceList.add(currentAdvice);
/* 547 */           bestDegree = currentDegree;
/*     */         }
/* 549 */         else if (currentDegree == bestDegree)
/*     */         {
/* 551 */           bestAdviceList.add(currentAdvice);
/*     */         }
/*     */       }
/*     */ 
/* 555 */       if (bestAdviceList.size() == 1)
/*     */       {
/* 557 */         return (AdviceInfo)bestAdviceList.get(0);
/*     */       }
/* 559 */       greatestRank.clear();
/* 560 */       greatestRank.addAll(bestAdviceList);
/*     */ 
/* 562 */       bestAdviceList.clear();
/* 563 */       bestDegree = 32767;
/*     */     }
/* 565 */     return null;
/*     */   }
/*     */ 
/*     */   static abstract interface MatchingRule
/*     */   {
/*     */     public abstract boolean matches(AdviceMethodProperties paramAdviceMethodProperties);
/*     */   }
/*     */ 
/*     */   static abstract interface AdviceSignatureRule
/*     */   {
/*     */     public abstract boolean applies(Method paramMethod);
/*     */ 
/*     */     public abstract AdviceInfo getAdviceInfo(Method paramMethod);
/*     */   }
/*     */ 
/*     */   static enum ReturnType
/*     */   {
/*  57 */     VOID, ANY, NOT_VOID;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.annotation.AdviceMethodFactory
 * JD-Core Version:    0.6.0
 */