/*     */ package org.jboss.aop.advice;
/*     */ 
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.GeneratedClassAdvisor;
/*     */ import org.jboss.aop.joinpoint.FieldJoinpoint;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ 
/*     */ public class ScopedInterceptorFactory
/*     */   implements InterceptorFactory
/*     */ {
/*     */   private AspectDefinition aspect;
/*     */ 
/*     */   public ScopedInterceptorFactory(AspectDefinition aspect)
/*     */   {
/*  42 */     this.aspect = aspect;
/*     */   }
/*     */ 
/*     */   public AspectDefinition getAspect()
/*     */   {
/*  47 */     return this.aspect;
/*     */   }
/*     */ 
/*     */   public String getAdvice()
/*     */   {
/*  52 */     return "invoke";
/*     */   }
/*     */ 
/*     */   public AdviceType getType()
/*     */   {
/*  57 */     return AdviceType.AROUND;
/*     */   }
/*     */ 
/*     */   public boolean isDeployed()
/*     */   {
/*  62 */     return this.aspect.isDeployed();
/*     */   }
/*     */ 
/*     */   public Interceptor create(Advisor advisor, Joinpoint joinpoint)
/*     */   {
/*  67 */     if (this.aspect.getScope() == Scope.PER_VM)
/*     */     {
/*  69 */       return (Interceptor)advisor.getManager().getPerVMAspect(this.aspect);
/*     */     }
/*  71 */     if (this.aspect.getScope() == Scope.PER_CLASS)
/*     */     {
/*  73 */       Interceptor interceptor = advisor.getAdviceInterceptor(this.aspect, "invoke", null);
/*  74 */       if (interceptor != null) return interceptor;
/*  75 */       advisor.addPerClassAspect(this.aspect);
/*  76 */       interceptor = (Interceptor)advisor.getPerClassAspect(this.aspect);
/*  77 */       advisor.addAdviceInterceptor(this.aspect, "invoke", interceptor, null);
/*  78 */       return interceptor;
/*     */     }
/*     */ 
/*  81 */     if (this.aspect.getScope() == Scope.PER_INSTANCE)
/*     */     {
/*  83 */       return new PerInstanceInterceptor(this.aspect, advisor);
/*     */     }
/*  85 */     if (this.aspect.getScope() == Scope.PER_JOINPOINT)
/*     */     {
/*     */       try
/*     */       {
/*  89 */         return PerJoinpointInterceptor.createInterceptor(advisor, joinpoint, this.aspect);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*  93 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/*  96 */     if (this.aspect.getScope() == Scope.PER_CLASS_JOINPOINT)
/*     */     {
/*  98 */       if ((advisor instanceof GeneratedClassAdvisor))
/*     */       {
/* 101 */         Object icptr = ((GeneratedClassAdvisor)advisor).getPerClassJoinpointAspect(this.aspect, joinpoint);
/* 102 */         if (icptr == null)
/*     */         {
/* 104 */           ((GeneratedClassAdvisor)advisor).addPerClassJoinpointAspect(this.aspect, joinpoint);
/* 105 */           icptr = ((GeneratedClassAdvisor)advisor).getPerClassJoinpointAspect(this.aspect, joinpoint);
/*     */         }
/* 107 */         return (Interceptor)icptr;
/*     */       }
/* 109 */       if ((joinpoint instanceof FieldJoinpoint))
/*     */       {
/* 111 */         FieldJoinpoint field = (FieldJoinpoint)joinpoint;
/* 112 */         ClassAdvisor classAdvisor = (ClassAdvisor)advisor;
/* 113 */         return (Interceptor)classAdvisor.getFieldAspect(field, this.aspect);
/*     */       }
/*     */ 
/* 116 */       return (Interceptor)this.aspect.getFactory().createPerJoinpoint(advisor, joinpoint);
/*     */     }
/*     */ 
/* 122 */     return null;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 127 */     return this.aspect.getName();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 132 */     if (this == obj) return true;
/* 133 */     if (!(obj instanceof ScopedInterceptorFactory)) return false;
/*     */ 
/* 135 */     AspectDefinition otherAspect = ((GenericInterceptorFactory)obj).getAspect();
/*     */ 
/* 137 */     if (!this.aspect.getName().equals(otherAspect.getName())) return false;
/* 138 */     return this.aspect.getFactory().getName().equals(otherAspect.getFactory().getName());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.ScopedInterceptorFactory
 * JD-Core Version:    0.6.0
 */