/*     */ package org.jboss.aop.advice;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.Comparator;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashMap;
/*     */ import org.jboss.aop.AspectManager;
/*     */ 
/*     */ public class PrecedenceSorter
/*     */ {
/*  39 */   static Comparator interceptorComparator = new Comparator()
/*     */   {
/*     */     public int compare(Object objA, Object objB)
/*     */     {
/*  43 */       PrecedenceSorter.InterceptorEntry entryA = (PrecedenceSorter.InterceptorEntry)objA;
/*  44 */       PrecedenceSorter.InterceptorEntry entryB = (PrecedenceSorter.InterceptorEntry)objB;
/*     */ 
/*  46 */       return entryA.precedenceOrder - entryB.precedenceOrder;
/*     */     }
/*  39 */   };
/*     */ 
/*     */   private static boolean matches(InterceptorEntry ientry, PrecedenceDefEntry pentry)
/*     */   {
/* 140 */     if (ientry.classname.equals(pentry.interceptorClass))
/*     */     {
/* 142 */       if (ientry.method == null)
/*     */       {
/* 144 */         if (pentry.adviceMethod == null)
/*     */         {
/* 146 */           return true;
/*     */         }
/*     */       }
/* 149 */       else if (pentry.adviceMethod != null)
/*     */       {
/* 153 */         return ientry.method.equals(pentry.adviceMethod);
/*     */       }
/*     */     }
/* 156 */     return false;
/*     */   }
/*     */ 
/*     */   public static PrecedenceDefEntry[] createOverallPrecedence(AspectManager manager)
/*     */   {
/* 162 */     ArrayList overall = new ArrayList();
/*     */ 
/* 164 */     LinkedHashMap precedenceDefs = manager.getPrecedenceDefs();
/* 165 */     boolean first = true;
/* 166 */     for (Iterator it = precedenceDefs.values().iterator(); it.hasNext(); )
/*     */     {
/* 168 */       PrecedenceDef precedenceDef = (PrecedenceDef)it.next();
/* 169 */       PrecedenceDefEntry[] entries = precedenceDef.getEntries();
/*     */ 
/* 171 */       if (first)
/*     */       {
/* 174 */         for (int i = 0; i < entries.length; i++)
/*     */         {
/* 176 */           overall.add(entries[i]);
/*     */         }
/* 178 */         first = false;
/* 179 */         continue;
/*     */       }
/*     */ 
/* 182 */       overall = mergePrecedenceDef(overall, precedenceDef);
/*     */     }
/*     */ 
/* 185 */     return (PrecedenceDefEntry[])(PrecedenceDefEntry[])overall.toArray(new PrecedenceDefEntry[overall.size()]);
/*     */   }
/*     */ 
/*     */   public static ArrayList mergePrecedenceDef(ArrayList overall, PrecedenceDef precedenceDef)
/*     */   {
/* 200 */     PrecedenceDefEntry[] entries = precedenceDef.getEntries();
/* 201 */     int start = 0; int end = 0;
/* 202 */     int size = overall.size();
/* 203 */     for (int i = 0; i < size; i++)
/*     */     {
/* 205 */       PrecedenceDefEntry global = (PrecedenceDefEntry)overall.get(i);
/* 206 */       boolean found = false;
/*     */ 
/* 209 */       for (int j = start; j < entries.length; j++)
/*     */       {
/* 211 */         PrecedenceDefEntry cur = entries[j];
/*     */ 
/* 213 */         if (!cur.equals(global))
/*     */           continue;
/* 215 */         found = true;
/* 216 */         end = j;
/* 217 */         break;
/*     */       }
/*     */ 
/* 223 */       if (!found)
/*     */         continue;
/* 225 */       int insert = i;
/* 226 */       for (int j = start; j < end; j++)
/*     */       {
/* 228 */         overall.add(insert++, entries[j]);
/*     */       }
/* 230 */       end++;
/* 231 */       start = end;
/*     */     }
/*     */ 
/* 235 */     for (int j = start; j < entries.length; j++)
/*     */     {
/* 237 */       overall.add(entries[j]);
/*     */     }
/*     */ 
/* 240 */     return overall;
/*     */   }
/*     */ 
/*     */   public static Interceptor[] applyPrecedence(Interceptor[] interceptors, AspectManager manager)
/*     */   {
/* 245 */     if (interceptors.length == 0) {
/* 246 */       return interceptors;
/*     */     }
/* 248 */     ArrayList all = new ArrayList(interceptors.length);
/* 249 */     ArrayList precedence = new ArrayList(interceptors.length);
/* 250 */     PrecedenceDefEntry[] precedenceEntries = manager.getSortedPrecedenceDefEntries();
/*     */ 
/* 253 */     for (int i = 0; i < interceptors.length; i++)
/*     */     {
/* 255 */       InterceptorEntry interceptorEntry = new InterceptorEntry(interceptors[i]);
/* 256 */       all.add(interceptorEntry);
/* 257 */       for (int j = 0; j < precedenceEntries.length; j++)
/*     */       {
/* 259 */         if (!matches(interceptorEntry, precedenceEntries[j])) {
/*     */           continue;
/*     */         }
/* 262 */         interceptorEntry.originalOrder = i;
/* 263 */         interceptorEntry.precedenceOrder = j;
/* 264 */         precedence.add(interceptorEntry);
/* 265 */         break;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 271 */     Collections.sort(precedence, interceptorComparator);
/* 272 */     Interceptor[] sortedInterceptors = new Interceptor[interceptors.length];
/*     */ 
/* 275 */     int prec = 0;
/* 276 */     int allSize = all.size();
/* 277 */     int precedenceSize = precedence.size();
/*     */ 
/* 279 */     for (int i = 0; i < allSize; i++)
/*     */     {
/* 281 */       InterceptorEntry entry = (InterceptorEntry)all.get(i);
/*     */ 
/* 283 */       if ((entry.precedenceOrder >= 0) && (prec < precedenceSize))
/*     */       {
/* 285 */         entry = (InterceptorEntry)precedence.get(prec++);
/*     */       }
/* 287 */       sortedInterceptors[i] = entry.interceptor;
/*     */     }
/*     */ 
/* 290 */     return sortedInterceptors;
/*     */   }
/*     */ 
/*     */   public static GeneratedAdvisorInterceptor[] applyPrecedence(GeneratedAdvisorInterceptor[] interceptors, AspectManager manager)
/*     */   {
/* 295 */     ArrayList all = new ArrayList(interceptors.length);
/* 296 */     ArrayList precedence = new ArrayList(interceptors.length);
/* 297 */     PrecedenceDefEntry[] precedenceEntries = manager.getSortedPrecedenceDefEntries();
/*     */ 
/* 300 */     for (int i = 0; i < interceptors.length; i++)
/*     */     {
/* 302 */       InterceptorEntry interceptorEntry = new InterceptorEntry(interceptors[i]);
/* 303 */       all.add(interceptorEntry);
/* 304 */       for (int j = 0; j < precedenceEntries.length; j++)
/*     */       {
/* 306 */         if (!matches(interceptorEntry, precedenceEntries[j])) {
/*     */           continue;
/*     */         }
/* 309 */         interceptorEntry.originalOrder = i;
/* 310 */         interceptorEntry.precedenceOrder = j;
/* 311 */         precedence.add(interceptorEntry);
/* 312 */         break;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 318 */     Collections.sort(precedence, interceptorComparator);
/* 319 */     GeneratedAdvisorInterceptor[] sortedInterceptors = new GeneratedAdvisorInterceptor[interceptors.length];
/*     */ 
/* 322 */     int prec = 0;
/* 323 */     int allSize = all.size();
/* 324 */     int precedenceSize = precedence.size();
/*     */ 
/* 326 */     for (int i = 0; i < allSize; i++)
/*     */     {
/* 328 */       InterceptorEntry entry = (InterceptorEntry)all.get(i);
/*     */ 
/* 330 */       if ((entry.precedenceOrder >= 0) && (prec < precedenceSize))
/*     */       {
/* 332 */         entry = (InterceptorEntry)precedence.get(prec++);
/*     */       }
/* 334 */       sortedInterceptors[i] = entry.factoryWrapper;
/*     */     }
/*     */ 
/* 337 */     return sortedInterceptors;
/*     */   }
/*     */ 
/*     */   static class InterceptorEntry
/*     */   {
/*     */     Interceptor interceptor;
/*     */     GeneratedAdvisorInterceptor factoryWrapper;
/*     */     int originalOrder;
/*  55 */     int precedenceOrder = -1;
/*     */     String classname;
/*     */     String method;
/*     */ 
/*     */     InterceptorEntry(GeneratedAdvisorInterceptor factoryWrapper)
/*     */     {
/*  61 */       this.factoryWrapper = factoryWrapper;
/*  62 */       this.classname = factoryWrapper.getName();
/*     */ 
/*  64 */       InterceptorFactory ifac = factoryWrapper.getDelegate();
/*     */ 
/*  66 */       if ((ifac instanceof GenericInterceptorFactory))
/*     */       {
/*  69 */         this.classname = ((GenericInterceptorFactory)ifac).getClassName();
/*     */       }
/*     */       else
/*     */       {
/*  73 */         AspectFactory af = factoryWrapper.getAspect().getFactory();
/*  74 */         this.classname = af.getName();
/*     */       }
/*     */ 
/*  77 */       if ((ifac instanceof AdviceFactory))
/*     */       {
/*  79 */         this.method = ((AdviceFactory)ifac).getAdvice();
/*     */       }
/*     */     }
/*     */ 
/*     */     InterceptorEntry(Interceptor interceptor)
/*     */     {
/*  86 */       this.interceptor = interceptor;
/*     */ 
/*  88 */       String interceptorName = null;
/*  89 */       if ((interceptor instanceof PerInstanceInterceptor))
/*     */       {
/*  91 */         PerInstanceInterceptor icptr = (PerInstanceInterceptor)interceptor;
/*  92 */         interceptorName = icptr.getName();
/*     */       }
/*  94 */       else if ((interceptor instanceof PerJoinpointInterceptor))
/*     */       {
/*  96 */         PerJoinpointInterceptor icptr = (PerJoinpointInterceptor)interceptor;
/*  97 */         interceptorName = icptr.getName();
/*     */       }
/*  99 */       else if ((interceptor instanceof CFlowInterceptor))
/*     */       {
/* 101 */         CFlowInterceptor icptr = (CFlowInterceptor)interceptor;
/* 102 */         interceptorName = icptr.getName();
/*     */       }
/*     */       else
/*     */       {
/* 106 */         interceptorName = interceptor.getClass().getName();
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 111 */         boolean isAdvice = interceptorName.startsWith("org.jboss.aop.advice.");
/* 112 */         if (isAdvice)
/*     */         {
/* 114 */           String name = interceptor.getName();
/* 115 */           int index = name.lastIndexOf(".");
/* 116 */           this.classname = name.substring(0, index);
/* 117 */           this.method = name.substring(index + 1);
/*     */         }
/*     */         else
/*     */         {
/* 121 */           this.classname = interceptorName;
/*     */         }
/*     */       }
/*     */       catch (RuntimeException e)
/*     */       {
/* 126 */         System.err.print(interceptor.getName());
/* 127 */         throw e;
/*     */       }
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 133 */       return "Entry: " + this.precedenceOrder + " (" + this.originalOrder + ")interceptorClass=" + this.classname + "; adviceMethod=" + this.method;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.PrecedenceSorter
 * JD-Core Version:    0.6.0
 */