/*     */ package org.jboss.aop.advice;
/*     */ 
/*     */ import org.jboss.aop.Advised;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.joinpoint.CallerInvocation;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.proxy.container.AspectManaged;
/*     */ import org.jboss.aop.proxy.container.ClassProxyContainer;
/*     */ import org.jboss.aop.proxy.container.ContainerProxyMethodInvocation;
/*     */ 
/*     */ public class PerInstanceInterceptor
/*     */   implements Interceptor
/*     */ {
/*     */   AspectDefinition aspectDefinition;
/*     */ 
/*     */   public PerInstanceInterceptor(AspectDefinition a, Advisor advisor)
/*     */   {
/*  44 */     this.aspectDefinition = a;
/*  45 */     advisor.addPerInstanceAspect(a);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  50 */     return this.aspectDefinition.getName();
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation) throws Throwable
/*     */   {
/*  55 */     if ((invocation instanceof CallerInvocation))
/*     */     {
/*  59 */       Object callingObject = ((CallerInvocation)invocation).getCallingObject();
/*     */ 
/*  61 */       if (callingObject == null) return invocation.invokeNext();
/*     */ 
/*  63 */       Advised advised = (Advised)callingObject;
/*  64 */       InstanceAdvisor advisor = advised._getInstanceAdvisor();
/*  65 */       Interceptor interceptor = (Interceptor)advisor.getPerInstanceAspect(this.aspectDefinition);
/*  66 */       return interceptor.invoke(invocation);
/*     */     }
/*     */ 
/*  71 */     Object targetObject = invocation.getTargetObject();
/*  72 */     if (targetObject == null) return invocation.invokeNext();
/*     */ 
/*  74 */     InstanceAdvisor instanceAdvisor = null;
/*  75 */     if ((targetObject instanceof Advised))
/*     */     {
/*  77 */       Advised advised = (Advised)targetObject;
/*  78 */       instanceAdvisor = advised._getInstanceAdvisor();
/*     */     }
/*     */     else
/*     */     {
/*  82 */       Advisor advisor = invocation.getAdvisor();
/*  83 */       if (advisor == null)
/*     */       {
/*  85 */         return invocation.invokeNext();
/*     */       }
/*     */ 
/*  88 */       if ((advisor instanceof InstanceAdvisor))
/*     */       {
/*  90 */         instanceAdvisor = (InstanceAdvisor)advisor;
/*     */       }
/*  94 */       else if (((advisor instanceof ClassProxyContainer)) && ((invocation instanceof ContainerProxyMethodInvocation)))
/*     */       {
/*  96 */         ContainerProxyMethodInvocation pi = (ContainerProxyMethodInvocation)invocation;
/*  97 */         instanceAdvisor = pi.getProxy().getInstanceAdvisor();
/*     */       }
/*     */       else
/*     */       {
/* 101 */         return invocation.invokeNext();
/*     */       }
/*     */     }
/*     */ 
/* 105 */     Interceptor interceptor = (Interceptor)instanceAdvisor.getPerInstanceAspect(this.aspectDefinition);
/* 106 */     return interceptor.invoke(invocation);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.PerInstanceInterceptor
 * JD-Core Version:    0.6.0
 */