/*     */ package org.jboss.aop.advice;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.aop.Advised;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.joinpoint.CallerInvocation;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.proxy.container.AspectManaged;
/*     */ import org.jboss.aop.proxy.container.ClassProxyContainer;
/*     */ import org.jboss.aop.proxy.container.ContainerProxyMethodInvocation;
/*     */ 
/*     */ public class PerInstanceAdvice extends AbstractAdvice
/*     */ {
/*  44 */   private boolean initialized = false;
/*     */   AspectDefinition aspectDefinition;
/*     */ 
/*     */   public PerInstanceAdvice(String adviceName, AspectDefinition a, Advisor advisor)
/*     */   {
/*  49 */     this.aspectDefinition = a;
/*  50 */     this.adviceName = adviceName;
/*  51 */     advisor.addPerInstanceAspect(a);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  56 */     return this.aspectDefinition.getName() + "." + this.adviceName;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation) throws Throwable
/*     */   {
/*  61 */     Object aspect = null;
/*  62 */     if ((invocation instanceof CallerInvocation))
/*     */     {
/*  66 */       Object callingObject = ((CallerInvocation)invocation).getCallingObject();
/*     */ 
/*  68 */       if (callingObject == null) return invocation.invokeNext();
/*     */ 
/*  70 */       Advised advised = (Advised)callingObject;
/*  71 */       InstanceAdvisor advisor = advised._getInstanceAdvisor();
/*  72 */       aspect = advisor.getPerInstanceAspect(this.aspectDefinition);
/*     */     }
/*     */     else
/*     */     {
/*  76 */       Object targetObject = invocation.getTargetObject();
/*  77 */       if (targetObject == null) return invocation.invokeNext();
/*     */ 
/*  79 */       InstanceAdvisor instanceAdvisor = null;
/*  80 */       if ((targetObject instanceof Advised))
/*     */       {
/*  82 */         Advised advised = (Advised)targetObject;
/*  83 */         instanceAdvisor = advised._getInstanceAdvisor();
/*     */       }
/*     */       else
/*     */       {
/*  87 */         Advisor advisor = invocation.getAdvisor();
/*  88 */         if (advisor == null)
/*     */         {
/*  90 */           return invocation.invokeNext();
/*     */         }
/*  92 */         if ((advisor instanceof InstanceAdvisor))
/*     */         {
/*  94 */           instanceAdvisor = (InstanceAdvisor)advisor;
/*     */         }
/*  96 */         else if (((advisor instanceof ClassProxyContainer)) && ((invocation instanceof ContainerProxyMethodInvocation)))
/*     */         {
/*  98 */           ContainerProxyMethodInvocation pi = (ContainerProxyMethodInvocation)invocation;
/*  99 */           instanceAdvisor = pi.getProxy().getInstanceAdvisor();
/*     */         }
/*     */         else
/*     */         {
/* 103 */           return invocation.invokeNext();
/*     */         }
/*     */       }
/* 106 */       aspect = instanceAdvisor.getPerInstanceAspect(this.aspectDefinition);
/*     */     }
/*     */ 
/* 109 */     if (!this.initialized)
/*     */     {
/* 111 */       init(this.adviceName, aspect.getClass());
/* 112 */       this.initialized = true;
/*     */     }
/* 114 */     Method advice = resolveAdvice(invocation);
/* 115 */     Object[] args = { invocation };
/*     */     try
/*     */     {
/* 119 */       return advice.invoke(aspect, args);
/*     */     }
/*     */     catch (InvocationTargetException e) {
/*     */     }
/* 123 */     throw e.getCause();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.PerInstanceAdvice
 * JD-Core Version:    0.6.0
 */