/*     */ package org.jboss.aop.advice;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.util.xml.XmlLoadable;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class GenericInterceptorFactory
/*     */   implements InterceptorFactory
/*     */ {
/*  33 */   private WeakReference<Class> classRef = null;
/*     */   private String classname;
/*     */   private Element element;
/*  36 */   private boolean deployed = true;
/*     */   private String name;
/*  39 */   private static volatile int counter = 0;
/*     */ 
/*     */   public GenericInterceptorFactory(String classname, Element element)
/*     */   {
/*  43 */     this.name = (classname + counter++);
/*  44 */     this.classname = classname;
/*  45 */     this.element = element;
/*     */   }
/*     */ 
/*     */   public GenericInterceptorFactory(Class clazz)
/*     */   {
/*  50 */     this.classRef = new WeakReference(clazz);
/*  51 */     this.classname = clazz.getName();
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  56 */     return this.name;
/*     */   }
/*     */ 
/*     */   public AspectDefinition getAspect()
/*     */   {
/*  61 */     return null;
/*     */   }
/*     */ 
/*     */   public String getAdvice()
/*     */   {
/*  66 */     return "invoke";
/*     */   }
/*  68 */   public void undeploy() { this.deployed = false; }
/*     */ 
/*     */   public boolean isDeployed()
/*     */   {
/*  72 */     return this.deployed;
/*     */   }
/*     */   public String getClassName() {
/*  75 */     return this.classname;
/*     */   }
/*     */ 
/*     */   public Interceptor create(Advisor advisor, Joinpoint joinpoint)
/*     */   {
/*     */     try {
/*  81 */       Class clazz = null;
/*  82 */       synchronized (this)
/*     */       {
/*  84 */         if (this.classRef != null)
/*     */         {
/*  86 */           clazz = (Class)this.classRef.get();
/*     */         }
/*  88 */         if (clazz != null)
/*     */         {
/*  91 */           clazz = SecurityActions.getContextClassLoader().loadClass(this.classname);
/*  92 */           this.classRef = new WeakReference(clazz);
/*     */         }
/*     */       }
/*  95 */       Interceptor interceptor = (Interceptor)clazz.newInstance();
/*  96 */       if (((interceptor instanceof XmlLoadable)) && (this.element != null))
/*     */       {
/*  98 */         ((XmlLoadable)interceptor).importXml(this.element);
/*     */       }
/* 100 */       return interceptor;
/*     */     }
/*     */     catch (Exception re)
/*     */     {
/* 104 */       if ((re instanceof RuntimeException)) throw ((RuntimeException)re); 
/*     */     }
/* 105 */     throw new RuntimeException(re);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 111 */     if (this == obj) return true;
/* 112 */     if (!(obj instanceof GenericInterceptorFactory)) return false;
/* 113 */     return this.classname.equals(((GenericInterceptorFactory)obj).classname);
/*     */   }
/*     */ 
/*     */   public AdviceType getType()
/*     */   {
/* 120 */     return AdviceType.AROUND;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.GenericInterceptorFactory
 * JD-Core Version:    0.6.0
 */