/*     */ package org.jboss.aop.advice;
/*     */ 
/*     */ import java.beans.BeanInfo;
/*     */ import java.beans.IntrospectionException;
/*     */ import java.beans.Introspector;
/*     */ import java.beans.PropertyDescriptor;
/*     */ import java.beans.PropertyEditor;
/*     */ import java.beans.PropertyEditorManager;
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.aop.util.logging.AOPLogger;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class GenericAspectFactory extends AspectFactoryWithClassLoaderSupport
/*     */ {
/*  49 */   private static final Logger logger = AOPLogger.getLogger(GenericAspectFactory.class);
/*     */ 
/*  51 */   static final Class[] ADVISOR_INJECTOR_SIGNATURE = { Advisor.class };
/*  52 */   static final Class[] INSTANCE_ADVISOR_INJECTOR_SIGNATURE = { InstanceAdvisor.class };
/*  53 */   static final Class[] JOINPOINT_INJECTOR_SIGNATURE = { Joinpoint.class };
/*     */   private String classname;
/*     */   private Element element;
/*     */ 
/*     */   public GenericAspectFactory(String classname, Element element)
/*     */   {
/*  60 */     this.classname = classname;
/*  61 */     this.element = element;
/*     */   }
/*     */ 
/*     */   public String getClassname()
/*     */   {
/*  76 */     return this.classname;
/*     */   }
/*     */ 
/*     */   public void setClassname(String classname)
/*     */   {
/*  81 */     this.classname = classname;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  86 */     return this.classname;
/*     */   }
/*     */ 
/*     */   public Element getElement()
/*     */   {
/*  91 */     return this.element;
/*     */   }
/*     */ 
/*     */   public void setElement(Element element)
/*     */   {
/*  96 */     this.element = element;
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   public Class getClazz()
/*     */   {
/*     */     try
/*     */     {
/* 107 */       return loadClass(this.classname);
/*     */     }
/*     */     catch (ClassNotFoundException e) {
/*     */     }
/* 111 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   private Class getClazz(Advisor advisor)
/*     */   {
/*     */     try
/*     */     {
/* 119 */       ClassLoader cl = null;
/* 120 */       if (advisor != null)
/*     */       {
/* 123 */         clazz = advisor.getClazz();
/* 124 */         cl = clazz != null ? clazz.getClassLoader() : advisor.getClass().getClassLoader();
/*     */       }
/* 126 */       if (cl != null)
/*     */       {
/* 128 */         pushScopedClassLoader(cl);
/*     */       }
/* 130 */       Class clazz = loadClass(this.classname);
/*     */       return clazz;
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 134 */       throw new RuntimeException(e);
/*     */     }
/*     */     finally
/*     */     {
/* 138 */       popScopedClassLoader(); } throw localObject;
/*     */   }
/*     */ 
/*     */   public Object createPerVM()
/*     */   {
/*     */     try
/*     */     {
/* 146 */       Object aspect = getClazz(null).newInstance();
/* 147 */       configureInstance(aspect, null, null, null);
/* 148 */       return aspect;
/*     */     }
/*     */     catch (Exception re)
/*     */     {
/* 152 */       if ((re instanceof RuntimeException)) throw ((RuntimeException)re); 
/*     */     }
/* 153 */     throw new RuntimeException(re);
/*     */   }
/*     */ 
/*     */   public Object createPerClass(Advisor advisor)
/*     */   {
/*     */     try
/*     */     {
/* 161 */       Object aspect = getClazz(advisor).newInstance();
/* 162 */       configureInstance(aspect, advisor, null, null);
/* 163 */       return aspect;
/*     */     }
/*     */     catch (Exception re)
/*     */     {
/* 167 */       if ((re instanceof RuntimeException)) throw ((RuntimeException)re); 
/*     */     }
/* 168 */     throw new RuntimeException(re);
/*     */   }
/*     */ 
/*     */   public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor)
/*     */   {
/*     */     try
/*     */     {
/* 176 */       Object aspect = getClazz(advisor).newInstance();
/* 177 */       configureInstance(aspect, advisor, instanceAdvisor, null);
/* 178 */       return aspect;
/*     */     }
/*     */     catch (Exception re)
/*     */     {
/* 182 */       if ((re instanceof RuntimeException)) throw ((RuntimeException)re); 
/*     */     }
/* 183 */     throw new RuntimeException(re);
/*     */   }
/*     */ 
/*     */   public Object createPerJoinpoint(Advisor advisor, Joinpoint jp)
/*     */   {
/*     */     try
/*     */     {
/* 191 */       Object aspect = getClazz(advisor).newInstance();
/* 192 */       configureInstance(aspect, advisor, null, jp);
/* 193 */       return aspect;
/*     */     }
/*     */     catch (Exception re)
/*     */     {
/* 197 */       if ((re instanceof RuntimeException)) throw ((RuntimeException)re); 
/*     */     }
/* 198 */     throw new RuntimeException(re);
/*     */   }
/*     */ 
/*     */   public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp)
/*     */   {
/*     */     try
/*     */     {
/* 206 */       Object aspect = getClazz(advisor).newInstance();
/* 207 */       configureInstance(aspect, advisor, instanceAdvisor, jp);
/* 208 */       return aspect;
/*     */     }
/*     */     catch (Exception re)
/*     */     {
/* 212 */       if ((re instanceof RuntimeException)) throw ((RuntimeException)re); 
/*     */     }
/* 213 */     throw new RuntimeException(re);
/*     */   }
/*     */ 
/*     */   protected void configureInstance(Object instance, Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp)
/*     */   {
/* 219 */     if (this.element == null) return;
/* 220 */     BeanInfo beanInfo = null;
/*     */     try
/*     */     {
/* 223 */       beanInfo = Introspector.getBeanInfo(instance.getClass());
/*     */     }
/*     */     catch (IntrospectionException e)
/*     */     {
/* 227 */       throw new RuntimeException(e.getMessage(), e);
/*     */     }
/* 229 */     PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
/* 230 */     if (descriptors == null)
/*     */     {
/* 232 */       descriptors = new PropertyDescriptor[0];
/*     */     }
/*     */ 
/* 235 */     NodeList children = this.element.getChildNodes();
/*     */ 
/* 237 */     for (int i = 0; i < children.getLength(); i++)
/*     */     {
/* 239 */       if (children.item(i).getNodeType() != 1)
/*     */         continue;
/* 241 */       Element element = (Element)children.item(i);
/* 242 */       String tagname = element.getTagName();
/*     */ 
/* 244 */       String attributeName = element.getAttribute("name");
/*     */ 
/* 246 */       if (tagname.equals("attribute"))
/*     */       {
/* 248 */         String attributeText = element.getFirstChild().getNodeValue();
/* 249 */         setAttribute(instance, descriptors, attributeName, attributeText);
/*     */       }
/* 251 */       else if (tagname.equals("advisor-attribute"))
/*     */       {
/* 253 */         injectAdvisor(instance, advisor, attributeName);
/*     */       }
/* 255 */       else if (tagname.equals("joinpoint-attribute"))
/*     */       {
/* 257 */         injectJoinpoint(instance, jp, attributeName);
/*     */       } else {
/* 259 */         if (!tagname.equals("instance-advisor-attribute"))
/*     */           continue;
/* 261 */         injectInstanceAdvisor(instance, instanceAdvisor, attributeName);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setAttribute(Object instance, PropertyDescriptor[] descriptors, String attributeName, String attributeText)
/*     */   {
/* 269 */     boolean foundProperty = false;
/*     */ 
/* 271 */     for (int i = 0; i < descriptors.length; i++)
/*     */     {
/* 273 */       if (!attributeName.equalsIgnoreCase(descriptors[i].getName()))
/*     */         continue;
/* 275 */       foundProperty = true;
/* 276 */       Class typeClass = descriptors[i].getPropertyType();
/*     */ 
/* 279 */       PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
/* 280 */       if (editor == null)
/*     */       {
/* 282 */         throw new RuntimeException("No property editor for attribute: " + attributeName + "; type=" + typeClass + " in " + this.classname);
/*     */       }
/*     */ 
/* 287 */       editor.setAsText(attributeText);
/* 288 */       Object value = editor.getValue();
/*     */       try
/*     */       {
/* 291 */         descriptors[i].getWriteMethod().invoke(instance, new Object[] { value });
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 295 */         throw new RuntimeException("Error setting attribute '" + attributeName + "' in " + this.classname, e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 302 */     if (!foundProperty)
/*     */     {
/* 304 */       throw new RuntimeException("Could not find attribute '" + attributeName + "' in aspect/interceptor class " + this.classname);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void injectAdvisor(Object instance, Advisor advisor, String attributeName)
/*     */   {
/* 311 */     if (advisor == null)
/*     */     {
/* 313 */       if ((AspectManager.verbose) && (logger.isDebugEnabled()))
/*     */       {
/* 315 */         logger.debug("Ignoring attempt to set advisor attribute on PER_VM scoped aspect/interceptor: " + this.classname);
/*     */       }
/* 317 */       return;
/*     */     }
/*     */ 
/* 320 */     String injector = getInjectorName(attributeName);
/*     */     try
/*     */     {
/* 323 */       Method m = instance.getClass().getMethod(injector, ADVISOR_INJECTOR_SIGNATURE);
/* 324 */       m.invoke(instance, new Object[] { advisor });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 328 */       throw new RuntimeException("Aspect/interceptor " + this.classname + " does not contain a public org.jboss.aop.Advisor injector called " + injector);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void injectJoinpoint(Object instance, Joinpoint jp, String attributeName)
/*     */   {
/* 334 */     if (jp == null)
/*     */     {
/* 336 */       if ((AspectManager.verbose) && (logger.isDebugEnabled()))
/*     */       {
/* 338 */         logger.debug("Ignoring attempt to set joinpoint attribute on aspect/interceptor: " + this.classname + " which is not scoped PER_JOINPOINT");
/*     */       }
/* 340 */       return;
/*     */     }
/*     */ 
/* 343 */     String injector = getInjectorName(attributeName);
/*     */     try
/*     */     {
/* 346 */       Method m = instance.getClass().getMethod(injector, JOINPOINT_INJECTOR_SIGNATURE);
/* 347 */       m.invoke(instance, new Object[] { jp });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 351 */       throw new RuntimeException("Aspect/interceptor " + this.classname + " does not contain a public org.jboss.aop.Joinpoint injector called " + injector);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void injectInstanceAdvisor(Object instance, InstanceAdvisor instanceAdvisor, String attributeName)
/*     */   {
/* 357 */     if (instanceAdvisor == null)
/*     */     {
/* 359 */       if ((AspectManager.verbose) && (logger.isDebugEnabled()))
/*     */       {
/* 361 */         logger.debug("Ignoring attempt to set instance advisor attribute on aspect/interceptor: " + this.classname + " which is not scoped PER_INSTANCE or PER_JOINPOINT");
/*     */       }
/* 363 */       return;
/*     */     }
/*     */ 
/* 366 */     String injector = getInjectorName(attributeName);
/*     */     try
/*     */     {
/* 369 */       Method m = instance.getClass().getMethod(injector, INSTANCE_ADVISOR_INJECTOR_SIGNATURE);
/* 370 */       m.invoke(instance, new Object[] { instanceAdvisor });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 374 */       throw new RuntimeException("Aspect/interceptor " + this.classname + " does not contain a public org.jboss.aop.InstanceAdvisor injector called " + injector);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected String getInjectorName(String attributeName)
/*     */   {
/* 381 */     char firstChar = attributeName.charAt(0);
/* 382 */     if (Character.isLowerCase(firstChar))
/*     */     {
/* 384 */       attributeName = Character.toUpperCase(firstChar) + attributeName.substring(1);
/*     */     }
/*     */ 
/* 387 */     return "set" + attributeName;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  70 */     SecurityActions.initEditors();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.GenericAspectFactory
 * JD-Core Version:    0.6.0
 */