/*     */ package org.jboss.aop.advice;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.Set;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.ClassInstanceAdvisor;
/*     */ import org.jboss.aop.GeneratedClassAdvisor;
/*     */ import org.jboss.aop.GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.joinpoint.ConstructionInvocation;
/*     */ import org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation;
/*     */ import org.jboss.aop.joinpoint.ConstructorCalledByConstructorJoinpoint;
/*     */ import org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation;
/*     */ import org.jboss.aop.joinpoint.ConstructorCalledByMethodJoinpoint;
/*     */ import org.jboss.aop.joinpoint.ConstructorInvocation;
/*     */ import org.jboss.aop.joinpoint.ConstructorJoinpoint;
/*     */ import org.jboss.aop.joinpoint.FieldInvocation;
/*     */ import org.jboss.aop.joinpoint.FieldJoinpoint;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation;
/*     */ import org.jboss.aop.joinpoint.MethodCalledByConstructorJoinpoint;
/*     */ import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
/*     */ import org.jboss.aop.joinpoint.MethodCalledByMethodJoinpoint;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.aop.joinpoint.MethodJoinpoint;
/*     */ import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
/*     */ import org.jboss.aop.util.logging.AOPLogger;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class GeneratedAdvisorInterceptor
/*     */   implements Interceptor
/*     */ {
/*  69 */   private static final Logger logger = AOPLogger.getLogger(GeneratedAdvisorInterceptor.class);
/*     */   private InterceptorFactory factory;
/*     */   private volatile Object instance;
/*     */   private String cflowString;
/*     */   private ASTCFlowExpression cflowExpression;
/*     */   volatile Interceptor lazyInterceptor;
/*     */   String adviceString;
/*     */ 
/*     */   public GeneratedAdvisorInterceptor(InterceptorFactory factory, GeneratedClassAdvisor advisor, Joinpoint joinpoint, String cflowString, ASTCFlowExpression cflowExpr)
/*     */   {
/*  87 */     this(factory, advisor, joinpoint);
/*  88 */     this.cflowString = cflowString;
/*  89 */     this.cflowExpression = cflowExpr;
/*     */   }
/*     */ 
/*     */   public GeneratedAdvisorInterceptor(InterceptorFactory factory, GeneratedClassAdvisor advisor, Joinpoint joinpoint)
/*     */   {
/*  94 */     this.factory = factory;
/*     */ 
/*  96 */     if (!(factory instanceof GenericInterceptorFactory))
/*     */     {
/*  98 */       if (getScope() == Scope.PER_INSTANCE)
/*     */       {
/* 100 */         if (!advisor.getPerInstanceAspectDefinitions().contains(factory.getAspect()))
/*     */         {
/* 102 */           advisor.addPerInstanceAspect(factory.getAspect());
/*     */         }
/*     */       }
/* 105 */       else if (getScope() == Scope.PER_JOINPOINT)
/*     */       {
/* 107 */         advisor.addPerInstanceJoinpointAspect(joinpoint, factory.getAspect());
/*     */       }
/* 109 */       else if (getScope() == Scope.PER_CLASS_JOINPOINT)
/*     */       {
/* 111 */         if (advisor.getPerClassJoinpointAspect(factory.getAspect(), joinpoint) == null)
/*     */         {
/* 113 */           advisor.addPerClassJoinpointAspect(factory.getAspect(), joinpoint);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Interceptor create(Advisor advisor, Joinpoint joinpoint)
/*     */   {
/* 121 */     return this.factory.create(advisor, joinpoint);
/*     */   }
/*     */ 
/*     */   public Object getAspect(Advisor advisor, Joinpoint joinpoint)
/*     */   {
/* 129 */     return getAspect(advisor, joinpoint, false);
/*     */   }
/*     */ 
/*     */   public Object getAspect(Advisor advisor, Joinpoint joinpoint, boolean forCodeGeneration)
/*     */   {
/* 142 */     if ((this.factory instanceof GenericInterceptorFactory))
/*     */     {
/* 144 */       if (this.instance == null)
/*     */       {
/* 146 */         this.instance = ((GenericInterceptorFactory)this.factory).create(advisor, joinpoint);
/*     */       }
/* 148 */       return this.instance;
/*     */     }
/* 150 */     if ((this.factory instanceof GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory))
/*     */     {
/* 152 */       return ((GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory)this.factory).create(advisor, joinpoint);
/*     */     }
/* 154 */     if (((this.factory instanceof ScopedInterceptorFactory)) || ((this.factory instanceof AdviceFactory)))
/*     */     {
/* 156 */       ClassInstanceAdvisor temp = forCodeGeneration ? new ClassInstanceAdvisor(advisor) : null;
/* 157 */       return getAspectInstance(this.factory.getAspect(), advisor, joinpoint, temp);
/*     */     }
/*     */ 
/* 160 */     return null;
/*     */   }
/*     */ 
/*     */   public Object getPerInstanceAspect(Advisor advisor, Joinpoint joinpoint, InstanceAdvisor ia)
/*     */   {
/* 168 */     if ((this.factory instanceof GenericInterceptorFactory))
/*     */     {
/* 170 */       if (this.instance == null)
/*     */       {
/* 172 */         this.instance = ((GenericInterceptorFactory)this.factory).create(advisor, joinpoint);
/*     */       }
/* 174 */       return this.instance;
/*     */     }
/* 176 */     if (((this.factory instanceof ScopedInterceptorFactory)) || ((this.factory instanceof AdviceFactory)))
/*     */     {
/* 178 */       return getAspectInstance(this.factory.getAspect(), advisor, joinpoint, ia);
/*     */     }
/*     */ 
/* 181 */     return null;
/*     */   }
/*     */ 
/*     */   private Object getAspectInstance(AspectDefinition def, Advisor advisor, Joinpoint joinpoint, InstanceAdvisor ia)
/*     */   {
/* 186 */     Scope scope = def.getScope();
/* 187 */     if (scope == Scope.PER_VM)
/*     */     {
/* 189 */       if (this.instance == null)
/*     */       {
/* 191 */         this.instance = advisor.getPerVMAspect(def);
/*     */       }
/* 193 */       return this.instance;
/*     */     }
/* 195 */     if (scope == Scope.PER_CLASS)
/*     */     {
/* 197 */       if (this.instance == null)
/*     */       {
/* 199 */         this.instance = advisor.getPerClassAspect(def);
/* 200 */         if (this.instance != null)
/*     */         {
/* 202 */           return this.instance;
/*     */         }
/* 204 */         advisor.addPerClassAspect(def);
/* 205 */         this.instance = advisor.getPerClassAspect(def);
/*     */       }
/* 207 */       return this.instance;
/*     */     }
/* 209 */     if (scope == Scope.PER_INSTANCE)
/*     */     {
/* 211 */       return getPerInstanceAspect(def, advisor, joinpoint, ia);
/*     */     }
/* 213 */     if (scope == Scope.PER_JOINPOINT)
/*     */     {
/* 215 */       return getPerJoinPointAspect(def, advisor, joinpoint, ia);
/*     */     }
/* 217 */     if (scope == Scope.PER_CLASS_JOINPOINT)
/*     */     {
/* 219 */       if (this.instance == null)
/*     */       {
/* 221 */         this.instance = ((GeneratedClassAdvisor)advisor).getPerClassJoinpointAspect(def, joinpoint);
/* 222 */         if (this.instance != null)
/*     */         {
/* 224 */           return this.instance;
/*     */         }
/*     */ 
/* 227 */         ((GeneratedClassAdvisor)advisor).addPerClassJoinpointAspect(def, joinpoint);
/* 228 */         this.instance = ((GeneratedClassAdvisor)advisor).getPerClassJoinpointAspect(def, joinpoint);
/*     */       }
/* 230 */       return this.instance;
/*     */     }
/*     */ 
/* 236 */     return null;
/*     */   }
/*     */ 
/*     */   private Object getPerJoinPointAspect(AspectDefinition def, Advisor advisor, Joinpoint joinpoint, InstanceAdvisor ia)
/*     */   {
/* 241 */     if (ia == null)
/*     */     {
/* 243 */       if (this.instance == null)
/*     */       {
/* 246 */         if ((AspectManager.verbose) && (logger.isDebugEnabled()))
/*     */         {
/* 248 */           logger.debug("Calling create on PER_JOINPOINT scoped AspectFactory with no InstanceAdvisor as part of setup");
/*     */         }
/*     */ 
/* 251 */         if ((joinpoint instanceof FieldJoinpoint))
/*     */         {
/* 253 */           Field field = ((FieldJoinpoint)joinpoint).getField();
/* 254 */           if (Modifier.isStatic(field.getModifiers()))
/*     */           {
/* 256 */             this.instance = ((ClassAdvisor)advisor).getFieldAspect((FieldJoinpoint)joinpoint, def);
/*     */           }
/*     */         }
/*     */ 
/* 260 */         if (this.instance == null)
/*     */         {
/* 262 */           this.instance = ((GeneratedClassAdvisor)advisor).getPerClassJoinpointAspect(def, joinpoint);
/* 263 */           if (this.instance != null)
/*     */           {
/* 265 */             return this.instance;
/*     */           }
/*     */ 
/* 268 */           ((GeneratedClassAdvisor)advisor).addPerClassJoinpointAspect(def, joinpoint);
/* 269 */           this.instance = ((GeneratedClassAdvisor)advisor).getPerClassJoinpointAspect(def, joinpoint);
/*     */         }
/*     */       }
/* 272 */       return this.instance;
/*     */     }
/*     */ 
/* 277 */     return ia.getPerInstanceJoinpointAspect(joinpoint, def);
/*     */   }
/*     */ 
/*     */   private Object getPerInstanceAspect(AspectDefinition def, Advisor advisor, Joinpoint joinpoint, InstanceAdvisor ia)
/*     */   {
/* 283 */     if (ia == null)
/*     */     {
/* 286 */       if ((AspectManager.verbose) && (logger.isDebugEnabled()))
/*     */       {
/* 288 */         logger.debug("Calling create on PER_INSTANCE scoped AspectFactory with no InstanceAdvisor as part of setup");
/*     */       }
/* 290 */       return def.getFactory().createPerInstance(advisor, ia);
/*     */     }
/*     */ 
/* 294 */     return ia.getPerInstanceAspect(def);
/*     */   }
/*     */ 
/*     */   public boolean isAspectFactory()
/*     */   {
/* 300 */     if (((this.factory instanceof GenericInterceptorFactory)) || ((this.factory instanceof GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory)))
/*     */     {
/* 302 */       return false;
/*     */     }
/*     */ 
/* 306 */     return !(this.factory.getAspect().getFactory() instanceof GenericAspectFactory);
/*     */   }
/*     */ 
/*     */   public InterceptorFactory getDelegate()
/*     */   {
/* 312 */     return this.factory;
/*     */   }
/*     */ 
/*     */   public AspectDefinition getAspect()
/*     */   {
/* 317 */     return this.factory.getAspect();
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 322 */     return this.factory.getName();
/*     */   }
/*     */ 
/*     */   public String getAspectClassName()
/*     */   {
/* 327 */     if ((this.factory instanceof GenericInterceptorFactory))
/*     */     {
/* 330 */       return ((GenericInterceptorFactory)this.factory).getClassName();
/*     */     }
/* 332 */     if ((this.factory instanceof GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory))
/*     */     {
/* 334 */       return ((GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory)this.factory).getClassName();
/*     */     }
/*     */ 
/* 338 */     AspectFactory af = this.factory.getAspect().getFactory();
/* 339 */     return af.getName();
/*     */   }
/*     */ 
/*     */   public AdviceType getType()
/*     */   {
/* 345 */     return this.factory.getType();
/*     */   }
/*     */ 
/*     */   public boolean isInterceptor()
/*     */   {
/* 352 */     return !(this.factory instanceof AdviceFactory);
/*     */   }
/*     */ 
/*     */   public String getAdviceName()
/*     */   {
/* 359 */     if ((this.factory instanceof AdviceFactory))
/*     */     {
/* 361 */       return ((AdviceFactory)this.factory).getAdvice();
/*     */     }
/*     */ 
/* 364 */     return "invoke";
/*     */   }
/*     */ 
/*     */   public Scope getScope()
/*     */   {
/* 369 */     if (((this.factory instanceof GenericInterceptorFactory)) || ((this.factory instanceof GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory)))
/*     */     {
/* 371 */       return null;
/*     */     }
/*     */ 
/* 375 */     return this.factory.getAspect().getScope();
/*     */   }
/*     */ 
/*     */   public String getRegisteredName()
/*     */   {
/* 381 */     if (((this.factory instanceof GenericInterceptorFactory)) || ((this.factory instanceof GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory)))
/*     */     {
/* 383 */       return null;
/*     */     }
/*     */ 
/* 387 */     return this.factory.getAspect().getName();
/*     */   }
/*     */ 
/*     */   public ASTCFlowExpression getCflowExpression()
/*     */   {
/* 393 */     return this.cflowExpression;
/*     */   }
/*     */ 
/*     */   public String getCFlowString()
/*     */   {
/* 398 */     return this.cflowString;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 403 */     if (!(obj instanceof GeneratedAdvisorInterceptor)) return false;
/* 404 */     return this.factory.equals(((GeneratedAdvisorInterceptor)obj).getDelegate());
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation) throws Throwable
/*     */   {
/* 409 */     if (this.lazyInterceptor == null)
/*     */     {
/* 411 */       synchronized (this)
/*     */       {
/* 413 */         if (this.lazyInterceptor == null)
/*     */         {
/* 415 */           if (this.factory.getType().isGeneratedOnly())
/*     */           {
/* 417 */             this.lazyInterceptor = new GeneratedOnlyInterceptor(this.factory.getName(), this.factory);
/*     */           }
/*     */           else
/*     */           {
/* 421 */             this.lazyInterceptor = create(invocation.getAdvisor(), getJoinpoint(invocation));
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 426 */     return this.lazyInterceptor.invoke(invocation);
/*     */   }
/*     */ 
/*     */   private Joinpoint getJoinpoint(Invocation invocation)
/*     */   {
/* 431 */     if ((invocation instanceof MethodInvocation))
/*     */     {
/* 433 */       return new MethodJoinpoint(((MethodInvocation)invocation).getMethod());
/*     */     }
/* 435 */     if ((invocation instanceof FieldInvocation))
/*     */     {
/* 437 */       return new FieldJoinpoint(((FieldInvocation)invocation).getField());
/*     */     }
/* 439 */     if ((invocation instanceof ConstructorInvocation))
/*     */     {
/* 441 */       return new ConstructorJoinpoint(((ConstructorInvocation)invocation).getConstructor());
/*     */     }
/* 443 */     if ((invocation instanceof ConstructionInvocation))
/*     */     {
/* 445 */       return new ConstructorJoinpoint(((ConstructionInvocation)invocation).getConstructor());
/*     */     }
/* 447 */     if ((invocation instanceof MethodCalledByMethodInvocation))
/*     */     {
/* 449 */       return new MethodCalledByMethodJoinpoint(((MethodCalledByMethodInvocation)invocation).getCallingMethod(), ((MethodCalledByMethodInvocation)invocation).getCalledMethod());
/*     */     }
/* 451 */     if ((invocation instanceof MethodCalledByConstructorInvocation))
/*     */     {
/* 453 */       return new MethodCalledByConstructorJoinpoint(((MethodCalledByConstructorInvocation)invocation).getCalling(), ((MethodCalledByConstructorInvocation)invocation).getCalledMethod());
/*     */     }
/* 455 */     if ((invocation instanceof ConstructorCalledByMethodInvocation))
/*     */     {
/* 457 */       return new ConstructorCalledByMethodJoinpoint(((ConstructorCalledByMethodInvocation)invocation).getCallingMethod(), ((ConstructorCalledByMethodInvocation)invocation).getCalledConstructor());
/*     */     }
/* 459 */     if ((invocation instanceof ConstructorCalledByConstructorInvocation))
/*     */     {
/* 461 */       return new ConstructorCalledByConstructorJoinpoint(((ConstructorCalledByConstructorInvocation)invocation).getCallingConstructor(), ((ConstructorCalledByConstructorInvocation)invocation).getCalledConstructor());
/*     */     }
/*     */ 
/* 464 */     throw new RuntimeException("Invocation type not handled " + invocation);
/*     */   }
/*     */ 
/*     */   public String getAdviceString()
/*     */   {
/* 470 */     if (this.adviceString == null)
/*     */     {
/* 472 */       StringBuffer buf = new StringBuffer();
/* 473 */       switch (1.$SwitchMap$org$jboss$aop$advice$AdviceType[getType().ordinal()])
/*     */       {
/*     */       case 1:
/* 476 */         buf.append("R");
/* 477 */         break;
/*     */       case 2:
/* 479 */         buf.append("B");
/* 480 */         break;
/*     */       case 3:
/* 482 */         buf.append("A");
/* 483 */         break;
/*     */       case 4:
/* 485 */         buf.append("T");
/* 486 */         break;
/*     */       case 5:
/* 488 */         buf.append("F");
/* 489 */         break;
/*     */       default:
/* 491 */         throw new RuntimeException("No such interceptor");
/*     */       }
/*     */ 
/* 494 */       buf.append("~#$%");
/* 495 */       buf.append(getAspectClassName());
/* 496 */       buf.append("->");
/* 497 */       buf.append(getAdviceName());
/* 498 */       this.adviceString = buf.toString();
/*     */     }
/*     */ 
/* 501 */     return this.adviceString;
/*     */   }
/*     */ 
/*     */   private class GeneratedOnlyInterceptor implements Interceptor
/*     */   {
/*     */     String name;
/*     */ 
/*     */     GeneratedOnlyInterceptor(String name, InterceptorFactory factory) {
/* 510 */       this.name = name;
/* 511 */       GeneratedAdvisorInterceptor.logger.warn(factory.getType().getName() + " interceptor:s'" + name + "' is ignored for dynamic invocation. Adding null GeneratedOnlyInterceptor in its place");
/*     */     }
/*     */ 
/*     */     public String getName()
/*     */     {
/* 518 */       return this.name;
/*     */     }
/*     */ 
/*     */     public Object invoke(Invocation invocation) throws Throwable
/*     */     {
/* 523 */       return invocation.invokeNext();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.GeneratedAdvisorInterceptor
 * JD-Core Version:    0.6.0
 */