/*     */ package org.jboss.aop.advice;
/*     */ 
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.util.xml.XmlLoadable;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class AspectFactoryDelegator extends AspectFactoryWithClassLoaderSupport
/*     */ {
/*     */   private AspectFactory factory;
/*     */   private String factoryClass;
/*     */   private Element element;
/*     */ 
/*     */   public AspectFactoryDelegator(String factory, Element element)
/*     */   {
/*  44 */     this.factoryClass = factory;
/*  45 */     this.element = element;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  50 */     return this.factoryClass;
/*     */   }
/*     */ 
/*     */   public Element getElement()
/*     */   {
/*  55 */     return this.element;
/*     */   }
/*     */ 
/*     */   public void setElement(Element element)
/*     */   {
/*  60 */     this.element = element;
/*     */   }
/*     */ 
/*     */   public synchronized AspectFactory getFactory()
/*     */   {
/*  65 */     if (this.factory == null)
/*     */     {
/*     */       try
/*     */       {
/*  69 */         Class clazz = super.loadClass(this.factoryClass);
/*  70 */         this.factory = ((AspectFactory)clazz.newInstance());
/*  71 */         if (XmlLoadable.class.isAssignableFrom(this.factory.getClass()))
/*     */         {
/*  73 */           ((XmlLoadable)this.factory).importXml(this.element);
/*     */         }
/*  75 */         if (AspectFactoryWithClassLoader.class.isAssignableFrom(this.factory.getClass()))
/*     */         {
/*  77 */           if (super.getLoader() != null)
/*     */           {
/*  79 */             ((AspectFactoryWithClassLoader)this.factory).setClassLoader(super.getLoader());
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/*  85 */         throw new RuntimeException(e);
/*     */       }
/*     */       catch (InstantiationException e)
/*     */       {
/*  89 */         throw new RuntimeException(e);
/*     */       }
/*     */       catch (IllegalAccessException e)
/*     */       {
/*  93 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/*  96 */     return this.factory;
/*     */   }
/*     */ 
/*     */   public Object createPerVM()
/*     */   {
/* 101 */     Object aspect = getFactory().createPerVM();
/* 102 */     return aspect;
/*     */   }
/*     */ 
/*     */   public Object createPerClass(Advisor advisor)
/*     */   {
/* 107 */     Object aspect = getFactory().createPerClass(advisor);
/* 108 */     return aspect;
/*     */   }
/*     */ 
/*     */   public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor)
/*     */   {
/* 113 */     Object aspect = getFactory().createPerInstance(advisor, instanceAdvisor);
/* 114 */     return aspect;
/*     */   }
/*     */ 
/*     */   public Object createPerJoinpoint(Advisor advisor, Joinpoint jp)
/*     */   {
/* 119 */     Object aspect = getFactory().createPerJoinpoint(advisor, jp);
/* 120 */     return aspect;
/*     */   }
/*     */ 
/*     */   public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp)
/*     */   {
/* 125 */     Object aspect = getFactory().createPerJoinpoint(advisor, instanceAdvisor, jp);
/* 126 */     return aspect;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.AspectFactoryDelegator
 * JD-Core Version:    0.6.0
 */