/*     */ package org.jboss.aop.advice;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.WeakHashMap;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.GeneratedClassAdvisor;
/*     */ 
/*     */ public class AspectDefinition
/*     */ {
/*     */   protected String name;
/*  41 */   protected Scope scope = Scope.PER_VM;
/*     */   protected AspectFactory factory;
/*  43 */   protected boolean deployed = true;
/*     */ 
/*     */   /** @deprecated */
/*  48 */   public Map advisors = new WeakHashMap();
/*     */ 
/*     */   public AspectDefinition(String name, Scope scope, AspectFactory factory)
/*     */   {
/*  58 */     this.name = name;
/*  59 */     this.scope = scope;
/*  60 */     this.factory = factory;
/*  61 */     if (this.scope == null) this.scope = Scope.PER_VM;
/*  62 */     if (this.name == null) this.name = this.factory.getName(); 
/*     */   }
/*     */ 
/*     */   public AspectDefinition()
/*     */   {
/*     */   }
/*     */ 
/*     */   public synchronized void undeploy() {
/*  69 */     if (this.advisors.size() > 0)
/*     */     {
/*  71 */       for (Iterator it = this.advisors.keySet().iterator(); it.hasNext(); )
/*     */       {
/*  73 */         Advisor advisor = (Advisor)it.next();
/*  74 */         if (advisor != null)
/*     */         {
/*  76 */           it.remove();
/*  77 */           if (this.scope == Scope.PER_INSTANCE)
/*     */           {
/*  79 */             advisor.removePerInstanceAspect(this);
/*     */           }
/*  81 */           else if (this.scope == Scope.PER_JOINPOINT)
/*     */           {
/*  83 */             advisor.removePerInstanceJoinpointAspect(this);
/*     */           }
/*  85 */           else if (this.scope == Scope.PER_CLASS)
/*     */           {
/*  87 */             advisor.removePerClassAspect(this);
/*  88 */             if ((advisor instanceof GeneratedClassAdvisor))
/*     */             {
/*  91 */               ((GeneratedClassAdvisor)advisor).removePerClassJoinpointAspect(this);
/*     */             }
/*     */           }
/*  94 */           else if (this.scope == Scope.PER_CLASS_JOINPOINT)
/*     */           {
/*  96 */             if ((advisor instanceof GeneratedClassAdvisor))
/*     */             {
/*  99 */               ((GeneratedClassAdvisor)advisor).removePerClassJoinpointAspect(this);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/* 104 */       this.advisors.clear();
/*     */     }
/* 106 */     this.deployed = false;
/*     */   }
/*     */ 
/*     */   public boolean isDeployed() {
/* 110 */     return this.deployed;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 115 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public void setScope(Scope scope)
/*     */   {
/* 120 */     this.scope = scope;
/*     */   }
/*     */ 
/*     */   public void setFactory(AspectFactory factory)
/*     */   {
/* 125 */     this.factory = factory;
/*     */   }
/*     */ 
/*     */   public AspectFactory getFactory()
/*     */   {
/* 130 */     return this.factory;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 135 */     return this.name;
/*     */   }
/*     */ 
/*     */   public Scope getScope()
/*     */   {
/* 140 */     return this.scope;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 145 */     return this.name.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 150 */     if (obj == this) return true;
/* 151 */     if (!(obj instanceof AspectDefinition)) return false;
/* 152 */     return this.name.equals(((AspectDefinition)obj).name);
/*     */   }
/*     */ 
/*     */   public synchronized void registerAdvisor(Advisor advisor)
/*     */   {
/* 157 */     this.advisors.put(advisor, Boolean.TRUE);
/*     */   }
/*     */ 
/*     */   public synchronized void unregisterAdvisor(Advisor advisor)
/*     */   {
/* 162 */     this.advisors.remove(advisor);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.AspectDefinition
 * JD-Core Version:    0.6.0
 */