/*     */ package org.jboss.aop.advice;
/*     */ 
/*     */ import java.io.StringReader;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.WeakHashMap;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.pointcut.Pointcut;
/*     */ import org.jboss.aop.pointcut.PointcutExpression;
/*     */ import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
/*     */ import org.jboss.aop.pointcut.ast.ParseException;
/*     */ import org.jboss.aop.pointcut.ast.PointcutExpressionParser;
/*     */ import org.jboss.aop.util.logging.AOPLogger;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class AdviceBinding
/*     */ {
/*  50 */   private static final Logger logger = AOPLogger.getLogger(AdviceBinding.class);
/*     */ 
/*  52 */   private static volatile long counter = 0L;
/*     */   protected String name;
/*     */   protected Pointcut pointcut;
/*     */   protected ASTCFlowExpression cflow;
/*     */   protected String cflowString;
/*  60 */   protected Map advisors = new WeakHashMap();
/*  61 */   protected InterceptorFactory[] interceptorFactories = new InterceptorFactory[0];
/*     */ 
/*     */   public AdviceBinding() {
/*     */   }
/*     */ 
/*     */   public AdviceBinding(String name, Pointcut p, ASTCFlowExpression cflow, String cflowString, InterceptorFactory[] factories) throws ParseException {
/*  67 */     this.name = name;
/*  68 */     this.interceptorFactories = factories;
/*  69 */     this.cflow = cflow;
/*     */ 
/*  71 */     this.pointcut = p;
/*  72 */     this.cflowString = cflowString;
/*     */   }
/*     */ 
/*     */   public AdviceBinding(String pointcutExpression, String cflow)
/*     */     throws ParseException
/*     */   {
/*  84 */     this(Long.toString(System.currentTimeMillis()) + ":" + Long.toString(counter++), pointcutExpression, cflow);
/*     */   }
/*     */ 
/*     */   public AdviceBinding(String name, String pointcutExpression, String cflow)
/*     */     throws ParseException
/*     */   {
/*  96 */     this.name = name;
/*  97 */     setPointcutExpression(pointcutExpression);
/*  98 */     setCFlowExpression(cflow);
/*  99 */     this.interceptorFactories = new InterceptorFactory[0];
/*     */   }
/*     */ 
/*     */   public void setCFlowExpression(String cflow)
/*     */     throws ParseException
/*     */   {
/* 105 */     if (cflow != null)
/*     */     {
/* 107 */       this.cflowString = cflow;
/* 108 */       this.cflow = new PointcutExpressionParser(new StringReader(this.cflowString)).CFlowExpression();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setPointcutExpression(String pointcutExpression)
/*     */     throws ParseException
/*     */   {
/* 115 */     this.pointcut = new PointcutExpression(Long.toString(System.currentTimeMillis()) + ":" + Long.toString(counter++), pointcutExpression);
/*     */   }
/*     */ 
/*     */   public void addInterceptorFactory(InterceptorFactory factory)
/*     */   {
/* 120 */     List list = Arrays.asList(this.interceptorFactories);
/* 121 */     list = new ArrayList(list);
/* 122 */     list.add(factory);
/* 123 */     this.interceptorFactories = ((InterceptorFactory[])(InterceptorFactory[])list.toArray(new InterceptorFactory[list.size()]));
/*     */   }
/*     */ 
/*     */   public void addInterceptor(Class clazz)
/*     */   {
/* 136 */     addInterceptorFactory(new GenericInterceptorFactory(clazz));
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 141 */     return this.name;
/*     */   }
/*     */ 
/*     */   public InterceptorFactory[] getInterceptorFactories()
/*     */   {
/* 146 */     return this.interceptorFactories;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 151 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public void addAdvisor(Advisor advisor)
/*     */   {
/* 156 */     if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("added advisor: " + advisor.getName() + " from binding: " + this.name);
/*     */ 
/* 159 */     synchronized (this.advisors)
/*     */     {
/* 161 */       this.advisors.put(advisor, Boolean.TRUE);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean hasAdvisors()
/*     */   {
/* 168 */     return this.advisors.size() > 0;
/*     */   }
/*     */ 
/*     */   public ArrayList getAdvisors()
/*     */   {
/* 173 */     ArrayList list = new ArrayList(this.advisors.size());
/* 174 */     synchronized (this.advisors)
/*     */     {
/* 176 */       list.addAll(this.advisors.keySet());
/*     */     }
/* 178 */     return list;
/*     */   }
/*     */ 
/*     */   public void clearAdvisors()
/*     */   {
/* 183 */     synchronized (this.advisors)
/*     */     {
/* 185 */       for (Iterator it = this.advisors.keySet().iterator(); it.hasNext(); )
/*     */       {
/* 187 */         Advisor advisor = (Advisor)it.next();
/* 188 */         if (advisor.getManager().isAdvisorRegistered(advisor))
/*     */         {
/* 190 */           advisor.removeAdviceBinding(this);
/*     */         }
/*     */       }
/* 193 */       this.advisors.clear();
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 199 */     if (obj == this) return true;
/* 200 */     if (!(obj instanceof AdviceBinding)) return false;
/* 201 */     return ((AdviceBinding)obj).getName().equals(this.name);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 206 */     return this.name.hashCode();
/*     */   }
/*     */ 
/*     */   public Pointcut getPointcut()
/*     */   {
/* 211 */     return this.pointcut;
/*     */   }
/*     */ 
/*     */   public ASTCFlowExpression getCFlow()
/*     */   {
/* 216 */     return this.cflow;
/*     */   }
/*     */ 
/*     */   public String getCFlowString()
/*     */   {
/* 221 */     return this.cflowString;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.AdviceBinding
 * JD-Core Version:    0.6.0
 */