/*     */ package org.jboss.aop.advice;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.aop.instrument.Untransformable;
/*     */ import org.jboss.aop.joinpoint.ConstructionInvocation;
/*     */ import org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation;
/*     */ import org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation;
/*     */ import org.jboss.aop.joinpoint.ConstructorInvocation;
/*     */ import org.jboss.aop.joinpoint.FieldInvocation;
/*     */ import org.jboss.aop.joinpoint.FieldReadInvocation;
/*     */ import org.jboss.aop.joinpoint.FieldWriteInvocation;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation;
/*     */ import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ 
/*     */ public abstract class AbstractAdvice
/*     */   implements Interceptor, Untransformable
/*     */ {
/*  47 */   private static final Class[] INVOCATION_SIGNATURE = { Invocation.class };
/*  48 */   private static final Class[] METHOD_SIGNATURE = { MethodInvocation.class };
/*  49 */   private static final Class[] CONSTRUCTOR_SIGNATURE = { ConstructorInvocation.class };
/*  50 */   private static final Class[] CONSTRUCTION_SIGNATURE = { ConstructionInvocation.class };
/*  51 */   private static final Class[] FIELD_SIGNATURE = { FieldInvocation.class };
/*  52 */   private static final Class[] FIELD_READ_SIGNATURE = { FieldReadInvocation.class };
/*  53 */   private static final Class[] FIELD_WRITE_SIGNATURE = { FieldWriteInvocation.class };
/*  54 */   private static final Class[] METHOD_CALLED_BY_METHOD_SIGNATURE = { MethodCalledByMethodInvocation.class };
/*  55 */   private static final Class[] METHOD_CALLED_BY_CONSTRUCTOR_SIGNATURE = { MethodCalledByConstructorInvocation.class };
/*  56 */   private static final Class[] CON_CALLED_BY_METHOD_SIGNATURE = { ConstructorCalledByMethodInvocation.class };
/*  57 */   private static final Class[] CON_CALLED_BY_CONSTRUCTOR_SIGNATURE = { ConstructorCalledByConstructorInvocation.class };
/*     */   protected Method invocationAdvice;
/*     */   protected Method methodAdvice;
/*     */   protected Method constructorAdvice;
/*     */   protected Method constructionAdvice;
/*     */   protected Method fieldAdvice;
/*     */   protected Method fieldReadAdvice;
/*     */   protected Method fieldWriteAdvice;
/*     */   protected Method methodCalledByMethodAdvice;
/*     */   protected Method methodCalledByConstructorAdvice;
/*     */   protected Method conCalledByMethodAdvice;
/*     */   protected Method conCalledByConstructorAdvice;
/*     */   protected Class aspectClass;
/*     */   protected String adviceName;
/*     */ 
/*     */   protected void init(String advice, Class aspectClass)
/*     */   {
/*  74 */     this.aspectClass = aspectClass;
/*  75 */     this.adviceName = advice;
/*  76 */     this.invocationAdvice = findByInvocation(this.adviceName, aspectClass);
/*  77 */     if (this.invocationAdvice == null)
/*     */     {
/*  79 */       this.methodAdvice = findByMethodInvocation(this.adviceName, aspectClass);
/*  80 */       this.constructorAdvice = findByConstructorInvocation(this.adviceName, aspectClass);
/*  81 */       this.constructionAdvice = findByConstructionInvocation(this.adviceName, aspectClass);
/*  82 */       this.fieldAdvice = findByFieldInvocation(this.adviceName, aspectClass);
/*  83 */       if (this.fieldAdvice == null)
/*     */       {
/*  85 */         this.fieldReadAdvice = findByFieldReadInvocation(this.adviceName, aspectClass);
/*  86 */         this.fieldWriteAdvice = findByFieldWriteInvocation(this.adviceName, aspectClass);
/*     */       }
/*  88 */       this.methodCalledByMethodAdvice = findByMethodCalledByMethodInvocation(this.adviceName, aspectClass);
/*  89 */       this.methodCalledByConstructorAdvice = findByMethodCalledByConstructorInvocation(this.adviceName, aspectClass);
/*  90 */       this.conCalledByMethodAdvice = findByConstructorCalledByMethodInvocation(this.adviceName, aspectClass);
/*  91 */       this.conCalledByConstructorAdvice = findByConstructorCalledByConstructorInvocation(this.adviceName, aspectClass);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static Method findByInvocation(String adviceName, Class clazz)
/*     */   {
/*     */     try
/*     */     {
/*  99 */       return clazz.getMethod(adviceName, INVOCATION_SIGNATURE);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */     }
/*     */ 
/* 105 */     return null;
/*     */   }
/*     */ 
/*     */   protected static Method findByMethodInvocation(String adviceName, Class clazz)
/*     */   {
/*     */     try
/*     */     {
/* 112 */       return clazz.getMethod(adviceName, METHOD_SIGNATURE);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */     }
/*     */ 
/* 118 */     return null;
/*     */   }
/*     */ 
/*     */   protected static Method findByFieldInvocation(String adviceName, Class clazz)
/*     */   {
/*     */     try
/*     */     {
/* 125 */       return clazz.getMethod(adviceName, FIELD_SIGNATURE);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */     }
/*     */ 
/* 131 */     return null;
/*     */   }
/*     */ 
/*     */   protected static Method findByFieldReadInvocation(String adviceName, Class clazz)
/*     */   {
/*     */     try
/*     */     {
/* 138 */       return clazz.getMethod(adviceName, FIELD_READ_SIGNATURE);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */     }
/*     */ 
/* 144 */     return null;
/*     */   }
/*     */ 
/*     */   protected static Method findByFieldWriteInvocation(String adviceName, Class clazz)
/*     */   {
/*     */     try
/*     */     {
/* 151 */       return clazz.getMethod(adviceName, FIELD_WRITE_SIGNATURE);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */     }
/*     */ 
/* 157 */     return null;
/*     */   }
/*     */ 
/*     */   protected static Method findByConstructorInvocation(String adviceName, Class clazz)
/*     */   {
/*     */     try
/*     */     {
/* 164 */       return clazz.getMethod(adviceName, CONSTRUCTOR_SIGNATURE);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */     }
/*     */ 
/* 170 */     return null;
/*     */   }
/*     */ 
/*     */   protected static Method findByConstructionInvocation(String adviceName, Class clazz)
/*     */   {
/*     */     try
/*     */     {
/* 177 */       return clazz.getMethod(adviceName, CONSTRUCTION_SIGNATURE);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */     }
/*     */ 
/* 183 */     return null;
/*     */   }
/*     */ 
/*     */   protected static Method findByMethodCalledByMethodInvocation(String adviceName, Class clazz)
/*     */   {
/*     */     try
/*     */     {
/* 190 */       return clazz.getMethod(adviceName, METHOD_CALLED_BY_METHOD_SIGNATURE);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */     }
/*     */ 
/* 196 */     return null;
/*     */   }
/*     */ 
/*     */   protected static Method findByMethodCalledByConstructorInvocation(String adviceName, Class clazz)
/*     */   {
/*     */     try
/*     */     {
/* 203 */       return clazz.getMethod(adviceName, METHOD_CALLED_BY_CONSTRUCTOR_SIGNATURE);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */     }
/*     */ 
/* 209 */     return null;
/*     */   }
/*     */ 
/*     */   protected static Method findByConstructorCalledByMethodInvocation(String adviceName, Class clazz)
/*     */   {
/*     */     try
/*     */     {
/* 216 */       return clazz.getMethod(adviceName, CON_CALLED_BY_METHOD_SIGNATURE);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */     }
/*     */ 
/* 222 */     return null;
/*     */   }
/*     */ 
/*     */   protected static Method findByConstructorCalledByConstructorInvocation(String adviceName, Class clazz)
/*     */   {
/*     */     try
/*     */     {
/* 229 */       return clazz.getMethod(adviceName, CON_CALLED_BY_CONSTRUCTOR_SIGNATURE);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */     }
/*     */ 
/* 235 */     return null;
/*     */   }
/*     */ 
/*     */   protected Method resolveAdvice(Invocation invocation)
/*     */   {
/* 240 */     if (this.invocationAdvice != null) return this.invocationAdvice;
/* 241 */     if ((invocation instanceof MethodInvocation))
/*     */     {
/* 243 */       if (this.methodAdvice == null)
/*     */       {
/* 245 */         throw new IllegalStateException("Unable to resolve MethodInvocation advice " + getName());
/*     */       }
/* 247 */       return this.methodAdvice;
/*     */     }
/* 249 */     if ((invocation instanceof FieldInvocation))
/*     */     {
/* 251 */       if (this.fieldAdvice != null) return this.fieldAdvice;
/* 252 */       if ((invocation instanceof FieldReadInvocation))
/*     */       {
/* 254 */         if (this.fieldReadAdvice == null)
/*     */         {
/* 256 */           throw new IllegalStateException("Unable to resolve FieldReadInvocation advice " + getName());
/*     */         }
/* 258 */         return this.fieldReadAdvice;
/*     */       }
/* 260 */       if ((invocation instanceof FieldWriteInvocation))
/*     */       {
/* 262 */         if (this.fieldWriteAdvice == null)
/*     */         {
/* 264 */           throw new IllegalStateException("Unable to resolve FieldWriteInvocation advice " + getName());
/*     */         }
/* 266 */         return this.fieldWriteAdvice;
/*     */       }
/*     */     }
/* 269 */     if ((invocation instanceof ConstructorInvocation))
/*     */     {
/* 271 */       if (this.constructorAdvice == null)
/*     */       {
/* 273 */         throw new IllegalStateException("Unable to resolve ConstructorInvocation advice " + getName());
/*     */       }
/* 275 */       return this.constructorAdvice;
/*     */     }
/* 277 */     if ((invocation instanceof ConstructionInvocation))
/*     */     {
/* 279 */       if (this.constructionAdvice == null)
/*     */       {
/* 281 */         throw new IllegalStateException("Unable to resolve ConstructionInvocation advice " + getName());
/*     */       }
/* 283 */       return this.constructionAdvice;
/*     */     }
/* 285 */     if ((invocation instanceof MethodCalledByMethodInvocation))
/*     */     {
/* 287 */       if (this.methodCalledByMethodAdvice == null)
/*     */       {
/* 289 */         throw new IllegalStateException("Unable to resolve MethodCalledByMethodInvocation advice " + getName());
/*     */       }
/* 291 */       return this.methodCalledByMethodAdvice;
/*     */     }
/* 293 */     if ((invocation instanceof MethodCalledByConstructorInvocation))
/*     */     {
/* 295 */       if (this.methodCalledByConstructorAdvice == null)
/*     */       {
/* 297 */         throw new IllegalStateException("Unable to resolve MethodCalledByConstructorInvocation advice " + getName());
/*     */       }
/* 299 */       return this.methodCalledByConstructorAdvice;
/*     */     }
/* 301 */     if ((invocation instanceof ConstructorCalledByMethodInvocation))
/*     */     {
/* 303 */       if (this.conCalledByMethodAdvice == null)
/*     */       {
/* 305 */         throw new IllegalStateException("Unable to resolve ConstructorCalledByMethodInvocation advice " + getName());
/*     */       }
/* 307 */       return this.conCalledByMethodAdvice;
/*     */     }
/* 309 */     if ((invocation instanceof ConstructorCalledByConstructorInvocation))
/*     */     {
/* 311 */       if (this.conCalledByMethodAdvice == null)
/*     */       {
/* 313 */         throw new IllegalStateException("Unable to resolve ConstructorCalledByConstructorInvocation advice " + getName());
/*     */       }
/* 315 */       return this.conCalledByConstructorAdvice;
/*     */     }
/* 317 */     throw new RuntimeException("Should Be Unreachable, but unable to discover Advice");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.advice.AbstractAdvice
 * JD-Core Version:    0.6.0
 */