/*     */ package org.jboss.aop;
/*     */ 
/*     */ import java.lang.reflect.AccessibleObject;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import javassist.CtClass;
/*     */ 
/*     */ class SecurityActions
/*     */ {
/*     */   static void setAccessible(AccessibleObject accessibleObject)
/*     */   {
/*  77 */     if (System.getSecurityManager() == null)
/*     */     {
/*  79 */       SetAccessibleAction.NON_PRIVILEGED.setAccessible(accessibleObject);
/*     */     }
/*     */     else
/*     */     {
/*  83 */       SetAccessibleAction.PRIVILEGED.setAccessible(accessibleObject);
/*     */     }
/*     */   }
/*     */ 
/*     */   static void debugWriteFile(CtClass ctClass)
/*     */   {
/* 124 */     if (System.getSecurityManager() == null)
/*     */     {
/* 126 */       CtClassDebugWriteFileAction.NON_PRIVILEGED.debugWriteFile(ctClass);
/*     */     }
/*     */     else
/*     */     {
/* 130 */       CtClassDebugWriteFileAction.PRIVILEGED.debugWriteFile(ctClass);
/*     */     }
/*     */   }
/*     */ 
/*     */   static ClassLoader getContextClassLoader()
/*     */   {
/* 146 */     if (System.getSecurityManager() == null) {
/* 147 */       return Thread.currentThread().getContextClassLoader();
/*     */     }
/* 149 */     return (ClassLoader)AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
/*     */   }
/*     */ 
/*     */   static Constructor[] getDeclaredConstructors(Class clazz)
/*     */   {
/* 178 */     if (System.getSecurityManager() == null)
/*     */     {
/* 180 */       return GetDeclaredConstructorsAction.NON_PRIVILEGED.getDeclaredConstructors(clazz);
/*     */     }
/*     */ 
/* 184 */     return GetDeclaredConstructorsAction.PRIVILEGED.getDeclaredConstructors(clazz);
/*     */   }
/*     */ 
/*     */   static ClassLoader getClassLoader(Class clazz)
/*     */   {
/* 215 */     if (System.getSecurityManager() == null)
/*     */     {
/* 217 */       return GetClassLoaderAction.NON_PRIVILEGED.getClassLoader(clazz);
/*     */     }
/*     */ 
/* 221 */     return GetClassLoaderAction.PRIVILEGED.getClassLoader(clazz);
/*     */   }
/*     */ 
/*     */   static abstract interface GetClassLoaderAction
/*     */   {
/* 193 */     public static final GetClassLoaderAction NON_PRIVILEGED = new GetClassLoaderAction()
/*     */     {
/*     */       public ClassLoader getClassLoader(Class clazz)
/*     */       {
/* 197 */         return clazz.getClassLoader();
/*     */       }
/* 193 */     };
/*     */ 
/* 200 */     public static final GetClassLoaderAction PRIVILEGED = new GetClassLoaderAction()
/*     */     {
/*     */       public ClassLoader getClassLoader(Class clazz)
/*     */       {
/* 204 */         return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(clazz)
/*     */         {
/*     */           public ClassLoader run()
/*     */           {
/* 208 */             return this.val$clazz.getClassLoader();
/*     */           }
/*     */         });
/*     */       }
/* 200 */     };
/*     */ 
/*     */     public abstract ClassLoader getClassLoader(Class paramClass);
/*     */   }
/*     */ 
/*     */   static abstract interface GetDeclaredConstructorsAction
/*     */   {
/* 156 */     public static final GetDeclaredConstructorsAction NON_PRIVILEGED = new GetDeclaredConstructorsAction()
/*     */     {
/*     */       public Constructor[] getDeclaredConstructors(Class clazz)
/*     */       {
/* 160 */         return clazz.getDeclaredConstructors();
/*     */       }
/* 156 */     };
/*     */ 
/* 163 */     public static final GetDeclaredConstructorsAction PRIVILEGED = new GetDeclaredConstructorsAction()
/*     */     {
/*     */       public Constructor[] getDeclaredConstructors(Class clazz)
/*     */       {
/* 167 */         return (Constructor[])AccessController.doPrivileged(new PrivilegedAction(clazz)
/*     */         {
/*     */           public Constructor[] run()
/*     */           {
/* 171 */             return this.val$clazz.getDeclaredConstructors();
/*     */           }
/*     */         });
/*     */       }
/* 163 */     };
/*     */ 
/*     */     public abstract Constructor[] getDeclaredConstructors(Class paramClass);
/*     */   }
/*     */ 
/*     */   public static class GetContextClassLoaderAction
/*     */     implements PrivilegedAction<ClassLoader>
/*     */   {
/* 136 */     public static GetContextClassLoaderAction INSTANCE = new GetContextClassLoaderAction();
/*     */ 
/*     */     public ClassLoader run()
/*     */     {
/* 140 */       return Thread.currentThread().getContextClassLoader();
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface CtClassDebugWriteFileAction
/*     */   {
/*  91 */     public static final CtClassDebugWriteFileAction PRIVILEGED = new CtClassDebugWriteFileAction()
/*     */     {
/*     */       public void debugWriteFile(CtClass ctClass)
/*     */       {
/*     */         try
/*     */         {
/*  97 */           AccessController.doPrivileged(new PrivilegedExceptionAction(ctClass)
/*     */           {
/*     */             public Object run() throws Exception
/*     */             {
/* 101 */               this.val$ctClass.debugWriteFile();
/* 102 */               return null;
/*     */             }
/*     */           });
/*     */         }
/*     */         catch (PrivilegedActionException e)
/*     */         {
/*     */         }
/*     */       }
/*  91 */     };
/*     */ 
/* 113 */     public static final CtClassDebugWriteFileAction NON_PRIVILEGED = new CtClassDebugWriteFileAction()
/*     */     {
/*     */       public void debugWriteFile(CtClass ctClass)
/*     */       {
/* 117 */         ctClass.debugWriteFile();
/*     */       }
/* 113 */     };
/*     */ 
/*     */     public abstract void debugWriteFile(CtClass paramCtClass);
/*     */   }
/*     */ 
/*     */   static abstract interface SetAccessibleAction
/*     */   {
/*  44 */     public static final SetAccessibleAction PRIVILEGED = new SetAccessibleAction()
/*     */     {
/*     */       public void setAccessible(AccessibleObject accessibleObject)
/*     */       {
/*     */         try
/*     */         {
/*  50 */           AccessController.doPrivileged(new PrivilegedExceptionAction(accessibleObject)
/*     */           {
/*     */             public Object run() throws Exception
/*     */             {
/*  54 */               this.val$accessibleObject.setAccessible(true);
/*  55 */               return null;
/*     */             }
/*     */           });
/*     */         }
/*     */         catch (PrivilegedActionException e) {
/*  61 */           throw new RuntimeException("Error setting " + accessibleObject + " as accessible ", e.getException());
/*     */         }
/*     */       }
/*  44 */     };
/*     */ 
/*  66 */     public static final SetAccessibleAction NON_PRIVILEGED = new SetAccessibleAction()
/*     */     {
/*     */       public void setAccessible(AccessibleObject accessibleObject)
/*     */       {
/*  70 */         accessibleObject.setAccessible(true);
/*     */       }
/*  66 */     };
/*     */ 
/*     */     public abstract void setAccessible(AccessibleObject paramAccessibleObject);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.SecurityActions
 * JD-Core Version:    0.6.0
 */