/*     */ package org.jboss.aop;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import org.jboss.aop.advice.AdviceBinding;
/*     */ import org.jboss.aop.joinpoint.MethodJoinpoint;
/*     */ import org.jboss.aop.pointcut.Pointcut;
/*     */ import org.jboss.aop.pointcut.PointcutMethodMatch;
/*     */ import org.jboss.aop.util.logging.AOPLogger;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ class MethodMatchInfo
/*     */ {
/*  39 */   private static final Logger logger = AOPLogger.getLogger(MethodMatchInfo.class);
/*     */   Advisor advisor;
/*     */   MethodInfo info;
/*     */   ArrayList bindings;
/*     */   ArrayList pointcutMethodMatches;
/*     */ 
/*     */   MethodMatchInfo(Advisor advisor, MethodInfo info)
/*     */   {
/*  48 */     this.advisor = advisor;
/*  49 */     this.info = info;
/*     */   }
/*     */ 
/*     */   public void addMatchedBinding(AdviceBinding binding, PointcutMethodMatch pointcutMethodMatch)
/*     */   {
/*  54 */     if (this.bindings == null)
/*     */     {
/*  56 */       this.bindings = new ArrayList();
/*     */     }
/*  58 */     if (this.pointcutMethodMatches == null)
/*     */     {
/*  60 */       this.pointcutMethodMatches = new ArrayList();
/*     */     }
/*  62 */     this.bindings.add(binding);
/*  63 */     this.pointcutMethodMatches.add(pointcutMethodMatch);
/*     */   }
/*     */ 
/*     */   public MethodInfo getInfo()
/*     */   {
/*  68 */     return this.info;
/*     */   }
/*     */ 
/*     */   public void setInfo(MethodInfo info)
/*     */   {
/*  73 */     this.info = info;
/*     */   }
/*     */ 
/*     */   public ArrayList populateBindings()
/*     */   {
/*  78 */     if (this.bindings != null)
/*     */     {
/*  80 */       ArrayList applicableBindings = new ArrayList();
/*  81 */       if (this.advisor.chainOverridingForInheritedMethods())
/*     */       {
/*  83 */         overridePopulateBindings(applicableBindings);
/*     */       }
/*     */       else
/*     */       {
/*  87 */         simplePopulateBindings(applicableBindings);
/*     */       }
/*     */ 
/*  90 */       if (applicableBindings.size() > 0)
/*     */       {
/*  92 */         return applicableBindings;
/*     */       }
/*     */     }
/*  95 */     return null;
/*     */   }
/*     */ 
/*     */   private void simplePopulateBindings(ArrayList applicableBindings)
/*     */   {
/* 100 */     int size = this.bindings.size();
/* 101 */     for (int i = 0; i < size; i++)
/*     */     {
/* 103 */       AdviceBinding binding = (AdviceBinding)this.bindings.get(i);
/* 104 */       applyBinding(applicableBindings, binding);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void overridePopulateBindings(ArrayList applicableBindings)
/*     */   {
/* 110 */     if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("populate bindings for " + this.info.getMethod() + " all bindings");
/* 111 */     int size = this.bindings.size();
/* 112 */     int minMatchLevel = 1000000;
/* 113 */     for (int i = 0; i < size; i++)
/*     */     {
/* 115 */       AdviceBinding binding = (AdviceBinding)this.bindings.get(i);
/* 116 */       PointcutMethodMatch match = (PointcutMethodMatch)this.pointcutMethodMatches.get(i);
/* 117 */       if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug(match.getMatchLevel() + " " + match.getMatchedClass().getName() + " " + binding.getPointcut().getExpr() + " : " + binding.getInterceptorFactories().length);
/*     */ 
/* 119 */       if ((minMatchLevel <= match.getMatchLevel()) || (match.isInstanceOf()))
/*     */         continue;
/* 121 */       minMatchLevel = match.getMatchLevel();
/*     */     }
/*     */ 
/* 125 */     if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug("populate bindings for " + this.info.getMethod() + " actual bindings");
/* 126 */     for (int i = 0; i < size; i++)
/*     */     {
/* 128 */       AdviceBinding binding = (AdviceBinding)this.bindings.get(i);
/* 129 */       PointcutMethodMatch match = (PointcutMethodMatch)this.pointcutMethodMatches.get(i);
/*     */ 
/* 131 */       if ((!match.isInstanceOf()) && (match.getMatchLevel() != minMatchLevel))
/*     */         continue;
/* 133 */       if ((AspectManager.verbose) && (logger.isDebugEnabled())) logger.debug(match.getMatchLevel() + " " + match.getMatchedClass().getName() + " " + binding.getPointcut().getExpr() + " : " + binding.getInterceptorFactories().length);
/* 134 */       applyBinding(applicableBindings, binding);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void applyBinding(ArrayList applicableBindings, AdviceBinding binding)
/*     */   {
/* 141 */     applicableBindings.add(binding);
/* 142 */     binding.addAdvisor(this.advisor);
/* 143 */     this.advisor.pointcutResolved(this.info, binding, new MethodJoinpoint(this.info.getMethod()));
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 148 */     this.bindings = null;
/* 149 */     this.pointcutMethodMatches = null;
/* 150 */     this.info.clear();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.MethodMatchInfo
 * JD-Core Version:    0.6.0
 */