/*     */ package org.jboss.aop;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.aop.joinpoint.MethodCallByConstructor;
/*     */ import org.jboss.aop.joinpoint.MethodCalledByConstructorJoinpoint;
/*     */ 
/*     */ public class MethodByConInfo extends CallerMethodInfo
/*     */   implements MethodCallByConstructor
/*     */ {
/*     */   private final int callingIndex;
/*     */   private final Constructor calling;
/*     */ 
/*     */   public MethodByConInfo(Advisor advisor, Class calledClass, Class callingClass, int callingIndex, Method m, long calledMethodHash, Interceptor[] in)
/*     */   {
/*  47 */     super(advisor, calledClass, m, calledMethodHash, in, callingClass);
/*  48 */     this.callingIndex = callingIndex;
/*  49 */     Advisor tempAdvisor = advisor;
/*  50 */     if (advisor.getClazz() != callingClass)
/*     */     {
/*  52 */       tempAdvisor = advisor.manager.getAdvisor(callingClass);
/*     */     }
/*  54 */     this.calling = tempAdvisor.constructors[callingIndex];
/*     */   }
/*     */ 
/*     */   private MethodByConInfo(MethodByConInfo other)
/*     */   {
/*  62 */     super(other);
/*  63 */     this.callingIndex = other.callingIndex;
/*  64 */     this.calling = other.calling;
/*     */   }
/*     */ 
/*     */   protected Joinpoint internalGetJoinpoint()
/*     */   {
/*  69 */     return new MethodCalledByConstructorJoinpoint(this.calling, getMethod());
/*     */   }
/*     */ 
/*     */   public JoinPointInfo copy()
/*     */   {
/*  74 */     return new MethodByConInfo(this);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  79 */     StringBuffer sb = new StringBuffer("Method called by Constructor");
/*  80 */     sb.append("[");
/*  81 */     sb.append("calling=" + this.calling);
/*  82 */     sb.append(",called=" + getMethod());
/*  83 */     sb.append("]");
/*  84 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public int getCallingIndex()
/*     */   {
/*  89 */     return this.callingIndex;
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   public Constructor getCalling() {
/*  95 */     return this.calling;
/*     */   }
/*     */ 
/*     */   public Constructor getCallingConstructor()
/*     */   {
/* 100 */     return this.calling;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.MethodByConInfo
 * JD-Core Version:    0.6.0
 */