/*    */ package org.jboss.aop;
/*    */ 
/*    */ import java.util.LinkedHashMap;
/*    */ import org.jboss.aop.advice.AdviceBinding;
/*    */ import org.jboss.aop.metadata.ClassMetaDataBinding;
/*    */ 
/*    */ public class InstanceDomain extends Domain
/*    */ {
/*    */   protected Advisor advisor;
/*    */ 
/*    */   public InstanceDomain(AspectManager manager, String name, boolean parentFirst)
/*    */   {
/* 38 */     super(manager, name, parentFirst);
/* 39 */     setInheritsBindings(true);
/*    */   }
/*    */ 
/*    */   public Advisor getAdvisor()
/*    */   {
/* 44 */     return this.advisor;
/*    */   }
/*    */ 
/*    */   public void setAdvisor(Advisor advisor)
/*    */   {
/* 49 */     this.advisor = advisor;
/*    */   }
/*    */ 
/*    */   public synchronized void addBinding(AdviceBinding binding)
/*    */   {
/* 54 */     removeBinding(binding.getName());
/* 55 */     super.initBindingsMap();
/* 56 */     synchronized (this.bindings)
/*    */     {
/* 58 */       this.bindings.put(binding.getName(), binding);
/*    */     }
/* 60 */     if (this.advisor != null) this.advisor.newBindingAdded();
/*    */   }
/*    */ 
/*    */   public void addClassMetaData(ClassMetaDataBinding meta)
/*    */   {
/* 65 */     removeClassMetaData(meta.getName());
/* 66 */     if (this.advisor != null)
/*    */     {
/* 68 */       if (meta.matches(this.advisor, this.advisor.getClazz()))
/*    */       {
/* 70 */         meta.addAdvisor(this.advisor);
/*    */       }
/*    */     }
/*    */   }
/*    */ 
/*    */   public boolean isAdvisorRegistered(Advisor advisor)
/*    */   {
/* 85 */     return advisor == advisor;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.InstanceDomain
 * JD-Core Version:    0.6.0
 */