/*     */ package org.jboss.aop;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.WeakHashMap;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.aop.advice.AspectDefinition;
/*     */ import org.jboss.aop.advice.AspectFactory;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ 
/*     */ public class InstanceAdvisorDelegate
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -5421366346785427537L;
/*     */   protected transient WeakReference classAdvisor;
/*     */   InstanceAdvisor instanceAdvisor;
/*     */   protected transient WeakHashMap aspects;
/*     */   protected transient WeakHashMap joinpointAspects;
/*     */   protected SimpleMetaData metadata;
/*     */ 
/*     */   public InstanceAdvisorDelegate(Advisor classAdvisor, InstanceAdvisor instanceAdvisor)
/*     */   {
/*  56 */     this.instanceAdvisor = instanceAdvisor;
/*  57 */     this.classAdvisor = new WeakReference(classAdvisor);
/*     */   }
/*     */ 
/*     */   public Advisor getAdvisor()
/*     */   {
/*  62 */     if (this.classAdvisor != null)
/*     */     {
/*  64 */       return (Advisor)this.classAdvisor.get();
/*     */     }
/*  66 */     return null;
/*     */   }
/*     */ 
/*     */   public void initialize()
/*     */   {
/*  71 */     initializeAspects();
/*  72 */     initializeJoinpointAspects();
/*     */   }
/*     */ 
/*     */   private Advisor getClassAdvisor()
/*     */   {
/*  77 */     return getAdvisor();
/*     */   }
/*     */ 
/*     */   private synchronized void initializeAspects()
/*     */   {
/*  82 */     if (getClassAdvisor() == null) return;
/*  83 */     if (this.aspects != null) return;
/*     */     Advisor ia;
/*     */     Iterator it;
/*  85 */     if ((this.instanceAdvisor instanceof Advisor))
/*     */     {
/*  87 */       ia = (Advisor)this.instanceAdvisor;
/*  88 */       Set instanceDefs = ia.getPerInstanceAspectDefinitions();
/*  89 */       if (instanceDefs.size() > 0)
/*     */       {
/*  91 */         this.aspects = new WeakHashMap();
/*  92 */         for (it = instanceDefs.iterator(); it.hasNext(); )
/*     */         {
/*  94 */           AspectDefinition def = (AspectDefinition)it.next();
/*  95 */           ia.addPerInstanceAspect(def);
/*  96 */           Object aspect = def.getFactory().createPerInstance(getClassAdvisor(), this.instanceAdvisor);
/*  97 */           this.aspects.put(def, aspect);
/*     */         }
/*     */       }
/*     */     }
/* 101 */     Set defs = getClassAdvisor().getPerInstanceAspectDefinitions();
/* 102 */     if (defs.size() > 0)
/*     */     {
/* 104 */       if (this.aspects == null)
/*     */       {
/* 106 */         this.aspects = new WeakHashMap();
/*     */       }
/* 108 */       Iterator it = defs.iterator();
/* 109 */       while (it.hasNext())
/*     */       {
/* 111 */         AspectDefinition def = (AspectDefinition)it.next();
/* 112 */         Object aspect = def.getFactory().createPerInstance(getClassAdvisor(), this.instanceAdvisor);
/* 113 */         this.aspects.put(def, aspect);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private synchronized void initializeJoinpointAspects()
/*     */   {
/* 120 */     if (getClassAdvisor() == null) return;
/* 121 */     if (this.joinpointAspects != null) return;
/*     */     Advisor ia;
/*     */     Map instanceJpAspects;
/*     */     Iterator it;
/* 122 */     if ((this.instanceAdvisor instanceof Advisor))
/*     */     {
/* 124 */       ia = (Advisor)this.instanceAdvisor;
/* 125 */       instanceJpAspects = ia.getPerInstanceJoinpointAspectDefinitions();
/*     */ 
/* 127 */       if (instanceJpAspects.size() > 0)
/*     */       {
/* 129 */         this.joinpointAspects = new WeakHashMap();
/* 130 */         for (it = instanceJpAspects.keySet().iterator(); it.hasNext(); )
/*     */         {
/* 132 */           AspectDefinition def = (AspectDefinition)it.next();
/* 133 */           initJoinpointAspect(def, instanceJpAspects);
/* 134 */           Set joinpoints = (Set)instanceJpAspects.get(def);
/* 135 */           ia.addPerInstanceJoinpointAspect(joinpoints, def);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 140 */     Map jpAspects = getClassAdvisor().getPerInstanceJoinpointAspectDefinitions();
/* 141 */     if (jpAspects.size() > 0)
/*     */     {
/* 143 */       this.joinpointAspects = new WeakHashMap();
/* 144 */       Iterator it = jpAspects.keySet().iterator();
/* 145 */       while (it.hasNext())
/*     */       {
/* 147 */         AspectDefinition def = (AspectDefinition)it.next();
/* 148 */         initJoinpointAspect(def, jpAspects);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void initJoinpointAspect(AspectDefinition def, Map jpAspects)
/*     */   {
/* 155 */     ConcurrentHashMap joins = new ConcurrentHashMap();
/* 156 */     this.joinpointAspects.put(def, joins);
/* 157 */     Set joinpoints = (Set)jpAspects.get(def);
/* 158 */     Iterator jps = joinpoints.iterator();
/* 159 */     while (jps.hasNext())
/*     */     {
/* 161 */       Object joinpoint = jps.next();
/* 162 */       joins.put(joinpoint, def.getFactory().createPerJoinpoint(getClassAdvisor(), this.instanceAdvisor, (Joinpoint)joinpoint));
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getPerInstanceAspect(String def)
/*     */   {
/* 168 */     Iterator it = this.aspects.keySet().iterator();
/* 169 */     while (it.hasNext())
/*     */     {
/* 171 */       AspectDefinition d = (AspectDefinition)it.next();
/* 172 */       if (d.getName().equals(def)) return this.aspects.get(d);
/*     */     }
/* 174 */     return null;
/*     */   }
/*     */ 
/*     */   public Object getPerInstanceAspect(AspectDefinition def)
/*     */   {
/* 179 */     if (this.aspects == null)
/*     */     {
/* 181 */       initializeAspects();
/* 182 */       return this.aspects.get(def);
/*     */     }
/* 184 */     Object aspect = this.aspects.get(def);
/* 185 */     if (aspect == null)
/*     */     {
/* 187 */       synchronized (this)
/*     */       {
/* 189 */         aspect = this.aspects.get(def);
/* 190 */         if (aspect != null) return aspect;
/* 191 */         if ((this.classAdvisor != null) && ((getClassAdvisor() instanceof ClassAdvisor)))
/*     */         {
/* 193 */           ClassAdvisor cadvisor = (ClassAdvisor)getClassAdvisor();
/* 194 */           cadvisor.getPerInstanceAspectDefinitions().add(def);
/* 195 */           aspect = def.getFactory().createPerInstance(null, null);
/* 196 */           WeakHashMap copy = new WeakHashMap(this.aspects);
/* 197 */           copy.put(def, aspect);
/* 198 */           this.aspects = copy;
/*     */         }
/*     */       }
/*     */     }
/* 202 */     return aspect;
/*     */   }
/*     */ 
/*     */   public Object getPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition def)
/*     */   {
/* 208 */     if (this.joinpointAspects == null)
/*     */     {
/* 210 */       initializeJoinpointAspects();
/* 211 */       return getJoinpointAspect(def, joinpoint);
/*     */     }
/* 213 */     Object aspect = getJoinpointAspect(def, joinpoint);
/* 214 */     if (aspect == null)
/*     */     {
/* 216 */       synchronized (this)
/*     */       {
/* 218 */         aspect = getJoinpointAspect(def, joinpoint);
/* 219 */         if (aspect != null) return aspect;
/* 220 */         if ((this.classAdvisor != null) && ((getClassAdvisor() instanceof ClassAdvisor)))
/*     */         {
/* 222 */           ClassAdvisor cadvisor = (ClassAdvisor)getClassAdvisor();
/* 223 */           cadvisor.addPerInstanceJoinpointAspect(joinpoint, def);
/* 224 */           aspect = def.getFactory().createPerJoinpoint(getClassAdvisor(), this.instanceAdvisor, joinpoint);
/* 225 */           WeakHashMap copy = new WeakHashMap(this.joinpointAspects);
/* 226 */           Map map = (Map)copy.get(def);
/* 227 */           if (map == null)
/*     */           {
/* 229 */             map = new ConcurrentHashMap();
/*     */           }
/* 231 */           map.put(joinpoint, aspect);
/* 232 */           this.joinpointAspects = copy;
/*     */         }
/*     */       }
/*     */     }
/* 236 */     return aspect;
/*     */   }
/*     */ 
/*     */   private Object getJoinpointAspect(AspectDefinition def, Joinpoint joinpoint)
/*     */   {
/* 241 */     if (this.joinpointAspects == null) return null;
/* 242 */     Map map = (Map)this.joinpointAspects.get(def);
/* 243 */     Object aspect = map.get(joinpoint);
/* 244 */     return aspect;
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getMetaData()
/*     */   {
/* 249 */     if (this.metadata == null)
/*     */     {
/* 251 */       synchronized (this)
/*     */       {
/* 253 */         if (this.metadata == null)
/*     */         {
/* 255 */           this.metadata = new SimpleMetaData();
/*     */         }
/*     */       }
/*     */     }
/* 259 */     return this.metadata;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.InstanceAdvisorDelegate
 * JD-Core Version:    0.6.0
 */